/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata like FaceId, UserID, and Reasons, for a face that was unsuccessfully associated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsuccessfulFaceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<UnsuccessfulFaceAssociation.Builder, UnsuccessfulFaceAssociation> {
    private static final SdkField<String> FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FaceId")
            .getter(getter(UnsuccessfulFaceAssociation::faceId)).setter(setter(Builder::faceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UnsuccessfulFaceAssociation::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(UnsuccessfulFaceAssociation::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<List<String>> REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Reasons")
            .getter(getter(UnsuccessfulFaceAssociation::reasonsAsStrings))
            .setter(setter(Builder::reasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_ID_FIELD, USER_ID_FIELD,
            CONFIDENCE_FIELD, REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String faceId;

    private final String userId;

    private final Float confidence;

    private final List<String> reasons;

    private UnsuccessfulFaceAssociation(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.userId = builder.userId;
        this.confidence = builder.confidence;
        this.reasons = builder.reasons;
    }

    /**
     * <p>
     * A unique identifier assigned to the face.
     * </p>
     * 
     * @return A unique identifier assigned to the face.
     */
    public final String faceId() {
        return faceId;
    }

    /**
     * <p>
     * A provided ID for the UserID. Unique within the collection.
     * </p>
     * 
     * @return A provided ID for the UserID. Unique within the collection.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Match confidence with the UserID, provides information regarding if a face association was unsuccessful because
     * it didn't meet UserMatchThreshold.
     * </p>
     * 
     * @return Match confidence with the UserID, provides information regarding if a face association was unsuccessful
     *         because it didn't meet UserMatchThreshold.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The reason why the association was unsuccessful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The reason why the association was unsuccessful.
     */
    public final List<UnsuccessfulFaceAssociationReason> reasons() {
        return UnsuccessfulFaceAssociationReasonsCopier.copyStringToEnum(reasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reason why the association was unsuccessful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The reason why the association was unsuccessful.
     */
    public final List<String> reasonsAsStrings() {
        return reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulFaceAssociation)) {
            return false;
        }
        UnsuccessfulFaceAssociation other = (UnsuccessfulFaceAssociation) obj;
        return Objects.equals(faceId(), other.faceId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(confidence(), other.confidence()) && hasReasons() == other.hasReasons()
                && Objects.equals(reasonsAsStrings(), other.reasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnsuccessfulFaceAssociation").add("FaceId", faceId()).add("UserId", userId())
                .add("Confidence", confidence()).add("Reasons", hasReasons() ? reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceId":
            return Optional.ofNullable(clazz.cast(faceId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Reasons":
            return Optional.ofNullable(clazz.cast(reasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FaceId", FACE_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Reasons", REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnsuccessfulFaceAssociation, T> g) {
        return obj -> g.apply((UnsuccessfulFaceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnsuccessfulFaceAssociation> {
        /**
         * <p>
         * A unique identifier assigned to the face.
         * </p>
         * 
         * @param faceId
         *        A unique identifier assigned to the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * A provided ID for the UserID. Unique within the collection.
         * </p>
         * 
         * @param userId
         *        A provided ID for the UserID. Unique within the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Match confidence with the UserID, provides information regarding if a face association was unsuccessful
         * because it didn't meet UserMatchThreshold.
         * </p>
         * 
         * @param confidence
         *        Match confidence with the UserID, provides information regarding if a face association was
         *        unsuccessful because it didn't meet UserMatchThreshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The reason why the association was unsuccessful.
         * </p>
         * 
         * @param reasons
         *        The reason why the association was unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(Collection<String> reasons);

        /**
         * <p>
         * The reason why the association was unsuccessful.
         * </p>
         * 
         * @param reasons
         *        The reason why the association was unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(String... reasons);

        /**
         * <p>
         * The reason why the association was unsuccessful.
         * </p>
         * 
         * @param reasons
         *        The reason why the association was unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<UnsuccessfulFaceAssociationReason> reasons);

        /**
         * <p>
         * The reason why the association was unsuccessful.
         * </p>
         * 
         * @param reasons
         *        The reason why the association was unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(UnsuccessfulFaceAssociationReason... reasons);
    }

    static final class BuilderImpl implements Builder {
        private String faceId;

        private String userId;

        private Float confidence;

        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulFaceAssociation model) {
            faceId(model.faceId);
            userId(model.userId);
            confidence(model.confidence);
            reasonsWithStrings(model.reasons);
        }

        public final String getFaceId() {
            return faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Collection<String> getReasons() {
            if (reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = UnsuccessfulFaceAssociationReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = UnsuccessfulFaceAssociationReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String... reasons) {
            reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnsuccessfulFaceAssociationReason> reasons) {
            this.reasons = UnsuccessfulFaceAssociationReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnsuccessfulFaceAssociationReason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        public UnsuccessfulFaceAssociation build() {
            return new UnsuccessfulFaceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
