/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the direction the eyes are gazing in (independent of the head pose) as determined by its pitch and yaw.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EyeDirection implements SdkPojo, Serializable, ToCopyableBuilder<EyeDirection.Builder, EyeDirection> {
    private static final SdkField<Float> YAW_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Yaw")
            .getter(getter(EyeDirection::yaw)).setter(setter(Builder::yaw))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Yaw").build()).build();

    private static final SdkField<Float> PITCH_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Pitch")
            .getter(getter(EyeDirection::pitch)).setter(setter(Builder::pitch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pitch").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(EyeDirection::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(YAW_FIELD, PITCH_FIELD,
            CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float yaw;

    private final Float pitch;

    private final Float confidence;

    private EyeDirection(BuilderImpl builder) {
        this.yaw = builder.yaw;
        this.pitch = builder.pitch;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Value representing eye direction on the yaw axis.
     * </p>
     * 
     * @return Value representing eye direction on the yaw axis.
     */
    public final Float yaw() {
        return yaw;
    }

    /**
     * <p>
     * Value representing eye direction on the pitch axis.
     * </p>
     * 
     * @return Value representing eye direction on the pitch axis.
     */
    public final Float pitch() {
        return pitch;
    }

    /**
     * <p>
     * The confidence that the service has in its predicted eye direction.
     * </p>
     * 
     * @return The confidence that the service has in its predicted eye direction.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(yaw());
        hashCode = 31 * hashCode + Objects.hashCode(pitch());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EyeDirection)) {
            return false;
        }
        EyeDirection other = (EyeDirection) obj;
        return Objects.equals(yaw(), other.yaw()) && Objects.equals(pitch(), other.pitch())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EyeDirection").add("Yaw", yaw()).add("Pitch", pitch()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Yaw":
            return Optional.ofNullable(clazz.cast(yaw()));
        case "Pitch":
            return Optional.ofNullable(clazz.cast(pitch()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Yaw", YAW_FIELD);
        map.put("Pitch", PITCH_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EyeDirection, T> g) {
        return obj -> g.apply((EyeDirection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EyeDirection> {
        /**
         * <p>
         * Value representing eye direction on the yaw axis.
         * </p>
         * 
         * @param yaw
         *        Value representing eye direction on the yaw axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yaw(Float yaw);

        /**
         * <p>
         * Value representing eye direction on the pitch axis.
         * </p>
         * 
         * @param pitch
         *        Value representing eye direction on the pitch axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pitch(Float pitch);

        /**
         * <p>
         * The confidence that the service has in its predicted eye direction.
         * </p>
         * 
         * @param confidence
         *        The confidence that the service has in its predicted eye direction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private Float yaw;

        private Float pitch;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(EyeDirection model) {
            yaw(model.yaw);
            pitch(model.pitch);
            confidence(model.confidence);
        }

        public final Float getYaw() {
            return yaw;
        }

        public final void setYaw(Float yaw) {
            this.yaw = yaw;
        }

        @Override
        public final Builder yaw(Float yaw) {
            this.yaw = yaw;
            return this;
        }

        public final Float getPitch() {
            return pitch;
        }

        public final void setPitch(Float pitch) {
            this.pitch = pitch;
        }

        @Override
        public final Builder pitch(Float pitch) {
            this.pitch = pitch;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public EyeDirection build() {
            return new EyeDirection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
