/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and
 * completion status of a video analysis operation.
 * </p>
 * <p>
 * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video
 * stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at
 * second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a
 * pet at second 4.
 * </p>
 * <p>
 * Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session
 * is complete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorNotificationChannel implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessorNotificationChannel.Builder, StreamProcessorNotificationChannel> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SNSTopicArn").getter(getter(StreamProcessorNotificationChannel::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopicArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String snsTopicArn;

    private StreamProcessorNotificationChannel(BuilderImpl builder) {
        this.snsTopicArn = builder.snsTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon
     * Rekognition posts the completion status.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon
     *         Rekognition posts the completion status.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorNotificationChannel)) {
            return false;
        }
        StreamProcessorNotificationChannel other = (StreamProcessorNotificationChannel) obj;
        return Objects.equals(snsTopicArn(), other.snsTopicArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessorNotificationChannel").add("SNSTopicArn", snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SNSTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SNSTopicArn", SNS_TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorNotificationChannel, T> g) {
        return obj -> g.apply((StreamProcessorNotificationChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessorNotificationChannel> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon
         * Rekognition posts the completion status.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which
         *        Amazon Rekognition posts the completion status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);
    }

    static final class BuilderImpl implements Builder {
        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorNotificationChannel model) {
            snsTopicArn(model.snsTopicArn);
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        @Override
        public StreamProcessorNotificationChannel build() {
            return new StreamProcessorNotificationChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
