/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides UserID metadata along with the confidence in the match of this UserID with the input face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserMatch implements SdkPojo, Serializable, ToCopyableBuilder<UserMatch.Builder, UserMatch> {
    private static final SdkField<Float> SIMILARITY_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Similarity").getter(getter(UserMatch::similarity)).setter(setter(Builder::similarity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Similarity").build()).build();

    private static final SdkField<MatchedUser> USER_FIELD = SdkField.<MatchedUser> builder(MarshallingType.SDK_POJO)
            .memberName("User").getter(getter(UserMatch::user)).setter(setter(Builder::user)).constructor(MatchedUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMILARITY_FIELD, USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float similarity;

    private final MatchedUser user;

    private UserMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.user = builder.user;
    }

    /**
     * <p>
     * Describes the UserID metadata.
     * </p>
     * 
     * @return Describes the UserID metadata.
     */
    public final Float similarity() {
        return similarity;
    }

    /**
     * <p>
     * Confidence in the match of this UserID with the input face.
     * </p>
     * 
     * @return Confidence in the match of this UserID with the input face.
     */
    public final MatchedUser user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(similarity());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserMatch)) {
            return false;
        }
        UserMatch other = (UserMatch) obj;
        return Objects.equals(similarity(), other.similarity()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserMatch").add("Similarity", similarity()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Similarity":
            return Optional.ofNullable(clazz.cast(similarity()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Similarity", SIMILARITY_FIELD);
        map.put("User", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserMatch, T> g) {
        return obj -> g.apply((UserMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserMatch> {
        /**
         * <p>
         * Describes the UserID metadata.
         * </p>
         * 
         * @param similarity
         *        Describes the UserID metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarity(Float similarity);

        /**
         * <p>
         * Confidence in the match of this UserID with the input face.
         * </p>
         * 
         * @param user
         *        Confidence in the match of this UserID with the input face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(MatchedUser user);

        /**
         * <p>
         * Confidence in the match of this UserID with the input face.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchedUser.Builder} avoiding the need to
         * create one manually via {@link MatchedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchedUser.Builder#build()} is called immediately and its result
         * is passed to {@link #user(MatchedUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link MatchedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(MatchedUser)
         */
        default Builder user(Consumer<MatchedUser.Builder> user) {
            return user(MatchedUser.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float similarity;

        private MatchedUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(UserMatch model) {
            similarity(model.similarity);
            user(model.user);
        }

        public final Float getSimilarity() {
            return similarity;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final MatchedUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(MatchedUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(MatchedUser user) {
            this.user = user;
            return this;
        }

        @Override
        public UserMatch build() {
            return new UserMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
