/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The foreground of the image with regard to image quality and dominant colors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsImageForeground implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectLabelsImageForeground.Builder, DetectLabelsImageForeground> {
    private static final SdkField<DetectLabelsImageQuality> QUALITY_FIELD = SdkField
            .<DetectLabelsImageQuality> builder(MarshallingType.SDK_POJO).memberName("Quality")
            .getter(getter(DetectLabelsImageForeground::quality)).setter(setter(Builder::quality))
            .constructor(DetectLabelsImageQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quality").build()).build();

    private static final SdkField<List<DominantColor>> DOMINANT_COLORS_FIELD = SdkField
            .<List<DominantColor>> builder(MarshallingType.LIST)
            .memberName("DominantColors")
            .getter(getter(DetectLabelsImageForeground::dominantColors))
            .setter(setter(Builder::dominantColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DominantColors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DominantColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(DominantColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALITY_FIELD,
            DOMINANT_COLORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DetectLabelsImageQuality quality;

    private final List<DominantColor> dominantColors;

    private DetectLabelsImageForeground(BuilderImpl builder) {
        this.quality = builder.quality;
        this.dominantColors = builder.dominantColors;
    }

    /**
     * <p>
     * The quality of the image foreground as defined by brightness and sharpness.
     * </p>
     * 
     * @return The quality of the image foreground as defined by brightness and sharpness.
     */
    public final DetectLabelsImageQuality quality() {
        return quality;
    }

    /**
     * For responses, this returns true if the service returned a value for the DominantColors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDominantColors() {
        return dominantColors != null && !(dominantColors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dominant colors found in the foreground of an image, defined with RGB values, CSS color name, simplified
     * color name, and PixelPercentage (the percentage of image pixels that have a particular color).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDominantColors} method.
     * </p>
     * 
     * @return The dominant colors found in the foreground of an image, defined with RGB values, CSS color name,
     *         simplified color name, and PixelPercentage (the percentage of image pixels that have a particular color).
     */
    public final List<DominantColor> dominantColors() {
        return dominantColors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quality());
        hashCode = 31 * hashCode + Objects.hashCode(hasDominantColors() ? dominantColors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsImageForeground)) {
            return false;
        }
        DetectLabelsImageForeground other = (DetectLabelsImageForeground) obj;
        return Objects.equals(quality(), other.quality()) && hasDominantColors() == other.hasDominantColors()
                && Objects.equals(dominantColors(), other.dominantColors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectLabelsImageForeground").add("Quality", quality())
                .add("DominantColors", hasDominantColors() ? dominantColors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quality":
            return Optional.ofNullable(clazz.cast(quality()));
        case "DominantColors":
            return Optional.ofNullable(clazz.cast(dominantColors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Quality", QUALITY_FIELD);
        map.put("DominantColors", DOMINANT_COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsImageForeground, T> g) {
        return obj -> g.apply((DetectLabelsImageForeground) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectLabelsImageForeground> {
        /**
         * <p>
         * The quality of the image foreground as defined by brightness and sharpness.
         * </p>
         * 
         * @param quality
         *        The quality of the image foreground as defined by brightness and sharpness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quality(DetectLabelsImageQuality quality);

        /**
         * <p>
         * The quality of the image foreground as defined by brightness and sharpness.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectLabelsImageQuality.Builder}
         * avoiding the need to create one manually via {@link DetectLabelsImageQuality#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectLabelsImageQuality.Builder#build()} is called immediately
         * and its result is passed to {@link #quality(DetectLabelsImageQuality)}.
         * 
         * @param quality
         *        a consumer that will call methods on {@link DetectLabelsImageQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quality(DetectLabelsImageQuality)
         */
        default Builder quality(Consumer<DetectLabelsImageQuality.Builder> quality) {
            return quality(DetectLabelsImageQuality.builder().applyMutation(quality).build());
        }

        /**
         * <p>
         * The dominant colors found in the foreground of an image, defined with RGB values, CSS color name, simplified
         * color name, and PixelPercentage (the percentage of image pixels that have a particular color).
         * </p>
         * 
         * @param dominantColors
         *        The dominant colors found in the foreground of an image, defined with RGB values, CSS color name,
         *        simplified color name, and PixelPercentage (the percentage of image pixels that have a particular
         *        color).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dominantColors(Collection<DominantColor> dominantColors);

        /**
         * <p>
         * The dominant colors found in the foreground of an image, defined with RGB values, CSS color name, simplified
         * color name, and PixelPercentage (the percentage of image pixels that have a particular color).
         * </p>
         * 
         * @param dominantColors
         *        The dominant colors found in the foreground of an image, defined with RGB values, CSS color name,
         *        simplified color name, and PixelPercentage (the percentage of image pixels that have a particular
         *        color).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dominantColors(DominantColor... dominantColors);

        /**
         * <p>
         * The dominant colors found in the foreground of an image, defined with RGB values, CSS color name, simplified
         * color name, and PixelPercentage (the percentage of image pixels that have a particular color).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.DominantColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder#build()} is called immediately
         * and its result is passed to {@link #dominantColors(List<DominantColor>)}.
         * 
         * @param dominantColors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.DominantColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dominantColors(java.util.Collection<DominantColor>)
         */
        Builder dominantColors(Consumer<DominantColor.Builder>... dominantColors);
    }

    static final class BuilderImpl implements Builder {
        private DetectLabelsImageQuality quality;

        private List<DominantColor> dominantColors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsImageForeground model) {
            quality(model.quality);
            dominantColors(model.dominantColors);
        }

        public final DetectLabelsImageQuality.Builder getQuality() {
            return quality != null ? quality.toBuilder() : null;
        }

        public final void setQuality(DetectLabelsImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        @Override
        public final Builder quality(DetectLabelsImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final List<DominantColor.Builder> getDominantColors() {
            List<DominantColor.Builder> result = DominantColorsCopier.copyToBuilder(this.dominantColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDominantColors(Collection<DominantColor.BuilderImpl> dominantColors) {
            this.dominantColors = DominantColorsCopier.copyFromBuilder(dominantColors);
        }

        @Override
        public final Builder dominantColors(Collection<DominantColor> dominantColors) {
            this.dominantColors = DominantColorsCopier.copy(dominantColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(DominantColor... dominantColors) {
            dominantColors(Arrays.asList(dominantColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantColors(Consumer<DominantColor.Builder>... dominantColors) {
            dominantColors(Stream.of(dominantColors).map(c -> DominantColor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectLabelsImageForeground build() {
            return new DetectLabelsImageForeground(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
