/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A technical cue or shot detection segment detected in a video. An array of <code>SegmentDetection</code> objects
 * containing all segments detected in a stored video is returned by <a>GetSegmentDetection</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentDetection.Builder, SegmentDetection> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SegmentDetection::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartTimestampMillis").getter(getter(SegmentDetection::startTimestampMillis))
            .setter(setter(Builder::startTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build())
            .build();

    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndTimestampMillis").getter(getter(SegmentDetection::endTimestampMillis))
            .setter(setter(Builder::endTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build())
            .build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(SegmentDetection::durationMillis))
            .setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<String> START_TIMECODE_SMPTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimecodeSMPTE").getter(getter(SegmentDetection::startTimecodeSMPTE))
            .setter(setter(Builder::startTimecodeSMPTE))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimecodeSMPTE").build())
            .build();

    private static final SdkField<String> END_TIMECODE_SMPTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimecodeSMPTE").getter(getter(SegmentDetection::endTimecodeSMPTE))
            .setter(setter(Builder::endTimecodeSMPTE))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimecodeSMPTE").build()).build();

    private static final SdkField<String> DURATION_SMPTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationSMPTE").getter(getter(SegmentDetection::durationSMPTE)).setter(setter(Builder::durationSMPTE))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSMPTE").build()).build();

    private static final SdkField<TechnicalCueSegment> TECHNICAL_CUE_SEGMENT_FIELD = SdkField
            .<TechnicalCueSegment> builder(MarshallingType.SDK_POJO).memberName("TechnicalCueSegment")
            .getter(getter(SegmentDetection::technicalCueSegment)).setter(setter(Builder::technicalCueSegment))
            .constructor(TechnicalCueSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechnicalCueSegment").build())
            .build();

    private static final SdkField<ShotSegment> SHOT_SEGMENT_FIELD = SdkField.<ShotSegment> builder(MarshallingType.SDK_POJO)
            .memberName("ShotSegment").getter(getter(SegmentDetection::shotSegment)).setter(setter(Builder::shotSegment))
            .constructor(ShotSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShotSegment").build()).build();

    private static final SdkField<Long> START_FRAME_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartFrameNumber").getter(getter(SegmentDetection::startFrameNumber))
            .setter(setter(Builder::startFrameNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartFrameNumber").build()).build();

    private static final SdkField<Long> END_FRAME_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndFrameNumber").getter(getter(SegmentDetection::endFrameNumber))
            .setter(setter(Builder::endFrameNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndFrameNumber").build()).build();

    private static final SdkField<Long> DURATION_FRAMES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationFrames").getter(getter(SegmentDetection::durationFrames))
            .setter(setter(Builder::durationFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationFrames").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD, START_TIMECODE_SMPTE_FIELD,
            END_TIMECODE_SMPTE_FIELD, DURATION_SMPTE_FIELD, TECHNICAL_CUE_SEGMENT_FIELD, SHOT_SEGMENT_FIELD,
            START_FRAME_NUMBER_FIELD, END_FRAME_NUMBER_FIELD, DURATION_FRAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Long startTimestampMillis;

    private final Long endTimestampMillis;

    private final Long durationMillis;

    private final String startTimecodeSMPTE;

    private final String endTimecodeSMPTE;

    private final String durationSMPTE;

    private final TechnicalCueSegment technicalCueSegment;

    private final ShotSegment shotSegment;

    private final Long startFrameNumber;

    private final Long endFrameNumber;

    private final Long durationFrames;

    private SegmentDetection(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
        this.startTimecodeSMPTE = builder.startTimecodeSMPTE;
        this.endTimecodeSMPTE = builder.endTimecodeSMPTE;
        this.durationSMPTE = builder.durationSMPTE;
        this.technicalCueSegment = builder.technicalCueSegment;
        this.shotSegment = builder.shotSegment;
        this.startFrameNumber = builder.startFrameNumber;
        this.endFrameNumber = builder.endFrameNumber;
        this.durationFrames = builder.durationFrames;
    }

    /**
     * <p>
     * The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
     * @see SegmentType
     */
    public final SegmentType type() {
        return SegmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
     * @see SegmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start time of the detected segment in milliseconds from the start of the video. This value is rounded down.
     * For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100
     * millis.
     * </p>
     * 
     * @return The start time of the detected segment in milliseconds from the start of the video. This value is rounded
     *         down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a
     *         value of 100 millis.
     */
    public final Long startTimestampMillis() {
        return startTimestampMillis;
    }

    /**
     * <p>
     * The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.
     * </p>
     * 
     * @return The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded
     *         down.
     */
    public final Long endTimestampMillis() {
        return endTimestampMillis;
    }

    /**
     * <p>
     * The duration of the detected segment in milliseconds.
     * </p>
     * 
     * @return The duration of the detected segment in milliseconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment.
     * <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
     * </p>
     * 
     * @return The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment.
     *         <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
     */
    public final String startTimecodeSMPTE() {
        return startTimecodeSMPTE;
    }

    /**
     * <p>
     * The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment.
     * <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
     * </p>
     * 
     * @return The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment.
     *         <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
     */
    public final String endTimecodeSMPTE() {
        return endTimecodeSMPTE;
    }

    /**
     * <p>
     * The duration of the timecode for the detected segment in SMPTE format.
     * </p>
     * 
     * @return The duration of the timecode for the detected segment in SMPTE format.
     */
    public final String durationSMPTE() {
        return durationSMPTE;
    }

    /**
     * <p>
     * If the segment is a technical cue, contains information about the technical cue.
     * </p>
     * 
     * @return If the segment is a technical cue, contains information about the technical cue.
     */
    public final TechnicalCueSegment technicalCueSegment() {
        return technicalCueSegment;
    }

    /**
     * <p>
     * If the segment is a shot detection, contains information about the shot detection.
     * </p>
     * 
     * @return If the segment is a shot detection, contains information about the shot detection.
     */
    public final ShotSegment shotSegment() {
        return shotSegment;
    }

    /**
     * <p>
     * The frame number of the start of a video segment, using a frame index that starts with 0.
     * </p>
     * 
     * @return The frame number of the start of a video segment, using a frame index that starts with 0.
     */
    public final Long startFrameNumber() {
        return startFrameNumber;
    }

    /**
     * <p>
     * The frame number at the end of a video segment, using a frame index that starts with 0.
     * </p>
     * 
     * @return The frame number at the end of a video segment, using a frame index that starts with 0.
     */
    public final Long endFrameNumber() {
        return endFrameNumber;
    }

    /**
     * <p>
     * The duration of a video segment, expressed in frames.
     * </p>
     * 
     * @return The duration of a video segment, expressed in frames.
     */
    public final Long durationFrames() {
        return durationFrames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(endTimecodeSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(durationSMPTE());
        hashCode = 31 * hashCode + Objects.hashCode(technicalCueSegment());
        hashCode = 31 * hashCode + Objects.hashCode(shotSegment());
        hashCode = 31 * hashCode + Objects.hashCode(startFrameNumber());
        hashCode = 31 * hashCode + Objects.hashCode(endFrameNumber());
        hashCode = 31 * hashCode + Objects.hashCode(durationFrames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDetection)) {
            return false;
        }
        SegmentDetection other = (SegmentDetection) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(startTimestampMillis(), other.startTimestampMillis())
                && Objects.equals(endTimestampMillis(), other.endTimestampMillis())
                && Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(startTimecodeSMPTE(), other.startTimecodeSMPTE())
                && Objects.equals(endTimecodeSMPTE(), other.endTimecodeSMPTE())
                && Objects.equals(durationSMPTE(), other.durationSMPTE())
                && Objects.equals(technicalCueSegment(), other.technicalCueSegment())
                && Objects.equals(shotSegment(), other.shotSegment())
                && Objects.equals(startFrameNumber(), other.startFrameNumber())
                && Objects.equals(endFrameNumber(), other.endFrameNumber())
                && Objects.equals(durationFrames(), other.durationFrames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentDetection").add("Type", typeAsString())
                .add("StartTimestampMillis", startTimestampMillis()).add("EndTimestampMillis", endTimestampMillis())
                .add("DurationMillis", durationMillis()).add("StartTimecodeSMPTE", startTimecodeSMPTE())
                .add("EndTimecodeSMPTE", endTimecodeSMPTE()).add("DurationSMPTE", durationSMPTE())
                .add("TechnicalCueSegment", technicalCueSegment()).add("ShotSegment", shotSegment())
                .add("StartFrameNumber", startFrameNumber()).add("EndFrameNumber", endFrameNumber())
                .add("DurationFrames", durationFrames()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "StartTimestampMillis":
            return Optional.ofNullable(clazz.cast(startTimestampMillis()));
        case "EndTimestampMillis":
            return Optional.ofNullable(clazz.cast(endTimestampMillis()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "StartTimecodeSMPTE":
            return Optional.ofNullable(clazz.cast(startTimecodeSMPTE()));
        case "EndTimecodeSMPTE":
            return Optional.ofNullable(clazz.cast(endTimecodeSMPTE()));
        case "DurationSMPTE":
            return Optional.ofNullable(clazz.cast(durationSMPTE()));
        case "TechnicalCueSegment":
            return Optional.ofNullable(clazz.cast(technicalCueSegment()));
        case "ShotSegment":
            return Optional.ofNullable(clazz.cast(shotSegment()));
        case "StartFrameNumber":
            return Optional.ofNullable(clazz.cast(startFrameNumber()));
        case "EndFrameNumber":
            return Optional.ofNullable(clazz.cast(endFrameNumber()));
        case "DurationFrames":
            return Optional.ofNullable(clazz.cast(durationFrames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("StartTimestampMillis", START_TIMESTAMP_MILLIS_FIELD);
        map.put("EndTimestampMillis", END_TIMESTAMP_MILLIS_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("StartTimecodeSMPTE", START_TIMECODE_SMPTE_FIELD);
        map.put("EndTimecodeSMPTE", END_TIMECODE_SMPTE_FIELD);
        map.put("DurationSMPTE", DURATION_SMPTE_FIELD);
        map.put("TechnicalCueSegment", TECHNICAL_CUE_SEGMENT_FIELD);
        map.put("ShotSegment", SHOT_SEGMENT_FIELD);
        map.put("StartFrameNumber", START_FRAME_NUMBER_FIELD);
        map.put("EndFrameNumber", END_FRAME_NUMBER_FIELD);
        map.put("DurationFrames", DURATION_FRAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentDetection, T> g) {
        return obj -> g.apply((SegmentDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentDetection> {
        /**
         * <p>
         * The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
         * </p>
         * 
         * @param type
         *        The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
         * </p>
         * 
         * @param type
         *        The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder type(SegmentType type);

        /**
         * <p>
         * The start time of the detected segment in milliseconds from the start of the video. This value is rounded
         * down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value
         * of 100 millis.
         * </p>
         * 
         * @param startTimestampMillis
         *        The start time of the detected segment in milliseconds from the start of the video. This value is
         *        rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video
         *        returns a value of 100 millis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestampMillis(Long startTimestampMillis);

        /**
         * <p>
         * The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded
         * down.
         * </p>
         * 
         * @param endTimestampMillis
         *        The end time of the detected segment, in milliseconds, from the start of the video. This value is
         *        rounded down.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestampMillis(Long endTimestampMillis);

        /**
         * <p>
         * The duration of the detected segment in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the detected segment in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment.
         * <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
         * </p>
         * 
         * @param startTimecodeSMPTE
         *        The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment.
         *        <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecodeSMPTE(String startTimecodeSMPTE);

        /**
         * <p>
         * The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment.
         * <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
         * </p>
         * 
         * @param endTimecodeSMPTE
         *        The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment.
         *        <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimecodeSMPTE(String endTimecodeSMPTE);

        /**
         * <p>
         * The duration of the timecode for the detected segment in SMPTE format.
         * </p>
         * 
         * @param durationSMPTE
         *        The duration of the timecode for the detected segment in SMPTE format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSMPTE(String durationSMPTE);

        /**
         * <p>
         * If the segment is a technical cue, contains information about the technical cue.
         * </p>
         * 
         * @param technicalCueSegment
         *        If the segment is a technical cue, contains information about the technical cue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder technicalCueSegment(TechnicalCueSegment technicalCueSegment);

        /**
         * <p>
         * If the segment is a technical cue, contains information about the technical cue.
         * </p>
         * This is a convenience method that creates an instance of the {@link TechnicalCueSegment.Builder} avoiding the
         * need to create one manually via {@link TechnicalCueSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TechnicalCueSegment.Builder#build()} is called immediately and
         * its result is passed to {@link #technicalCueSegment(TechnicalCueSegment)}.
         * 
         * @param technicalCueSegment
         *        a consumer that will call methods on {@link TechnicalCueSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #technicalCueSegment(TechnicalCueSegment)
         */
        default Builder technicalCueSegment(Consumer<TechnicalCueSegment.Builder> technicalCueSegment) {
            return technicalCueSegment(TechnicalCueSegment.builder().applyMutation(technicalCueSegment).build());
        }

        /**
         * <p>
         * If the segment is a shot detection, contains information about the shot detection.
         * </p>
         * 
         * @param shotSegment
         *        If the segment is a shot detection, contains information about the shot detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shotSegment(ShotSegment shotSegment);

        /**
         * <p>
         * If the segment is a shot detection, contains information about the shot detection.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShotSegment.Builder} avoiding the need to
         * create one manually via {@link ShotSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShotSegment.Builder#build()} is called immediately and its result
         * is passed to {@link #shotSegment(ShotSegment)}.
         * 
         * @param shotSegment
         *        a consumer that will call methods on {@link ShotSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shotSegment(ShotSegment)
         */
        default Builder shotSegment(Consumer<ShotSegment.Builder> shotSegment) {
            return shotSegment(ShotSegment.builder().applyMutation(shotSegment).build());
        }

        /**
         * <p>
         * The frame number of the start of a video segment, using a frame index that starts with 0.
         * </p>
         * 
         * @param startFrameNumber
         *        The frame number of the start of a video segment, using a frame index that starts with 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFrameNumber(Long startFrameNumber);

        /**
         * <p>
         * The frame number at the end of a video segment, using a frame index that starts with 0.
         * </p>
         * 
         * @param endFrameNumber
         *        The frame number at the end of a video segment, using a frame index that starts with 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endFrameNumber(Long endFrameNumber);

        /**
         * <p>
         * The duration of a video segment, expressed in frames.
         * </p>
         * 
         * @param durationFrames
         *        The duration of a video segment, expressed in frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationFrames(Long durationFrames);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Long startTimestampMillis;

        private Long endTimestampMillis;

        private Long durationMillis;

        private String startTimecodeSMPTE;

        private String endTimecodeSMPTE;

        private String durationSMPTE;

        private TechnicalCueSegment technicalCueSegment;

        private ShotSegment shotSegment;

        private Long startFrameNumber;

        private Long endFrameNumber;

        private Long durationFrames;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDetection model) {
            type(model.type);
            startTimestampMillis(model.startTimestampMillis);
            endTimestampMillis(model.endTimestampMillis);
            durationMillis(model.durationMillis);
            startTimecodeSMPTE(model.startTimecodeSMPTE);
            endTimecodeSMPTE(model.endTimecodeSMPTE);
            durationSMPTE(model.durationSMPTE);
            technicalCueSegment(model.technicalCueSegment);
            shotSegment(model.shotSegment);
            startFrameNumber(model.startFrameNumber);
            endFrameNumber(model.endFrameNumber);
            durationFrames(model.durationFrames);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SegmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Long getStartTimestampMillis() {
            return startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getStartTimecodeSMPTE() {
            return startTimecodeSMPTE;
        }

        public final void setStartTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
        }

        @Override
        public final Builder startTimecodeSMPTE(String startTimecodeSMPTE) {
            this.startTimecodeSMPTE = startTimecodeSMPTE;
            return this;
        }

        public final String getEndTimecodeSMPTE() {
            return endTimecodeSMPTE;
        }

        public final void setEndTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
        }

        @Override
        public final Builder endTimecodeSMPTE(String endTimecodeSMPTE) {
            this.endTimecodeSMPTE = endTimecodeSMPTE;
            return this;
        }

        public final String getDurationSMPTE() {
            return durationSMPTE;
        }

        public final void setDurationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
        }

        @Override
        public final Builder durationSMPTE(String durationSMPTE) {
            this.durationSMPTE = durationSMPTE;
            return this;
        }

        public final TechnicalCueSegment.Builder getTechnicalCueSegment() {
            return technicalCueSegment != null ? technicalCueSegment.toBuilder() : null;
        }

        public final void setTechnicalCueSegment(TechnicalCueSegment.BuilderImpl technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment != null ? technicalCueSegment.build() : null;
        }

        @Override
        public final Builder technicalCueSegment(TechnicalCueSegment technicalCueSegment) {
            this.technicalCueSegment = technicalCueSegment;
            return this;
        }

        public final ShotSegment.Builder getShotSegment() {
            return shotSegment != null ? shotSegment.toBuilder() : null;
        }

        public final void setShotSegment(ShotSegment.BuilderImpl shotSegment) {
            this.shotSegment = shotSegment != null ? shotSegment.build() : null;
        }

        @Override
        public final Builder shotSegment(ShotSegment shotSegment) {
            this.shotSegment = shotSegment;
            return this;
        }

        public final Long getStartFrameNumber() {
            return startFrameNumber;
        }

        public final void setStartFrameNumber(Long startFrameNumber) {
            this.startFrameNumber = startFrameNumber;
        }

        @Override
        public final Builder startFrameNumber(Long startFrameNumber) {
            this.startFrameNumber = startFrameNumber;
            return this;
        }

        public final Long getEndFrameNumber() {
            return endFrameNumber;
        }

        public final void setEndFrameNumber(Long endFrameNumber) {
            this.endFrameNumber = endFrameNumber;
        }

        @Override
        public final Builder endFrameNumber(Long endFrameNumber) {
            this.endFrameNumber = endFrameNumber;
            return this;
        }

        public final Long getDurationFrames() {
            return durationFrames;
        }

        public final void setDurationFrames(Long durationFrames) {
            this.durationFrames = durationFrames;
        }

        @Override
        public final Builder durationFrames(Long durationFrames) {
            this.durationFrames = durationFrames;
            return this;
        }

        @Override
        public SegmentDetection build() {
            return new SegmentDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
