/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFaceLivenessSessionRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateFaceLivenessSessionRequest.Builder, CreateFaceLivenessSessionRequest> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateFaceLivenessSessionRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<CreateFaceLivenessSessionRequestSettings> SETTINGS_FIELD = SdkField
            .<CreateFaceLivenessSessionRequestSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(CreateFaceLivenessSessionRequest::settings)).setter(setter(Builder::settings))
            .constructor(CreateFaceLivenessSessionRequestSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(CreateFaceLivenessSessionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            SETTINGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String kmsKeyId;

    private final CreateFaceLivenessSessionRequestSettings settings;

    private final String clientRequestToken;

    private CreateFaceLivenessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.settings = builder.settings;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and reference
     * images.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and
     *         reference images.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A session settings object. It contains settings for the operation to be performed. For Face Liveness, it accepts
     * <code>OutputConfig</code> and <code>AuditImagesLimit</code>.
     * </p>
     * 
     * @return A session settings object. It contains settings for the operation to be performed. For Face Liveness, it
     *         accepts <code>OutputConfig</code> and <code>AuditImagesLimit</code>.
     */
    public final CreateFaceLivenessSessionRequestSettings settings() {
        return settings;
    }

    /**
     * <p>
     * Idempotent token is used to recognize the Face Liveness request. If the same token is used with multiple
     * <code>CreateFaceLivenessSession</code> requests, the same session is returned. This token is employed to avoid
     * unintentionally creating the same session multiple times.
     * </p>
     * 
     * @return Idempotent token is used to recognize the Face Liveness request. If the same token is used with multiple
     *         <code>CreateFaceLivenessSession</code> requests, the same session is returned. This token is employed to
     *         avoid unintentionally creating the same session multiple times.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFaceLivenessSessionRequest)) {
            return false;
        }
        CreateFaceLivenessSessionRequest other = (CreateFaceLivenessSessionRequest) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(settings(), other.settings())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFaceLivenessSessionRequest").add("KmsKeyId", kmsKeyId()).add("Settings", settings())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFaceLivenessSessionRequest, T> g) {
        return obj -> g.apply((CreateFaceLivenessSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RekognitionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFaceLivenessSessionRequest> {
        /**
         * <p>
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and
         * reference images.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt audit images and
         *        reference images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A session settings object. It contains settings for the operation to be performed. For Face Liveness, it
         * accepts <code>OutputConfig</code> and <code>AuditImagesLimit</code>.
         * </p>
         * 
         * @param settings
         *        A session settings object. It contains settings for the operation to be performed. For Face Liveness,
         *        it accepts <code>OutputConfig</code> and <code>AuditImagesLimit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(CreateFaceLivenessSessionRequestSettings settings);

        /**
         * <p>
         * A session settings object. It contains settings for the operation to be performed. For Face Liveness, it
         * accepts <code>OutputConfig</code> and <code>AuditImagesLimit</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateFaceLivenessSessionRequestSettings.Builder} avoiding the need to create one manually via
         * {@link CreateFaceLivenessSessionRequestSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFaceLivenessSessionRequestSettings.Builder#build()} is
         * called immediately and its result is passed to {@link #settings(CreateFaceLivenessSessionRequestSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link CreateFaceLivenessSessionRequestSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(CreateFaceLivenessSessionRequestSettings)
         */
        default Builder settings(Consumer<CreateFaceLivenessSessionRequestSettings.Builder> settings) {
            return settings(CreateFaceLivenessSessionRequestSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * Idempotent token is used to recognize the Face Liveness request. If the same token is used with multiple
         * <code>CreateFaceLivenessSession</code> requests, the same session is returned. This token is employed to
         * avoid unintentionally creating the same session multiple times.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token is used to recognize the Face Liveness request. If the same token is used with
         *        multiple <code>CreateFaceLivenessSession</code> requests, the same session is returned. This token is
         *        employed to avoid unintentionally creating the same session multiple times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String kmsKeyId;

        private CreateFaceLivenessSessionRequestSettings settings;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFaceLivenessSessionRequest model) {
            super(model);
            kmsKeyId(model.kmsKeyId);
            settings(model.settings);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final CreateFaceLivenessSessionRequestSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(CreateFaceLivenessSessionRequestSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(CreateFaceLivenessSessionRequestSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFaceLivenessSessionRequest build() {
            return new CreateFaceLivenessSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
