/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistics about a dataset. For more information, see <a>DescribeDataset</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetStats implements SdkPojo, Serializable, ToCopyableBuilder<DatasetStats.Builder, DatasetStats> {
    private static final SdkField<Integer> LABELED_ENTRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LabeledEntries").getter(getter(DatasetStats::labeledEntries)).setter(setter(Builder::labeledEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabeledEntries").build()).build();

    private static final SdkField<Integer> TOTAL_ENTRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalEntries").getter(getter(DatasetStats::totalEntries)).setter(setter(Builder::totalEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalEntries").build()).build();

    private static final SdkField<Integer> TOTAL_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalLabels").getter(getter(DatasetStats::totalLabels)).setter(setter(Builder::totalLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLabels").build()).build();

    private static final SdkField<Integer> ERROR_ENTRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorEntries").getter(getter(DatasetStats::errorEntries)).setter(setter(Builder::errorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorEntries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELED_ENTRIES_FIELD,
            TOTAL_ENTRIES_FIELD, TOTAL_LABELS_FIELD, ERROR_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer labeledEntries;

    private final Integer totalEntries;

    private final Integer totalLabels;

    private final Integer errorEntries;

    private DatasetStats(BuilderImpl builder) {
        this.labeledEntries = builder.labeledEntries;
        this.totalEntries = builder.totalEntries;
        this.totalLabels = builder.totalLabels;
        this.errorEntries = builder.errorEntries;
    }

    /**
     * <p>
     * The total number of images in the dataset that have labels.
     * </p>
     * 
     * @return The total number of images in the dataset that have labels.
     */
    public final Integer labeledEntries() {
        return labeledEntries;
    }

    /**
     * <p>
     * The total number of images in the dataset.
     * </p>
     * 
     * @return The total number of images in the dataset.
     */
    public final Integer totalEntries() {
        return totalEntries;
    }

    /**
     * <p>
     * The total number of labels declared in the dataset.
     * </p>
     * 
     * @return The total number of labels declared in the dataset.
     */
    public final Integer totalLabels() {
        return totalLabels;
    }

    /**
     * <p>
     * The total number of entries that contain at least one error.
     * </p>
     * 
     * @return The total number of entries that contain at least one error.
     */
    public final Integer errorEntries() {
        return errorEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labeledEntries());
        hashCode = 31 * hashCode + Objects.hashCode(totalEntries());
        hashCode = 31 * hashCode + Objects.hashCode(totalLabels());
        hashCode = 31 * hashCode + Objects.hashCode(errorEntries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetStats)) {
            return false;
        }
        DatasetStats other = (DatasetStats) obj;
        return Objects.equals(labeledEntries(), other.labeledEntries()) && Objects.equals(totalEntries(), other.totalEntries())
                && Objects.equals(totalLabels(), other.totalLabels()) && Objects.equals(errorEntries(), other.errorEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetStats").add("LabeledEntries", labeledEntries()).add("TotalEntries", totalEntries())
                .add("TotalLabels", totalLabels()).add("ErrorEntries", errorEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabeledEntries":
            return Optional.ofNullable(clazz.cast(labeledEntries()));
        case "TotalEntries":
            return Optional.ofNullable(clazz.cast(totalEntries()));
        case "TotalLabels":
            return Optional.ofNullable(clazz.cast(totalLabels()));
        case "ErrorEntries":
            return Optional.ofNullable(clazz.cast(errorEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabeledEntries", LABELED_ENTRIES_FIELD);
        map.put("TotalEntries", TOTAL_ENTRIES_FIELD);
        map.put("TotalLabels", TOTAL_LABELS_FIELD);
        map.put("ErrorEntries", ERROR_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetStats, T> g) {
        return obj -> g.apply((DatasetStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetStats> {
        /**
         * <p>
         * The total number of images in the dataset that have labels.
         * </p>
         * 
         * @param labeledEntries
         *        The total number of images in the dataset that have labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labeledEntries(Integer labeledEntries);

        /**
         * <p>
         * The total number of images in the dataset.
         * </p>
         * 
         * @param totalEntries
         *        The total number of images in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEntries(Integer totalEntries);

        /**
         * <p>
         * The total number of labels declared in the dataset.
         * </p>
         * 
         * @param totalLabels
         *        The total number of labels declared in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalLabels(Integer totalLabels);

        /**
         * <p>
         * The total number of entries that contain at least one error.
         * </p>
         * 
         * @param errorEntries
         *        The total number of entries that contain at least one error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(Integer errorEntries);
    }

    static final class BuilderImpl implements Builder {
        private Integer labeledEntries;

        private Integer totalEntries;

        private Integer totalLabels;

        private Integer errorEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetStats model) {
            labeledEntries(model.labeledEntries);
            totalEntries(model.totalEntries);
            totalLabels(model.totalLabels);
            errorEntries(model.errorEntries);
        }

        public final Integer getLabeledEntries() {
            return labeledEntries;
        }

        public final void setLabeledEntries(Integer labeledEntries) {
            this.labeledEntries = labeledEntries;
        }

        @Override
        public final Builder labeledEntries(Integer labeledEntries) {
            this.labeledEntries = labeledEntries;
            return this;
        }

        public final Integer getTotalEntries() {
            return totalEntries;
        }

        public final void setTotalEntries(Integer totalEntries) {
            this.totalEntries = totalEntries;
        }

        @Override
        public final Builder totalEntries(Integer totalEntries) {
            this.totalEntries = totalEntries;
            return this;
        }

        public final Integer getTotalLabels() {
            return totalLabels;
        }

        public final void setTotalLabels(Integer totalLabels) {
            this.totalLabels = totalLabels;
        }

        @Override
        public final Builder totalLabels(Integer totalLabels) {
            this.totalLabels = totalLabels;
            return this;
        }

        public final Integer getErrorEntries() {
            return errorEntries;
        }

        public final void setErrorEntries(Integer errorEntries) {
            this.errorEntries = errorEntries;
        }

        @Override
        public final Builder errorEntries(Integer errorEntries) {
            this.errorEntries = errorEntries;
            return this;
        }

        @Override
        public DatasetStats build() {
            return new DatasetStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
