/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates or additions to a dataset. A Single update or addition is an entry (JSON Line) that provides
 * information about a single image. To update an existing entry, you match the <code>source-ref</code> field of the
 * update entry with the <code>source-ref</code> filed of the entry that you want to update. If the
 * <code>source-ref</code> field doesn't match an existing entry, the entry is added to dataset as a new entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetChanges implements SdkPojo, Serializable, ToCopyableBuilder<DatasetChanges.Builder, DatasetChanges> {
    private static final SdkField<SdkBytes> GROUND_TRUTH_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("GroundTruth").getter(getter(DatasetChanges::groundTruth)).setter(setter(Builder::groundTruth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes groundTruth;

    private DatasetChanges(BuilderImpl builder) {
        this.groundTruth = builder.groundTruth;
    }

    /**
     * <p>
     * A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions
     * to the dataset. You change a dataset by calling <a>UpdateDatasetEntries</a>. If you are using an AWS SDK to call
     * <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK encodes the data for
     * you.
     * </p>
     * <p>
     * For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in
     * the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     * </p>
     * 
     * @return A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are
     *         additions to the dataset. You change a dataset by calling <a>UpdateDatasetEntries</a>. If you are using
     *         an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as
     *         the SDK encodes the data for you. </p>
     *         <p>
     *         For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest
     *         files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     */
    public final SdkBytes groundTruth() {
        return groundTruth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundTruth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetChanges)) {
            return false;
        }
        DatasetChanges other = (DatasetChanges) obj;
        return Objects.equals(groundTruth(), other.groundTruth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetChanges").add("GroundTruth", groundTruth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroundTruth":
            return Optional.ofNullable(clazz.cast(groundTruth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroundTruth", GROUND_TRUTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetChanges, T> g) {
        return obj -> g.apply((DatasetChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetChanges> {
        /**
         * <p>
         * A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are
         * additions to the dataset. You change a dataset by calling <a>UpdateDatasetEntries</a>. If you are using an
         * AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK
         * encodes the data for you.
         * </p>
         * <p>
         * For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest
         * files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
         * </p>
         * 
         * @param groundTruth
         *        A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are
         *        additions to the dataset. You change a dataset by calling <a>UpdateDatasetEntries</a>. If you are
         *        using an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode
         *        <code>Changes</code> as the SDK encodes the data for you. </p>
         *        <p>
         *        For example JSON lines, see Image-Level labels in manifest files and and Object localization in
         *        manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundTruth(SdkBytes groundTruth);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes groundTruth;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetChanges model) {
            groundTruth(model.groundTruth);
        }

        public final ByteBuffer getGroundTruth() {
            return groundTruth == null ? null : groundTruth.asByteBuffer();
        }

        public final void setGroundTruth(ByteBuffer groundTruth) {
            groundTruth(groundTruth == null ? null : SdkBytes.fromByteBuffer(groundTruth));
        }

        @Override
        public final Builder groundTruth(SdkBytes groundTruth) {
            this.groundTruth = groundTruth;
            return this;
        }

        @Override
        public DatasetChanges build() {
            return new DatasetChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
