/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectProtectiveEquipmentRequest extends RekognitionRequest implements
        ToCopyableBuilder<DetectProtectiveEquipmentRequest.Builder, DetectProtectiveEquipmentRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO).memberName("Image")
            .getter(getter(DetectProtectiveEquipmentRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<ProtectiveEquipmentSummarizationAttributes> SUMMARIZATION_ATTRIBUTES_FIELD = SdkField
            .<ProtectiveEquipmentSummarizationAttributes> builder(MarshallingType.SDK_POJO).memberName("SummarizationAttributes")
            .getter(getter(DetectProtectiveEquipmentRequest::summarizationAttributes))
            .setter(setter(Builder::summarizationAttributes)).constructor(ProtectiveEquipmentSummarizationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummarizationAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD,
            SUMMARIZATION_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Image image;

    private final ProtectiveEquipmentSummarizationAttributes summarizationAttributes;

    private DetectProtectiveEquipmentRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.summarizationAttributes = builder.summarizationAttributes;
    }

    /**
     * <p>
     * The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can
     * reference an image stored in an Amazon S3 bucket.
     * </p>
     * 
     * @return The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or
     *         you can reference an image stored in an Amazon S3 bucket.
     */
    public final Image image() {
        return image;
    }

    /**
     * <p>
     * An array of PPE types that you want to summarize.
     * </p>
     * 
     * @return An array of PPE types that you want to summarize.
     */
    public final ProtectiveEquipmentSummarizationAttributes summarizationAttributes() {
        return summarizationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(summarizationAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProtectiveEquipmentRequest)) {
            return false;
        }
        DetectProtectiveEquipmentRequest other = (DetectProtectiveEquipmentRequest) obj;
        return Objects.equals(image(), other.image())
                && Objects.equals(summarizationAttributes(), other.summarizationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectProtectiveEquipmentRequest").add("Image", image())
                .add("SummarizationAttributes", summarizationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "SummarizationAttributes":
            return Optional.ofNullable(clazz.cast(summarizationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Image", IMAGE_FIELD);
        map.put("SummarizationAttributes", SUMMARIZATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectProtectiveEquipmentRequest, T> g) {
        return obj -> g.apply((DetectProtectiveEquipmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RekognitionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectProtectiveEquipmentRequest> {
        /**
         * <p>
         * The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you
         * can reference an image stored in an Amazon S3 bucket.
         * </p>
         * 
         * @param image
         *        The image in which you want to detect PPE on detected persons. The image can be passed as image bytes
         *        or you can reference an image stored in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you
         * can reference an image stored in an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * An array of PPE types that you want to summarize.
         * </p>
         * 
         * @param summarizationAttributes
         *        An array of PPE types that you want to summarize.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summarizationAttributes(ProtectiveEquipmentSummarizationAttributes summarizationAttributes);

        /**
         * <p>
         * An array of PPE types that you want to summarize.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectiveEquipmentSummarizationAttributes.Builder} avoiding the need to create one manually via
         * {@link ProtectiveEquipmentSummarizationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectiveEquipmentSummarizationAttributes.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #summarizationAttributes(ProtectiveEquipmentSummarizationAttributes)}.
         * 
         * @param summarizationAttributes
         *        a consumer that will call methods on {@link ProtectiveEquipmentSummarizationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summarizationAttributes(ProtectiveEquipmentSummarizationAttributes)
         */
        default Builder summarizationAttributes(
                Consumer<ProtectiveEquipmentSummarizationAttributes.Builder> summarizationAttributes) {
            return summarizationAttributes(ProtectiveEquipmentSummarizationAttributes.builder()
                    .applyMutation(summarizationAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image image;

        private ProtectiveEquipmentSummarizationAttributes summarizationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProtectiveEquipmentRequest model) {
            super(model);
            image(model.image);
            summarizationAttributes(model.summarizationAttributes);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final ProtectiveEquipmentSummarizationAttributes.Builder getSummarizationAttributes() {
            return summarizationAttributes != null ? summarizationAttributes.toBuilder() : null;
        }

        public final void setSummarizationAttributes(
                ProtectiveEquipmentSummarizationAttributes.BuilderImpl summarizationAttributes) {
            this.summarizationAttributes = summarizationAttributes != null ? summarizationAttributes.build() : null;
        }

        @Override
        public final Builder summarizationAttributes(ProtectiveEquipmentSummarizationAttributes summarizationAttributes) {
            this.summarizationAttributes = summarizationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectProtectiveEquipmentRequest build() {
            return new DetectProtectiveEquipmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
