/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the dominant colors in an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DominantColor implements SdkPojo, Serializable, ToCopyableBuilder<DominantColor.Builder, DominantColor> {
    private static final SdkField<Integer> RED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Red")
            .getter(getter(DominantColor::red)).setter(setter(Builder::red))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Red").build()).build();

    private static final SdkField<Integer> BLUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Blue")
            .getter(getter(DominantColor::blue)).setter(setter(Builder::blue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blue").build()).build();

    private static final SdkField<Integer> GREEN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Green")
            .getter(getter(DominantColor::green)).setter(setter(Builder::green))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Green").build()).build();

    private static final SdkField<String> HEX_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HexCode").getter(getter(DominantColor::hexCode)).setter(setter(Builder::hexCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HexCode").build()).build();

    private static final SdkField<String> CSS_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CSSColor").getter(getter(DominantColor::cssColor)).setter(setter(Builder::cssColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSSColor").build()).build();

    private static final SdkField<String> SIMPLIFIED_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SimplifiedColor").getter(getter(DominantColor::simplifiedColor))
            .setter(setter(Builder::simplifiedColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimplifiedColor").build()).build();

    private static final SdkField<Float> PIXEL_PERCENT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("PixelPercent").getter(getter(DominantColor::pixelPercent)).setter(setter(Builder::pixelPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PixelPercent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RED_FIELD, BLUE_FIELD,
            GREEN_FIELD, HEX_CODE_FIELD, CSS_COLOR_FIELD, SIMPLIFIED_COLOR_FIELD, PIXEL_PERCENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer red;

    private final Integer blue;

    private final Integer green;

    private final String hexCode;

    private final String cssColor;

    private final String simplifiedColor;

    private final Float pixelPercent;

    private DominantColor(BuilderImpl builder) {
        this.red = builder.red;
        this.blue = builder.blue;
        this.green = builder.green;
        this.hexCode = builder.hexCode;
        this.cssColor = builder.cssColor;
        this.simplifiedColor = builder.simplifiedColor;
        this.pixelPercent = builder.pixelPercent;
    }

    /**
     * <p>
     * The Red RGB value for a dominant color.
     * </p>
     * 
     * @return The Red RGB value for a dominant color.
     */
    public final Integer red() {
        return red;
    }

    /**
     * <p>
     * The Blue RGB value for a dominant color.
     * </p>
     * 
     * @return The Blue RGB value for a dominant color.
     */
    public final Integer blue() {
        return blue;
    }

    /**
     * <p>
     * The Green RGB value for a dominant color.
     * </p>
     * 
     * @return The Green RGB value for a dominant color.
     */
    public final Integer green() {
        return green;
    }

    /**
     * <p>
     * The Hex code equivalent of the RGB values for a dominant color.
     * </p>
     * 
     * @return The Hex code equivalent of the RGB values for a dominant color.
     */
    public final String hexCode() {
        return hexCode;
    }

    /**
     * <p>
     * The CSS color name of a dominant color.
     * </p>
     * 
     * @return The CSS color name of a dominant color.
     */
    public final String cssColor() {
        return cssColor;
    }

    /**
     * <p>
     * One of 12 simplified color names applied to a dominant color.
     * </p>
     * 
     * @return One of 12 simplified color names applied to a dominant color.
     */
    public final String simplifiedColor() {
        return simplifiedColor;
    }

    /**
     * <p>
     * The percentage of image pixels that have a given dominant color.
     * </p>
     * 
     * @return The percentage of image pixels that have a given dominant color.
     */
    public final Float pixelPercent() {
        return pixelPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(red());
        hashCode = 31 * hashCode + Objects.hashCode(blue());
        hashCode = 31 * hashCode + Objects.hashCode(green());
        hashCode = 31 * hashCode + Objects.hashCode(hexCode());
        hashCode = 31 * hashCode + Objects.hashCode(cssColor());
        hashCode = 31 * hashCode + Objects.hashCode(simplifiedColor());
        hashCode = 31 * hashCode + Objects.hashCode(pixelPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DominantColor)) {
            return false;
        }
        DominantColor other = (DominantColor) obj;
        return Objects.equals(red(), other.red()) && Objects.equals(blue(), other.blue())
                && Objects.equals(green(), other.green()) && Objects.equals(hexCode(), other.hexCode())
                && Objects.equals(cssColor(), other.cssColor()) && Objects.equals(simplifiedColor(), other.simplifiedColor())
                && Objects.equals(pixelPercent(), other.pixelPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DominantColor").add("Red", red()).add("Blue", blue()).add("Green", green())
                .add("HexCode", hexCode()).add("CSSColor", cssColor()).add("SimplifiedColor", simplifiedColor())
                .add("PixelPercent", pixelPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Red":
            return Optional.ofNullable(clazz.cast(red()));
        case "Blue":
            return Optional.ofNullable(clazz.cast(blue()));
        case "Green":
            return Optional.ofNullable(clazz.cast(green()));
        case "HexCode":
            return Optional.ofNullable(clazz.cast(hexCode()));
        case "CSSColor":
            return Optional.ofNullable(clazz.cast(cssColor()));
        case "SimplifiedColor":
            return Optional.ofNullable(clazz.cast(simplifiedColor()));
        case "PixelPercent":
            return Optional.ofNullable(clazz.cast(pixelPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Red", RED_FIELD);
        map.put("Blue", BLUE_FIELD);
        map.put("Green", GREEN_FIELD);
        map.put("HexCode", HEX_CODE_FIELD);
        map.put("CSSColor", CSS_COLOR_FIELD);
        map.put("SimplifiedColor", SIMPLIFIED_COLOR_FIELD);
        map.put("PixelPercent", PIXEL_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DominantColor, T> g) {
        return obj -> g.apply((DominantColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DominantColor> {
        /**
         * <p>
         * The Red RGB value for a dominant color.
         * </p>
         * 
         * @param red
         *        The Red RGB value for a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder red(Integer red);

        /**
         * <p>
         * The Blue RGB value for a dominant color.
         * </p>
         * 
         * @param blue
         *        The Blue RGB value for a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blue(Integer blue);

        /**
         * <p>
         * The Green RGB value for a dominant color.
         * </p>
         * 
         * @param green
         *        The Green RGB value for a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder green(Integer green);

        /**
         * <p>
         * The Hex code equivalent of the RGB values for a dominant color.
         * </p>
         * 
         * @param hexCode
         *        The Hex code equivalent of the RGB values for a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hexCode(String hexCode);

        /**
         * <p>
         * The CSS color name of a dominant color.
         * </p>
         * 
         * @param cssColor
         *        The CSS color name of a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cssColor(String cssColor);

        /**
         * <p>
         * One of 12 simplified color names applied to a dominant color.
         * </p>
         * 
         * @param simplifiedColor
         *        One of 12 simplified color names applied to a dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simplifiedColor(String simplifiedColor);

        /**
         * <p>
         * The percentage of image pixels that have a given dominant color.
         * </p>
         * 
         * @param pixelPercent
         *        The percentage of image pixels that have a given dominant color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pixelPercent(Float pixelPercent);
    }

    static final class BuilderImpl implements Builder {
        private Integer red;

        private Integer blue;

        private Integer green;

        private String hexCode;

        private String cssColor;

        private String simplifiedColor;

        private Float pixelPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(DominantColor model) {
            red(model.red);
            blue(model.blue);
            green(model.green);
            hexCode(model.hexCode);
            cssColor(model.cssColor);
            simplifiedColor(model.simplifiedColor);
            pixelPercent(model.pixelPercent);
        }

        public final Integer getRed() {
            return red;
        }

        public final void setRed(Integer red) {
            this.red = red;
        }

        @Override
        public final Builder red(Integer red) {
            this.red = red;
            return this;
        }

        public final Integer getBlue() {
            return blue;
        }

        public final void setBlue(Integer blue) {
            this.blue = blue;
        }

        @Override
        public final Builder blue(Integer blue) {
            this.blue = blue;
            return this;
        }

        public final Integer getGreen() {
            return green;
        }

        public final void setGreen(Integer green) {
            this.green = green;
        }

        @Override
        public final Builder green(Integer green) {
            this.green = green;
            return this;
        }

        public final String getHexCode() {
            return hexCode;
        }

        public final void setHexCode(String hexCode) {
            this.hexCode = hexCode;
        }

        @Override
        public final Builder hexCode(String hexCode) {
            this.hexCode = hexCode;
            return this;
        }

        public final String getCssColor() {
            return cssColor;
        }

        public final void setCssColor(String cssColor) {
            this.cssColor = cssColor;
        }

        @Override
        public final Builder cssColor(String cssColor) {
            this.cssColor = cssColor;
            return this;
        }

        public final String getSimplifiedColor() {
            return simplifiedColor;
        }

        public final void setSimplifiedColor(String simplifiedColor) {
            this.simplifiedColor = simplifiedColor;
        }

        @Override
        public final Builder simplifiedColor(String simplifiedColor) {
            this.simplifiedColor = simplifiedColor;
            return this;
        }

        public final Float getPixelPercent() {
            return pixelPercent;
        }

        public final void setPixelPercent(Float pixelPercent) {
            this.pixelPercent = pixelPercent;
        }

        @Override
        public final Builder pixelPercent(Float pixelPercent) {
            this.pixelPercent = pixelPercent;
            return this;
        }

        @Override
        public DominantColor build() {
            return new DominantColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
