/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data validation manifest created for the training dataset during model training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDataResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDataResult.Builder, TrainingDataResult> {
    private static final SdkField<TrainingData> INPUT_FIELD = SdkField.<TrainingData> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(TrainingDataResult::input)).setter(setter(Builder::input))
            .constructor(TrainingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<TrainingData> OUTPUT_FIELD = SdkField.<TrainingData> builder(MarshallingType.SDK_POJO)
            .memberName("Output").getter(getter(TrainingDataResult::output)).setter(setter(Builder::output))
            .constructor(TrainingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<ValidationData> VALIDATION_FIELD = SdkField.<ValidationData> builder(MarshallingType.SDK_POJO)
            .memberName("Validation").getter(getter(TrainingDataResult::validation)).setter(setter(Builder::validation))
            .constructor(ValidationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD,
            VALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TrainingData input;

    private final TrainingData output;

    private final ValidationData validation;

    private TrainingDataResult(BuilderImpl builder) {
        this.input = builder.input;
        this.output = builder.output;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * The training data that you supplied.
     * </p>
     * 
     * @return The training data that you supplied.
     */
    public final TrainingData input() {
        return input;
    }

    /**
     * <p>
     * Reference to images (assets) that were actually used during training with trained model predictions.
     * </p>
     * 
     * @return Reference to images (assets) that were actually used during training with trained model predictions.
     */
    public final TrainingData output() {
        return output;
    }

    /**
     * <p>
     * A manifest that you supplied for training, with validation results for each line.
     * </p>
     * 
     * @return A manifest that you supplied for training, with validation results for each line.
     */
    public final ValidationData validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataResult)) {
            return false;
        }
        TrainingDataResult other = (TrainingDataResult) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(output(), other.output())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingDataResult").add("Input", input()).add("Output", output())
                .add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Input", INPUT_FIELD);
        map.put("Output", OUTPUT_FIELD);
        map.put("Validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataResult, T> g) {
        return obj -> g.apply((TrainingDataResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDataResult> {
        /**
         * <p>
         * The training data that you supplied.
         * </p>
         * 
         * @param input
         *        The training data that you supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(TrainingData input);

        /**
         * <p>
         * The training data that you supplied.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingData.Builder} avoiding the need
         * to create one manually via {@link TrainingData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingData.Builder#build()} is called immediately and its
         * result is passed to {@link #input(TrainingData)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link TrainingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(TrainingData)
         */
        default Builder input(Consumer<TrainingData.Builder> input) {
            return input(TrainingData.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Reference to images (assets) that were actually used during training with trained model predictions.
         * </p>
         * 
         * @param output
         *        Reference to images (assets) that were actually used during training with trained model predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(TrainingData output);

        /**
         * <p>
         * Reference to images (assets) that were actually used during training with trained model predictions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingData.Builder} avoiding the need
         * to create one manually via {@link TrainingData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingData.Builder#build()} is called immediately and its
         * result is passed to {@link #output(TrainingData)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link TrainingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(TrainingData)
         */
        default Builder output(Consumer<TrainingData.Builder> output) {
            return output(TrainingData.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * A manifest that you supplied for training, with validation results for each line.
         * </p>
         * 
         * @param validation
         *        A manifest that you supplied for training, with validation results for each line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(ValidationData validation);

        /**
         * <p>
         * A manifest that you supplied for training, with validation results for each line.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationData.Builder} avoiding the need
         * to create one manually via {@link ValidationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationData.Builder#build()} is called immediately and its
         * result is passed to {@link #validation(ValidationData)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link ValidationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(ValidationData)
         */
        default Builder validation(Consumer<ValidationData.Builder> validation) {
            return validation(ValidationData.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrainingData input;

        private TrainingData output;

        private ValidationData validation;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataResult model) {
            input(model.input);
            output(model.output);
            validation(model.validation);
        }

        public final TrainingData.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(TrainingData.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(TrainingData input) {
            this.input = input;
            return this;
        }

        public final TrainingData.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(TrainingData.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(TrainingData output) {
            this.output = output;
            return this;
        }

        public final ValidationData.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        public final void setValidation(ValidationData.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(ValidationData validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public TrainingDataResult build() {
            return new TrainingDataResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
