/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An ordered list of preferred challenge type and versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChallengePreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ChallengePreference.Builder, ChallengePreference> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ChallengePreference::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Versions> VERSIONS_FIELD = SdkField.<Versions> builder(MarshallingType.SDK_POJO)
            .memberName("Versions").getter(getter(ChallengePreference::versions)).setter(setter(Builder::versions))
            .constructor(Versions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Versions versions;

    private ChallengePreference(BuilderImpl builder) {
        this.type = builder.type;
        this.versions = builder.versions;
    }

    /**
     * <p>
     * The types of challenges that have been selected for the Face Liveness session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChallengeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The types of challenges that have been selected for the Face Liveness session.
     * @see ChallengeType
     */
    public final ChallengeType type() {
        return ChallengeType.fromValue(type);
    }

    /**
     * <p>
     * The types of challenges that have been selected for the Face Liveness session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChallengeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The types of challenges that have been selected for the Face Liveness session.
     * @see ChallengeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version of the challenges that have been selected for the Face Liveness session.
     * </p>
     * 
     * @return The version of the challenges that have been selected for the Face Liveness session.
     */
    public final Versions versions() {
        return versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengePreference)) {
            return false;
        }
        ChallengePreference other = (ChallengePreference) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(versions(), other.versions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChallengePreference").add("Type", typeAsString()).add("Versions", versions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Versions", VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChallengePreference, T> g) {
        return obj -> g.apply((ChallengePreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChallengePreference> {
        /**
         * <p>
         * The types of challenges that have been selected for the Face Liveness session.
         * </p>
         * 
         * @param type
         *        The types of challenges that have been selected for the Face Liveness session.
         * @see ChallengeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeType
         */
        Builder type(String type);

        /**
         * <p>
         * The types of challenges that have been selected for the Face Liveness session.
         * </p>
         * 
         * @param type
         *        The types of challenges that have been selected for the Face Liveness session.
         * @see ChallengeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeType
         */
        Builder type(ChallengeType type);

        /**
         * <p>
         * The version of the challenges that have been selected for the Face Liveness session.
         * </p>
         * 
         * @param versions
         *        The version of the challenges that have been selected for the Face Liveness session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Versions versions);

        /**
         * <p>
         * The version of the challenges that have been selected for the Face Liveness session.
         * </p>
         * This is a convenience method that creates an instance of the {@link Versions.Builder} avoiding the need to
         * create one manually via {@link Versions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Versions.Builder#build()} is called immediately and its result is
         * passed to {@link #versions(Versions)}.
         * 
         * @param versions
         *        a consumer that will call methods on {@link Versions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versions(Versions)
         */
        default Builder versions(Consumer<Versions.Builder> versions) {
            return versions(Versions.builder().applyMutation(versions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Versions versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengePreference model) {
            type(model.type);
            versions(model.versions);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChallengeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Versions.Builder getVersions() {
            return versions != null ? versions.toBuilder() : null;
        }

        public final void setVersions(Versions.BuilderImpl versions) {
            this.versions = versions != null ? versions.build() : null;
        }

        @Override
        public final Builder versions(Versions versions) {
            this.versions = versions;
            return this;
        }

        @Override
        public ChallengePreference build() {
            return new ChallengePreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
