/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectTextResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectTextResponse.Builder, DetectTextResponse> {
    private static final SdkField<List<TextDetection>> TEXT_DETECTIONS_FIELD = SdkField
            .<List<TextDetection>> builder(MarshallingType.LIST)
            .memberName("TextDetections")
            .getter(getter(DetectTextResponse::textDetections))
            .setter(setter(Builder::textDetections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextModelVersion").getter(getter(DetectTextResponse::textModelVersion))
            .setter(setter(Builder::textModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_DETECTIONS_FIELD,
            TEXT_MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TextDetection> textDetections;

    private final String textModelVersion;

    private DetectTextResponse(BuilderImpl builder) {
        super(builder);
        this.textDetections = builder.textDetections;
        this.textModelVersion = builder.textModelVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextDetections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextDetections() {
        return textDetections != null && !(textDetections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of text that was detected in the input image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextDetections} method.
     * </p>
     * 
     * @return An array of text that was detected in the input image.
     */
    public final List<TextDetection> textDetections() {
        return textDetections;
    }

    /**
     * <p>
     * The model version used to detect text.
     * </p>
     * 
     * @return The model version used to detect text.
     */
    public final String textModelVersion() {
        return textModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTextDetections() ? textDetections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(textModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectTextResponse)) {
            return false;
        }
        DetectTextResponse other = (DetectTextResponse) obj;
        return hasTextDetections() == other.hasTextDetections() && Objects.equals(textDetections(), other.textDetections())
                && Objects.equals(textModelVersion(), other.textModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectTextResponse").add("TextDetections", hasTextDetections() ? textDetections() : null)
                .add("TextModelVersion", textModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextDetections":
            return Optional.ofNullable(clazz.cast(textDetections()));
        case "TextModelVersion":
            return Optional.ofNullable(clazz.cast(textModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TextDetections", TEXT_DETECTIONS_FIELD);
        map.put("TextModelVersion", TEXT_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectTextResponse, T> g) {
        return obj -> g.apply((DetectTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectTextResponse> {
        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * 
         * @param textDetections
         *        An array of text that was detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDetections(Collection<TextDetection> textDetections);

        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * 
         * @param textDetections
         *        An array of text that was detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDetections(TextDetection... textDetections);

        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.TextDetection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.TextDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.TextDetection.Builder#build()} is called immediately
         * and its result is passed to {@link #textDetections(List<TextDetection>)}.
         * 
         * @param textDetections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.TextDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDetections(java.util.Collection<TextDetection>)
         */
        Builder textDetections(Consumer<TextDetection.Builder>... textDetections);

        /**
         * <p>
         * The model version used to detect text.
         * </p>
         * 
         * @param textModelVersion
         *        The model version used to detect text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textModelVersion(String textModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<TextDetection> textDetections = DefaultSdkAutoConstructList.getInstance();

        private String textModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectTextResponse model) {
            super(model);
            textDetections(model.textDetections);
            textModelVersion(model.textModelVersion);
        }

        public final List<TextDetection.Builder> getTextDetections() {
            List<TextDetection.Builder> result = TextDetectionListCopier.copyToBuilder(this.textDetections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextDetections(Collection<TextDetection.BuilderImpl> textDetections) {
            this.textDetections = TextDetectionListCopier.copyFromBuilder(textDetections);
        }

        @Override
        public final Builder textDetections(Collection<TextDetection> textDetections) {
            this.textDetections = TextDetectionListCopier.copy(textDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(TextDetection... textDetections) {
            textDetections(Arrays.asList(textDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(Consumer<TextDetection.Builder>... textDetections) {
            textDetections(Stream.of(textDetections).map(c -> TextDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTextModelVersion() {
            return textModelVersion;
        }

        public final void setTextModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
        }

        @Override
        public final Builder textModelVersion(String textModelVersion) {
            this.textModelVersion = textModelVersion;
            return this;
        }

        @Override
        public DetectTextResponse build() {
            return new DetectTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
