/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image that is picked from the Face Liveness video and returned for audit trail purposes, returned as
 * Base64-encoded bytes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditImage implements SdkPojo, Serializable, ToCopyableBuilder<AuditImage.Builder, AuditImage> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Bytes").getter(getter(AuditImage::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()).build();

    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("S3Object").getter(getter(AuditImage::s3Object)).setter(setter(Builder::s3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Object").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(AuditImage::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD, S3_OBJECT_FIELD,
            BOUNDING_BOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes bytes;

    private final S3Object s3Object;

    private final BoundingBox boundingBox;

    private AuditImage(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.s3Object = builder.s3Object;
        this.boundingBox = builder.boundingBox;
    }

    /**
     * <p>
     * The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for audit
     * purposes.
     * </p>
     * 
     * @return The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for
     *         audit purposes.
     */
    public final SdkBytes bytes() {
        return bytes;
    }

    /**
     * Returns the value of the S3Object property for this object.
     * 
     * @return The value of the S3Object property for this object.
     */
    public final S3Object s3Object() {
        return s3Object;
    }

    /**
     * Returns the value of the BoundingBox property for this object.
     * 
     * @return The value of the BoundingBox property for this object.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        hashCode = 31 * hashCode + Objects.hashCode(s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditImage)) {
            return false;
        }
        AuditImage other = (AuditImage) obj;
        return Objects.equals(bytes(), other.bytes()) && Objects.equals(s3Object(), other.s3Object())
                && Objects.equals(boundingBox(), other.boundingBox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditImage").add("Bytes", bytes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("S3Object", s3Object()).add("BoundingBox", boundingBox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        case "S3Object":
            return Optional.ofNullable(clazz.cast(s3Object()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bytes", BYTES_FIELD);
        map.put("S3Object", S3_OBJECT_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditImage, T> g) {
        return obj -> g.apply((AuditImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditImage> {
        /**
         * <p>
         * The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for audit
         * purposes.
         * </p>
         * 
         * @param bytes
         *        The Base64-encoded bytes representing an image selected from the Face Liveness video and returned for
         *        audit purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(SdkBytes bytes);

        /**
         * Sets the value of the S3Object property for this object.
         *
         * @param s3Object
         *        The new value for the S3Object property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Object(S3Object s3Object);

        /**
         * Sets the value of the S3Object property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Object(S3Object)}.
         * 
         * @param s3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Object(S3Object)
         */
        default Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return s3Object(S3Object.builder().applyMutation(s3Object).build());
        }

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * @param boundingBox
         *        The new value for the BoundingBox property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * Sets the value of the BoundingBox property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BoundingBox.Builder} avoiding the need to
         * create one manually via {@link BoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes bytes;

        private S3Object s3Object;

        private BoundingBox boundingBox;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditImage model) {
            bytes(model.bytes);
            s3Object(model.s3Object);
            boundingBox(model.boundingBox);
        }

        public final ByteBuffer getBytes() {
            return bytes == null ? null : bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            bytes(bytes == null ? null : SdkBytes.fromByteBuffer(bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return s3Object != null ? s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        @Override
        public AuditImage build() {
            return new AuditImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
