/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<AssociateFacesResponse.Builder, AssociateFacesResponse> {
    private static final SdkField<List<AssociatedFace>> ASSOCIATED_FACES_FIELD = SdkField
            .<List<AssociatedFace>> builder(MarshallingType.LIST)
            .memberName("AssociatedFaces")
            .getter(getter(AssociateFacesResponse::associatedFaces))
            .setter(setter(Builder::associatedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnsuccessfulFaceAssociation>> UNSUCCESSFUL_FACE_ASSOCIATIONS_FIELD = SdkField
            .<List<UnsuccessfulFaceAssociation>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulFaceAssociations")
            .getter(getter(AssociateFacesResponse::unsuccessfulFaceAssociations))
            .setter(setter(Builder::unsuccessfulFaceAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulFaceAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulFaceAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserStatus").getter(getter(AssociateFacesResponse::userStatusAsString))
            .setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_FACES_FIELD,
            UNSUCCESSFUL_FACE_ASSOCIATIONS_FIELD, USER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociatedFace> associatedFaces;

    private final List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations;

    private final String userStatus;

    private AssociateFacesResponse(BuilderImpl builder) {
        super(builder);
        this.associatedFaces = builder.associatedFaces;
        this.unsuccessfulFaceAssociations = builder.unsuccessfulFaceAssociations;
        this.userStatus = builder.userStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedFaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedFaces() {
        return associatedFaces != null && !(associatedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the UserID.
     * Returned if the AssociateFaces action is successful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedFaces} method.
     * </p>
     * 
     * @return An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the
     *         UserID. Returned if the AssociateFaces action is successful.
     */
    public final List<AssociatedFace> associatedFaces() {
        return associatedFaces;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsuccessfulFaceAssociations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnsuccessfulFaceAssociations() {
        return unsuccessfulFaceAssociations != null && !(unsuccessfulFaceAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated along with
     * the reasons. Returned if the AssociateFaces action is successful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessfulFaceAssociations} method.
     * </p>
     * 
     * @return An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated along
     *         with the reasons. Returned if the AssociateFaces action is successful.
     */
    public final List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations() {
        return unsuccessfulFaceAssociations;
    }

    /**
     * <p>
     * The status of an update made to a UserID. Reflects if the UserID has been updated for every requested change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of an update made to a UserID. Reflects if the UserID has been updated for every requested
     *         change.
     * @see UserStatus
     */
    public final UserStatus userStatus() {
        return UserStatus.fromValue(userStatus);
    }

    /**
     * <p>
     * The status of an update made to a UserID. Reflects if the UserID has been updated for every requested change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of an update made to a UserID. Reflects if the UserID has been updated for every requested
     *         change.
     * @see UserStatus
     */
    public final String userStatusAsString() {
        return userStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedFaces() ? associatedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessfulFaceAssociations() ? unsuccessfulFaceAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFacesResponse)) {
            return false;
        }
        AssociateFacesResponse other = (AssociateFacesResponse) obj;
        return hasAssociatedFaces() == other.hasAssociatedFaces() && Objects.equals(associatedFaces(), other.associatedFaces())
                && hasUnsuccessfulFaceAssociations() == other.hasUnsuccessfulFaceAssociations()
                && Objects.equals(unsuccessfulFaceAssociations(), other.unsuccessfulFaceAssociations())
                && Objects.equals(userStatusAsString(), other.userStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFacesResponse").add("AssociatedFaces", hasAssociatedFaces() ? associatedFaces() : null)
                .add("UnsuccessfulFaceAssociations", hasUnsuccessfulFaceAssociations() ? unsuccessfulFaceAssociations() : null)
                .add("UserStatus", userStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedFaces":
            return Optional.ofNullable(clazz.cast(associatedFaces()));
        case "UnsuccessfulFaceAssociations":
            return Optional.ofNullable(clazz.cast(unsuccessfulFaceAssociations()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociatedFaces", ASSOCIATED_FACES_FIELD);
        map.put("UnsuccessfulFaceAssociations", UNSUCCESSFUL_FACE_ASSOCIATIONS_FIELD);
        map.put("UserStatus", USER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateFacesResponse, T> g) {
        return obj -> g.apply((AssociateFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateFacesResponse> {
        /**
         * <p>
         * An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the UserID.
         * Returned if the AssociateFaces action is successful.
         * </p>
         * 
         * @param associatedFaces
         *        An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the
         *        UserID. Returned if the AssociateFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedFaces(Collection<AssociatedFace> associatedFaces);

        /**
         * <p>
         * An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the UserID.
         * Returned if the AssociateFaces action is successful.
         * </p>
         * 
         * @param associatedFaces
         *        An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the
         *        UserID. Returned if the AssociateFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedFaces(AssociatedFace... associatedFaces);

        /**
         * <p>
         * An array of AssociatedFace objects containing FaceIDs that have been successfully associated with the UserID.
         * Returned if the AssociateFaces action is successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.AssociatedFace.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.AssociatedFace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.AssociatedFace.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedFaces(List<AssociatedFace>)}.
         * 
         * @param associatedFaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.AssociatedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedFaces(java.util.Collection<AssociatedFace>)
         */
        Builder associatedFaces(Consumer<AssociatedFace.Builder>... associatedFaces);

        /**
         * <p>
         * An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated along
         * with the reasons. Returned if the AssociateFaces action is successful.
         * </p>
         * 
         * @param unsuccessfulFaceAssociations
         *        An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated
         *        along with the reasons. Returned if the AssociateFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceAssociations(Collection<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations);

        /**
         * <p>
         * An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated along
         * with the reasons. Returned if the AssociateFaces action is successful.
         * </p>
         * 
         * @param unsuccessfulFaceAssociations
         *        An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated
         *        along with the reasons. Returned if the AssociateFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceAssociations(UnsuccessfulFaceAssociation... unsuccessfulFaceAssociations);

        /**
         * <p>
         * An array of UnsuccessfulAssociation objects containing FaceIDs that are not successfully associated along
         * with the reasons. Returned if the AssociateFaces action is successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unsuccessfulFaceAssociations(List<UnsuccessfulFaceAssociation>)}.
         * 
         * @param unsuccessfulFaceAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulFaceAssociations(java.util.Collection<UnsuccessfulFaceAssociation>)
         */
        Builder unsuccessfulFaceAssociations(Consumer<UnsuccessfulFaceAssociation.Builder>... unsuccessfulFaceAssociations);

        /**
         * <p>
         * The status of an update made to a UserID. Reflects if the UserID has been updated for every requested change.
         * </p>
         * 
         * @param userStatus
         *        The status of an update made to a UserID. Reflects if the UserID has been updated for every requested
         *        change.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The status of an update made to a UserID. Reflects if the UserID has been updated for every requested change.
         * </p>
         * 
         * @param userStatus
         *        The status of an update made to a UserID. Reflects if the UserID has been updated for every requested
         *        change.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(UserStatus userStatus);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<AssociatedFace> associatedFaces = DefaultSdkAutoConstructList.getInstance();

        private List<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations = DefaultSdkAutoConstructList.getInstance();

        private String userStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFacesResponse model) {
            super(model);
            associatedFaces(model.associatedFaces);
            unsuccessfulFaceAssociations(model.unsuccessfulFaceAssociations);
            userStatus(model.userStatus);
        }

        public final List<AssociatedFace.Builder> getAssociatedFaces() {
            List<AssociatedFace.Builder> result = AssociatedFacesListCopier.copyToBuilder(this.associatedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedFaces(Collection<AssociatedFace.BuilderImpl> associatedFaces) {
            this.associatedFaces = AssociatedFacesListCopier.copyFromBuilder(associatedFaces);
        }

        @Override
        public final Builder associatedFaces(Collection<AssociatedFace> associatedFaces) {
            this.associatedFaces = AssociatedFacesListCopier.copy(associatedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFaces(AssociatedFace... associatedFaces) {
            associatedFaces(Arrays.asList(associatedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFaces(Consumer<AssociatedFace.Builder>... associatedFaces) {
            associatedFaces(Stream.of(associatedFaces).map(c -> AssociatedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulFaceAssociation.Builder> getUnsuccessfulFaceAssociations() {
            List<UnsuccessfulFaceAssociation.Builder> result = UnsuccessfulFaceAssociationListCopier
                    .copyToBuilder(this.unsuccessfulFaceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceAssociations(
                Collection<UnsuccessfulFaceAssociation.BuilderImpl> unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations = UnsuccessfulFaceAssociationListCopier
                    .copyFromBuilder(unsuccessfulFaceAssociations);
        }

        @Override
        public final Builder unsuccessfulFaceAssociations(Collection<UnsuccessfulFaceAssociation> unsuccessfulFaceAssociations) {
            this.unsuccessfulFaceAssociations = UnsuccessfulFaceAssociationListCopier.copy(unsuccessfulFaceAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceAssociations(UnsuccessfulFaceAssociation... unsuccessfulFaceAssociations) {
            unsuccessfulFaceAssociations(Arrays.asList(unsuccessfulFaceAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceAssociations(
                Consumer<UnsuccessfulFaceAssociation.Builder>... unsuccessfulFaceAssociations) {
            unsuccessfulFaceAssociations(Stream.of(unsuccessfulFaceAssociations)
                    .map(c -> UnsuccessfulFaceAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatus userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        @Override
        public AssociateFacesResponse build() {
            return new AssociateFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
