/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the starting point in a Kinesis stream to start processing. You can use the producer timestamp or the
 * fragment number. One of either producer timestamp or fragment number is required. If you use the producer timestamp,
 * you must put the time in milliseconds. For more information about fragment numbers, see <a
 * href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamStartSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamStartSelector.Builder, KinesisVideoStreamStartSelector> {
    private static final SdkField<Long> PRODUCER_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProducerTimestamp").getter(getter(KinesisVideoStreamStartSelector::producerTimestamp))
            .setter(setter(Builder::producerTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerTimestamp").build()).build();

    private static final SdkField<String> FRAGMENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentNumber").getter(getter(KinesisVideoStreamStartSelector::fragmentNumber))
            .setter(setter(Builder::fragmentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCER_TIMESTAMP_FIELD,
            FRAGMENT_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long producerTimestamp;

    private final String fragmentNumber;

    private KinesisVideoStreamStartSelector(BuilderImpl builder) {
        this.producerTimestamp = builder.producerTimestamp;
        this.fragmentNumber = builder.fragmentNumber;
    }

    /**
     * <p>
     * The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time format.
     * </p>
     * 
     * @return The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time
     *         format.
     */
    public final Long producerTimestamp() {
        return producerTimestamp;
    }

    /**
     * <p>
     * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     * </p>
     * 
     * @return The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     */
    public final String fragmentNumber() {
        return fragmentNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(producerTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamStartSelector)) {
            return false;
        }
        KinesisVideoStreamStartSelector other = (KinesisVideoStreamStartSelector) obj;
        return Objects.equals(producerTimestamp(), other.producerTimestamp())
                && Objects.equals(fragmentNumber(), other.fragmentNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamStartSelector").add("ProducerTimestamp", producerTimestamp())
                .add("FragmentNumber", fragmentNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProducerTimestamp":
            return Optional.ofNullable(clazz.cast(producerTimestamp()));
        case "FragmentNumber":
            return Optional.ofNullable(clazz.cast(fragmentNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProducerTimestamp", PRODUCER_TIMESTAMP_FIELD);
        map.put("FragmentNumber", FRAGMENT_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamStartSelector, T> g) {
        return obj -> g.apply((KinesisVideoStreamStartSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamStartSelector> {
        /**
         * <p>
         * The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time
         * format.
         * </p>
         * 
         * @param producerTimestamp
         *        The timestamp from the producer corresponding to the fragment, in milliseconds, expressed in unix time
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder producerTimestamp(Long producerTimestamp);

        /**
         * <p>
         * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
         * </p>
         * 
         * @param fragmentNumber
         *        The unique identifier of the fragment. This value monotonically increases based on the ingestion
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentNumber(String fragmentNumber);
    }

    static final class BuilderImpl implements Builder {
        private Long producerTimestamp;

        private String fragmentNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamStartSelector model) {
            producerTimestamp(model.producerTimestamp);
            fragmentNumber(model.fragmentNumber);
        }

        public final Long getProducerTimestamp() {
            return producerTimestamp;
        }

        public final void setProducerTimestamp(Long producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
        }

        @Override
        public final Builder producerTimestamp(Long producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
            return this;
        }

        public final String getFragmentNumber() {
            return fragmentNumber;
        }

        public final void setFragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
        }

        @Override
        public final Builder fragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        @Override
        public KinesisVideoStreamStartSelector build() {
            return new KinesisVideoStreamStartSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
