/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A session settings object. It contains settings for the operation to be performed. It accepts arguments for
 * OutputConfig and AuditImagesLimit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFaceLivenessSessionRequestSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFaceLivenessSessionRequestSettings.Builder, CreateFaceLivenessSessionRequestSettings> {
    private static final SdkField<LivenessOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<LivenessOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateFaceLivenessSessionRequestSettings::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(LivenessOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<Integer> AUDIT_IMAGES_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AuditImagesLimit").getter(getter(CreateFaceLivenessSessionRequestSettings::auditImagesLimit))
            .setter(setter(Builder::auditImagesLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditImagesLimit").build()).build();

    private static final SdkField<List<ChallengePreference>> CHALLENGE_PREFERENCES_FIELD = SdkField
            .<List<ChallengePreference>> builder(MarshallingType.LIST)
            .memberName("ChallengePreferences")
            .getter(getter(CreateFaceLivenessSessionRequestSettings::challengePreferences))
            .setter(setter(Builder::challengePreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengePreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChallengePreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChallengePreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_CONFIG_FIELD,
            AUDIT_IMAGES_LIMIT_FIELD, CHALLENGE_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LivenessOutputConfig outputConfig;

    private final Integer auditImagesLimit;

    private final List<ChallengePreference> challengePreferences;

    private CreateFaceLivenessSessionRequestSettings(BuilderImpl builder) {
        this.outputConfig = builder.outputConfig;
        this.auditImagesLimit = builder.auditImagesLimit;
        this.challengePreferences = builder.challengePreferences;
    }

    /**
     * <p>
     * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that the
     * Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
     * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires that
     * the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     * </p>
     * 
     * @return Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note
     *         that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face
     *         Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness
     *         system. Requires that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
     */
    public final LivenessOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return 0,
     * any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best effort
     * and is based on the actual duration of the selfie-video.
     * </p>
     * 
     * @return Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will
     *         return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit
     *         is best effort and is based on the actual duration of the selfie-video.
     */
    public final Integer auditImagesLimit() {
        return auditImagesLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChallengePreferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChallengePreferences() {
        return challengePreferences != null && !(challengePreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates preferred challenge types and versions for the Face Liveness session to be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChallengePreferences} method.
     * </p>
     * 
     * @return Indicates preferred challenge types and versions for the Face Liveness session to be created.
     */
    public final List<ChallengePreference> challengePreferences() {
        return challengePreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(auditImagesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasChallengePreferences() ? challengePreferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFaceLivenessSessionRequestSettings)) {
            return false;
        }
        CreateFaceLivenessSessionRequestSettings other = (CreateFaceLivenessSessionRequestSettings) obj;
        return Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(auditImagesLimit(), other.auditImagesLimit())
                && hasChallengePreferences() == other.hasChallengePreferences()
                && Objects.equals(challengePreferences(), other.challengePreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFaceLivenessSessionRequestSettings").add("OutputConfig", outputConfig())
                .add("AuditImagesLimit", auditImagesLimit())
                .add("ChallengePreferences", hasChallengePreferences() ? challengePreferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "AuditImagesLimit":
            return Optional.ofNullable(clazz.cast(auditImagesLimit()));
        case "ChallengePreferences":
            return Optional.ofNullable(clazz.cast(challengePreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("AuditImagesLimit", AUDIT_IMAGES_LIMIT_FIELD);
        map.put("ChallengePreferences", CHALLENGE_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFaceLivenessSessionRequestSettings, T> g) {
        return obj -> g.apply((CreateFaceLivenessSessionRequestSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFaceLivenessSessionRequestSettings> {
        /**
         * <p>
         * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that
         * the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
         * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires
         * that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
         * </p>
         * 
         * @param outputConfig
         *        Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note
         *        that the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the
         *        Face Liveness end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face
         *        Liveness system. Requires that the caller has the <code>s3:PutObject</code> permission on the Amazon
         *        S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(LivenessOutputConfig outputConfig);

        /**
         * <p>
         * Can specify the location of an Amazon S3 bucket, where reference and audit images will be stored. Note that
         * the Amazon S3 bucket must be located in the caller's AWS account and in the same region as the Face Liveness
         * end-point. Additionally, the Amazon S3 object keys are auto-generated by the Face Liveness system. Requires
         * that the caller has the <code>s3:PutObject</code> permission on the Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link LivenessOutputConfig.Builder} avoiding
         * the need to create one manually via {@link LivenessOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LivenessOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputConfig(LivenessOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link LivenessOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(LivenessOutputConfig)
         */
        default Builder outputConfig(Consumer<LivenessOutputConfig.Builder> outputConfig) {
            return outputConfig(LivenessOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will return
         * 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The limit is best
         * effort and is based on the actual duration of the selfie-video.
         * </p>
         * 
         * @param auditImagesLimit
         *        Number of audit images to be returned back. Takes an integer between 0-4. Any integer less than 0 will
         *        return 0, any integer above 4 will return 4 images in the response. By default, it is set to 0. The
         *        limit is best effort and is based on the actual duration of the selfie-video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditImagesLimit(Integer auditImagesLimit);

        /**
         * <p>
         * Indicates preferred challenge types and versions for the Face Liveness session to be created.
         * </p>
         * 
         * @param challengePreferences
         *        Indicates preferred challenge types and versions for the Face Liveness session to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengePreferences(Collection<ChallengePreference> challengePreferences);

        /**
         * <p>
         * Indicates preferred challenge types and versions for the Face Liveness session to be created.
         * </p>
         * 
         * @param challengePreferences
         *        Indicates preferred challenge types and versions for the Face Liveness session to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengePreferences(ChallengePreference... challengePreferences);

        /**
         * <p>
         * Indicates preferred challenge types and versions for the Face Liveness session to be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ChallengePreference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.ChallengePreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ChallengePreference.Builder#build()} is called
         * immediately and its result is passed to {@link #challengePreferences(List<ChallengePreference>)}.
         * 
         * @param challengePreferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ChallengePreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challengePreferences(java.util.Collection<ChallengePreference>)
         */
        Builder challengePreferences(Consumer<ChallengePreference.Builder>... challengePreferences);
    }

    static final class BuilderImpl implements Builder {
        private LivenessOutputConfig outputConfig;

        private Integer auditImagesLimit;

        private List<ChallengePreference> challengePreferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFaceLivenessSessionRequestSettings model) {
            outputConfig(model.outputConfig);
            auditImagesLimit(model.auditImagesLimit);
            challengePreferences(model.challengePreferences);
        }

        public final LivenessOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(LivenessOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(LivenessOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Integer getAuditImagesLimit() {
            return auditImagesLimit;
        }

        public final void setAuditImagesLimit(Integer auditImagesLimit) {
            this.auditImagesLimit = auditImagesLimit;
        }

        @Override
        public final Builder auditImagesLimit(Integer auditImagesLimit) {
            this.auditImagesLimit = auditImagesLimit;
            return this;
        }

        public final List<ChallengePreference.Builder> getChallengePreferences() {
            List<ChallengePreference.Builder> result = ChallengePreferencesCopier.copyToBuilder(this.challengePreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChallengePreferences(Collection<ChallengePreference.BuilderImpl> challengePreferences) {
            this.challengePreferences = ChallengePreferencesCopier.copyFromBuilder(challengePreferences);
        }

        @Override
        public final Builder challengePreferences(Collection<ChallengePreference> challengePreferences) {
            this.challengePreferences = ChallengePreferencesCopier.copy(challengePreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengePreferences(ChallengePreference... challengePreferences) {
            challengePreferences(Arrays.asList(challengePreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder challengePreferences(Consumer<ChallengePreference.Builder>... challengePreferences) {
            challengePreferences(Stream.of(challengePreferences).map(c -> ChallengePreference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFaceLivenessSessionRequestSettings build() {
            return new CreateFaceLivenessSessionRequestSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
