/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum LandmarkType {
    EYE_LEFT("eyeLeft"),

    EYE_RIGHT("eyeRight"),

    NOSE("nose"),

    MOUTH_LEFT("mouthLeft"),

    MOUTH_RIGHT("mouthRight"),

    LEFT_EYE_BROW_LEFT("leftEyeBrowLeft"),

    LEFT_EYE_BROW_RIGHT("leftEyeBrowRight"),

    LEFT_EYE_BROW_UP("leftEyeBrowUp"),

    RIGHT_EYE_BROW_LEFT("rightEyeBrowLeft"),

    RIGHT_EYE_BROW_RIGHT("rightEyeBrowRight"),

    RIGHT_EYE_BROW_UP("rightEyeBrowUp"),

    LEFT_EYE_LEFT("leftEyeLeft"),

    LEFT_EYE_RIGHT("leftEyeRight"),

    LEFT_EYE_UP("leftEyeUp"),

    LEFT_EYE_DOWN("leftEyeDown"),

    RIGHT_EYE_LEFT("rightEyeLeft"),

    RIGHT_EYE_RIGHT("rightEyeRight"),

    RIGHT_EYE_UP("rightEyeUp"),

    RIGHT_EYE_DOWN("rightEyeDown"),

    NOSE_LEFT("noseLeft"),

    NOSE_RIGHT("noseRight"),

    MOUTH_UP("mouthUp"),

    MOUTH_DOWN("mouthDown"),

    LEFT_PUPIL("leftPupil"),

    RIGHT_PUPIL("rightPupil"),

    UPPER_JAWLINE_LEFT("upperJawlineLeft"),

    MID_JAWLINE_LEFT("midJawlineLeft"),

    CHIN_BOTTOM("chinBottom"),

    MID_JAWLINE_RIGHT("midJawlineRight"),

    UPPER_JAWLINE_RIGHT("upperJawlineRight"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LandmarkType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LandmarkType corresponding to the value
     */
    public static LandmarkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LandmarkType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LandmarkType}s
     */
    public static Set<LandmarkType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
