/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatch;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.CompareFacesUnmatchListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompareFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, CompareFacesResponse> {
    private static final SdkField<ComparedSourceImageFace> SOURCE_IMAGE_FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CompareFacesResponse.getter(CompareFacesResponse::sourceImageFace)).setter(CompareFacesResponse.setter(Builder::sourceImageFace)).constructor(ComparedSourceImageFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageFace").build()}).build();
    private static final SdkField<List<CompareFacesMatch>> FACE_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CompareFacesResponse.getter(CompareFacesResponse::faceMatches)).setter(CompareFacesResponse.setter(Builder::faceMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompareFacesMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ComparedFace>> UNMATCHED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CompareFacesResponse.getter(CompareFacesResponse::unmatchedFaces)).setter(CompareFacesResponse.setter(Builder::unmatchedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnmatchedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompareFacesResponse.getter(CompareFacesResponse::sourceImageOrientationCorrectionAsString)).setter(CompareFacesResponse.setter(Builder::sourceImageOrientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageOrientationCorrection").build()}).build();
    private static final SdkField<String> TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompareFacesResponse.getter(CompareFacesResponse::targetImageOrientationCorrectionAsString)).setter(CompareFacesResponse.setter(Builder::targetImageOrientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetImageOrientationCorrection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FACE_FIELD, FACE_MATCHES_FIELD, UNMATCHED_FACES_FIELD, SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD, TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD));
    private final ComparedSourceImageFace sourceImageFace;
    private final List<CompareFacesMatch> faceMatches;
    private final List<ComparedFace> unmatchedFaces;
    private final String sourceImageOrientationCorrection;
    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        super(builder);
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    public ComparedSourceImageFace sourceImageFace() {
        return this.sourceImageFace;
    }

    public List<CompareFacesMatch> faceMatches() {
        return this.faceMatches;
    }

    public List<ComparedFace> unmatchedFaces() {
        return this.unmatchedFaces;
    }

    public OrientationCorrection sourceImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.sourceImageOrientationCorrection);
    }

    public String sourceImageOrientationCorrectionAsString() {
        return this.sourceImageOrientationCorrection;
    }

    public OrientationCorrection targetImageOrientationCorrection() {
        return OrientationCorrection.fromValue(this.targetImageOrientationCorrection);
    }

    public String targetImageOrientationCorrectionAsString() {
        return this.targetImageOrientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageFace());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmatchedFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageOrientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetImageOrientationCorrectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse)((Object)obj);
        return Objects.equals(this.sourceImageFace(), other.sourceImageFace()) && Objects.equals(this.faceMatches(), other.faceMatches()) && Objects.equals(this.unmatchedFaces(), other.unmatchedFaces()) && Objects.equals(this.sourceImageOrientationCorrectionAsString(), other.sourceImageOrientationCorrectionAsString()) && Objects.equals(this.targetImageOrientationCorrectionAsString(), other.targetImageOrientationCorrectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"CompareFacesResponse").add("SourceImageFace", (Object)this.sourceImageFace()).add("FaceMatches", this.faceMatches()).add("UnmatchedFaces", this.unmatchedFaces()).add("SourceImageOrientationCorrection", (Object)this.sourceImageOrientationCorrectionAsString()).add("TargetImageOrientationCorrection", (Object)this.targetImageOrientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImageFace": {
                return Optional.ofNullable(clazz.cast(this.sourceImageFace()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
            case "UnmatchedFaces": {
                return Optional.ofNullable(clazz.cast(this.unmatchedFaces()));
            }
            case "SourceImageOrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.sourceImageOrientationCorrectionAsString()));
            }
            case "TargetImageOrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.targetImageOrientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesResponse, T> g) {
        return obj -> g.apply((CompareFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private ComparedSourceImageFace sourceImageFace;
        private List<CompareFacesMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();
        private List<ComparedFace> unmatchedFaces = DefaultSdkAutoConstructList.getInstance();
        private String sourceImageOrientationCorrection;
        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            super(model);
            this.sourceImageFace(model.sourceImageFace);
            this.faceMatches(model.faceMatches);
            this.unmatchedFaces(model.unmatchedFaces);
            this.sourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            this.targetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace.Builder getSourceImageFace() {
            return this.sourceImageFace != null ? this.sourceImageFace.toBuilder() : null;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final void setSourceImageFace(ComparedSourceImageFace.BuilderImpl sourceImageFace) {
            this.sourceImageFace = sourceImageFace != null ? sourceImageFace.build() : null;
        }

        public final Collection<CompareFacesMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(CompareFacesMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<CompareFacesMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (CompareFacesMatch)((CompareFacesMatch.Builder)CompareFacesMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch.BuilderImpl> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copyFromBuilder(faceMatches);
        }

        public final Collection<ComparedFace.Builder> getUnmatchedFaces() {
            return this.unmatchedFaces != null ? (Collection)this.unmatchedFaces.stream().map(ComparedFace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace ... unmatchedFaces) {
            this.unmatchedFaces(Arrays.asList(unmatchedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(Consumer<ComparedFace.Builder> ... unmatchedFaces) {
            this.unmatchedFaces(Stream.of(unmatchedFaces).map(c -> (ComparedFace)((ComparedFace.Builder)ComparedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace.BuilderImpl> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copyFromBuilder(unmatchedFaces);
        }

        public final String getSourceImageOrientationCorrectionAsString() {
            return this.sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
            return this;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        public final String getTargetImageOrientationCorrectionAsString() {
            return this.targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
            return this;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        @Override
        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompareFacesResponse> {
        public Builder sourceImageFace(ComparedSourceImageFace var1);

        default public Builder sourceImageFace(Consumer<ComparedSourceImageFace.Builder> sourceImageFace) {
            return this.sourceImageFace((ComparedSourceImageFace)((ComparedSourceImageFace.Builder)ComparedSourceImageFace.builder().applyMutation(sourceImageFace)).build());
        }

        public Builder faceMatches(Collection<CompareFacesMatch> var1);

        public Builder faceMatches(CompareFacesMatch ... var1);

        public Builder faceMatches(Consumer<CompareFacesMatch.Builder> ... var1);

        public Builder unmatchedFaces(Collection<ComparedFace> var1);

        public Builder unmatchedFaces(ComparedFace ... var1);

        public Builder unmatchedFaces(Consumer<ComparedFace.Builder> ... var1);

        public Builder sourceImageOrientationCorrection(String var1);

        public Builder sourceImageOrientationCorrection(OrientationCorrection var1);

        public Builder targetImageOrientationCorrection(String var1);

        public Builder targetImageOrientationCorrection(OrientationCorrection var1);
    }
}

