/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectLabelsResponse.Builder, DetectLabelsResponse> {
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField
            .<List<Label>> builder(MarshallingType.LIST)
            .getter(getter(DetectLabelsResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Label> builder(MarshallingType.SDK_POJO)
                                            .constructor(Label::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectLabelsResponse::orientationCorrectionAsString)).setter(setter(Builder::orientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build())
            .build();

    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectLabelsResponse::labelModelVersion)).setter(setter(Builder::labelModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD,
            ORIENTATION_CORRECTION_FIELD, LABEL_MODEL_VERSION_FIELD));

    private final List<Label> labels;

    private final String orientationCorrection;

    private final String labelModelVersion;

    private DetectLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
        this.labelModelVersion = builder.labelModelVersion;
    }

    /**
     * <p>
     * An array of labels for the real-world objects detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of labels for the real-world objects detected.
     */
    public List<Label> labels() {
        return labels;
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    /**
     * <p>
     * Version number of the label detection model that was used to detect labels.
     * </p>
     * 
     * @return Version number of the label detection model that was used to detect labels.
     */
    public String labelModelVersion() {
        return labelModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse) obj;
        return Objects.equals(labels(), other.labels())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString())
                && Objects.equals(labelModelVersion(), other.labelModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectLabelsResponse").add("Labels", labels())
                .add("OrientationCorrection", orientationCorrectionAsString()).add("LabelModelVersion", labelModelVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "OrientationCorrection":
            return Optional.ofNullable(clazz.cast(orientationCorrectionAsString()));
        case "LabelModelVersion":
            return Optional.ofNullable(clazz.cast(labelModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsResponse, T> g) {
        return obj -> g.apply((DetectLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectLabelsResponse> {
        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Label>.Builder} avoiding the need to create
         * one manually via {@link List<Label>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Label>.Builder#build()} is called immediately and its result
         * is passed to {@link #labels(List<Label>)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link List<Label>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(List<Label>)
         */
        Builder labels(Consumer<Label.Builder>... labels);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);

        /**
         * <p>
         * Version number of the label detection model that was used to detect labels.
         * </p>
         * 
         * @param labelModelVersion
         *        Version number of the label detection model that was used to detect labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelModelVersion(String labelModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private String orientationCorrection;

        private String labelModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            super(model);
            labels(model.labels);
            orientationCorrection(model.orientationCorrection);
            labelModelVersion(model.labelModelVersion);
        }

        public final Collection<Label.Builder> getLabels() {
            return labels != null ? labels.stream().map(Label::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder>... labels) {
            labels(Stream.of(labels).map(c -> Label.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        public final String getOrientationCorrectionAsString() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final String getLabelModelVersion() {
            return labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
