/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceDetection;
import software.amazon.awssdk.services.rekognition.model.FaceDetectionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFaceDetectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetFaceDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::jobStatusAsString)).setter(GetFaceDetectionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::statusMessage)).setter(GetFaceDetectionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::videoMetadata)).setter(GetFaceDetectionResponse.setter(Builder::videoMetadata)).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::nextToken)).setter(GetFaceDetectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FaceDetection>> FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFaceDetectionResponse.getter(GetFaceDetectionResponse::faces)).setter(GetFaceDetectionResponse.setter(Builder::faces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, FACES_FIELD));
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final String nextToken;
    private final List<FaceDetection> faces;

    private GetFaceDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.faces = builder.faces;
    }

    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<FaceDetection> faces() {
        return this.faces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.faces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceDetectionResponse)) {
            return false;
        }
        GetFaceDetectionResponse other = (GetFaceDetectionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.faces(), other.faces());
    }

    public String toString() {
        return ToString.builder((String)"GetFaceDetectionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("NextToken", (Object)this.nextToken()).add("Faces", this.faces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Faces": {
                return Optional.ofNullable(clazz.cast(this.faces()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceDetectionResponse, T> g) {
        return obj -> g.apply((GetFaceDetectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private String nextToken;
        private List<FaceDetection> faces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceDetectionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.nextToken(model.nextToken);
            this.faces(model.faces);
        }

        public final String getJobStatusAsString() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FaceDetection.Builder> getFaces() {
            return this.faces != null ? (Collection)this.faces.stream().map(FaceDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faces(Collection<FaceDetection> faces) {
            this.faces = FaceDetectionsCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(FaceDetection ... faces) {
            this.faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Consumer<FaceDetection.Builder> ... faces) {
            this.faces(Stream.of(faces).map(c -> (FaceDetection)((FaceDetection.Builder)FaceDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaces(Collection<FaceDetection.BuilderImpl> faces) {
            this.faces = FaceDetectionsCopier.copyFromBuilder(faces);
        }

        @Override
        public GetFaceDetectionResponse build() {
            return new GetFaceDetectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFaceDetectionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder nextToken(String var1);

        public Builder faces(Collection<FaceDetection> var1);

        public Builder faces(FaceDetection ... var1);

        public Builder faces(Consumer<FaceDetection.Builder> ... var1);
    }
}

