/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSpaceResponse extends RepostspaceResponse implements
        ToCopyableBuilder<CreateSpaceResponse.Builder, CreateSpaceResponse> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(CreateSpaceResponse::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD));

    private final String spaceId;

    private CreateSpaceResponse(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpaceResponse)) {
            return false;
        }
        CreateSpaceResponse other = (CreateSpaceResponse) obj;
        return Objects.equals(spaceId(), other.spaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSpaceResponse").add("SpaceId", spaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSpaceResponse, T> g) {
        return obj -> g.apply((CreateSpaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSpaceResponse> {
        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);
    }

    static final class BuilderImpl extends RepostspaceResponse.BuilderImpl implements Builder {
        private String spaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpaceResponse model) {
            super(model);
            spaceId(model.spaceId);
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @Override
        public CreateSpaceResponse build() {
            return new CreateSpaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
