/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRemoveRoleResponse extends RepostspaceResponse implements
        ToCopyableBuilder<BatchRemoveRoleResponse.Builder, BatchRemoveRoleResponse> {
    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField
            .<List<BatchError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchRemoveRoleResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVED_ACCESSOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removedAccessorIds")
            .getter(getter(BatchRemoveRoleResponse::removedAccessorIds))
            .setter(setter(Builder::removedAccessorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removedAccessorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            REMOVED_ACCESSOR_IDS_FIELD));

    private final List<BatchError> errors;

    private final List<String> removedAccessorIds;

    private BatchRemoveRoleResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.removedAccessorIds = builder.removedAccessorIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of errors that occurred when roles were removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of errors that occurred when roles were removed.
     */
    public final List<BatchError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemovedAccessorIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemovedAccessorIds() {
        return removedAccessorIds != null && !(removedAccessorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of successfully updated accessor identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemovedAccessorIds} method.
     * </p>
     * 
     * @return An array of successfully updated accessor identifiers.
     */
    public final List<String> removedAccessorIds() {
        return removedAccessorIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemovedAccessorIds() ? removedAccessorIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRemoveRoleResponse)) {
            return false;
        }
        BatchRemoveRoleResponse other = (BatchRemoveRoleResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasRemovedAccessorIds() == other.hasRemovedAccessorIds()
                && Objects.equals(removedAccessorIds(), other.removedAccessorIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRemoveRoleResponse").add("Errors", hasErrors() ? errors() : null)
                .add("RemovedAccessorIds", hasRemovedAccessorIds() ? removedAccessorIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "removedAccessorIds":
            return Optional.ofNullable(clazz.cast(removedAccessorIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchRemoveRoleResponse, T> g) {
        return obj -> g.apply((BatchRemoveRoleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchRemoveRoleResponse> {
        /**
         * <p>
         * An array of errors that occurred when roles were removed.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when roles were removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchError> errors);

        /**
         * <p>
         * An array of errors that occurred when roles were removed.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when roles were removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchError... errors);

        /**
         * <p>
         * An array of errors that occurred when roles were removed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.repostspace.model.BatchError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<BatchError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.repostspace.model.BatchError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchError>)
         */
        Builder errors(Consumer<BatchError.Builder>... errors);

        /**
         * <p>
         * An array of successfully updated accessor identifiers.
         * </p>
         * 
         * @param removedAccessorIds
         *        An array of successfully updated accessor identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedAccessorIds(Collection<String> removedAccessorIds);

        /**
         * <p>
         * An array of successfully updated accessor identifiers.
         * </p>
         * 
         * @param removedAccessorIds
         *        An array of successfully updated accessor identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedAccessorIds(String... removedAccessorIds);
    }

    static final class BuilderImpl extends RepostspaceResponse.BuilderImpl implements Builder {
        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<String> removedAccessorIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRemoveRoleResponse model) {
            super(model);
            errors(model.errors);
            removedAccessorIds(model.removedAccessorIds);
        }

        public final List<BatchError.Builder> getErrors() {
            List<BatchError.Builder> result = BatchErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemovedAccessorIds() {
            if (removedAccessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removedAccessorIds;
        }

        public final void setRemovedAccessorIds(Collection<String> removedAccessorIds) {
            this.removedAccessorIds = AccessorIdListCopier.copy(removedAccessorIds);
        }

        @Override
        public final Builder removedAccessorIds(Collection<String> removedAccessorIds) {
            this.removedAccessorIds = AccessorIdListCopier.copy(removedAccessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removedAccessorIds(String... removedAccessorIds) {
            removedAccessorIds(Arrays.asList(removedAccessorIds));
            return this;
        }

        @Override
        public BatchRemoveRoleResponse build() {
            return new BatchRemoveRoleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
