/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAddRoleRequest extends RepostspaceRequest implements
        ToCopyableBuilder<BatchAddRoleRequest.Builder, BatchAddRoleRequest> {
    private static final SdkField<List<String>> ACCESSOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessorIds")
            .getter(getter(BatchAddRoleRequest::accessorIds))
            .setter(setter(Builder::accessorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(BatchAddRoleRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(BatchAddRoleRequest::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_IDS_FIELD,
            ROLE_FIELD, SPACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accessorIds", ACCESSOR_IDS_FIELD);
                    put("role", ROLE_FIELD);
                    put("spaceId", SPACE_ID_FIELD);
                }
            });

    private final List<String> accessorIds;

    private final String role;

    private final String spaceId;

    private BatchAddRoleRequest(BuilderImpl builder) {
        super(builder);
        this.accessorIds = builder.accessorIds;
        this.role = builder.role;
        this.spaceId = builder.spaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessorIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessorIds() {
        return accessorIds != null && !(accessorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user or group accessor identifiers to add the role to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessorIds} method.
     * </p>
     * 
     * @return The user or group accessor identifiers to add the role to.
     */
    public final List<String> accessorIds() {
        return accessorIds;
    }

    /**
     * <p>
     * The role to add to the users or groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role to add to the users or groups.
     * @see Role
     */
    public final Role role() {
        return Role.fromValue(role);
    }

    /**
     * <p>
     * The role to add to the users or groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role to add to the users or groups.
     * @see Role
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessorIds() ? accessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddRoleRequest)) {
            return false;
        }
        BatchAddRoleRequest other = (BatchAddRoleRequest) obj;
        return hasAccessorIds() == other.hasAccessorIds() && Objects.equals(accessorIds(), other.accessorIds())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(spaceId(), other.spaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAddRoleRequest").add("AccessorIds", hasAccessorIds() ? accessorIds() : null)
                .add("Role", roleAsString()).add("SpaceId", spaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessorIds":
            return Optional.ofNullable(clazz.cast(accessorIds()));
        case "role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchAddRoleRequest, T> g) {
        return obj -> g.apply((BatchAddRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchAddRoleRequest> {
        /**
         * <p>
         * The user or group accessor identifiers to add the role to.
         * </p>
         * 
         * @param accessorIds
         *        The user or group accessor identifiers to add the role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(Collection<String> accessorIds);

        /**
         * <p>
         * The user or group accessor identifiers to add the role to.
         * </p>
         * 
         * @param accessorIds
         *        The user or group accessor identifiers to add the role to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(String... accessorIds);

        /**
         * <p>
         * The role to add to the users or groups.
         * </p>
         * 
         * @param role
         *        The role to add to the users or groups.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(String role);

        /**
         * <p>
         * The role to add to the users or groups.
         * </p>
         * 
         * @param role
         *        The role to add to the users or groups.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(Role role);

        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RepostspaceRequest.BuilderImpl implements Builder {
        private List<String> accessorIds = DefaultSdkAutoConstructList.getInstance();

        private String role;

        private String spaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddRoleRequest model) {
            super(model);
            accessorIds(model.accessorIds);
            role(model.role);
            spaceId(model.spaceId);
        }

        public final Collection<String> getAccessorIds() {
            if (accessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accessorIds;
        }

        public final void setAccessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
        }

        @Override
        public final Builder accessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessorIds(String... accessorIds) {
            accessorIds(Arrays.asList(accessorIds));
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAddRoleRequest build() {
            return new BatchAddRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
