/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.repostspace.model.ConfigurationStatus;
import software.amazon.awssdk.services.repostspace.model.TierLevel;
import software.amazon.awssdk.services.repostspace.model.VanityDomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceData> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SpaceData.getter(SpaceData::arn)).setter(SpaceData.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationStatus").getter(SpaceData.getter(SpaceData::configurationStatusAsString)).setter(SpaceData.setter(Builder::configurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<Long> CONTENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("contentSize").getter(SpaceData.getter(SpaceData::contentSize)).setter(SpaceData.setter(Builder::contentSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSize").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createDateTime").getter(SpaceData.getter(SpaceData::createDateTime)).setter(SpaceData.setter(Builder::createDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deleteDateTime").getter(SpaceData.getter(SpaceData::deleteDateTime)).setter(SpaceData.setter(Builder::deleteDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SpaceData.getter(SpaceData::description)).setter(SpaceData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SpaceData.getter(SpaceData::name)).setter(SpaceData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RANDOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomDomain").getter(SpaceData.getter(SpaceData::randomDomain)).setter(SpaceData.setter(Builder::randomDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomDomain").build()}).build();
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(SpaceData.getter(SpaceData::spaceId)).setter(SpaceData.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SpaceData.getter(SpaceData::status)).setter(SpaceData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Long> STORAGE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storageLimit").getter(SpaceData.getter(SpaceData::storageLimit)).setter(SpaceData.setter(Builder::storageLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLimit").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(SpaceData.getter(SpaceData::tierAsString)).setter(SpaceData.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("userCount").getter(SpaceData.getter(SpaceData::userCount)).setter(SpaceData.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()}).build();
    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userKMSKey").getter(SpaceData.getter(SpaceData::userKMSKey)).setter(SpaceData.setter(Builder::userKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomain").getter(SpaceData.getter(SpaceData::vanityDomain)).setter(SpaceData.setter(Builder::vanityDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomain").build()}).build();
    private static final SdkField<String> VANITY_DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vanityDomainStatus").getter(SpaceData.getter(SpaceData::vanityDomainStatusAsString)).setter(SpaceData.setter(Builder::vanityDomainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomainStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONFIGURATION_STATUS_FIELD, CONTENT_SIZE_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RANDOM_DOMAIN_FIELD, SPACE_ID_FIELD, STATUS_FIELD, STORAGE_LIMIT_FIELD, TIER_FIELD, USER_COUNT_FIELD, USER_KMS_KEY_FIELD, VANITY_DOMAIN_FIELD, VANITY_DOMAIN_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
            this.put("contentSize", CONTENT_SIZE_FIELD);
            this.put("createDateTime", CREATE_DATE_TIME_FIELD);
            this.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("randomDomain", RANDOM_DOMAIN_FIELD);
            this.put("spaceId", SPACE_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("storageLimit", STORAGE_LIMIT_FIELD);
            this.put("tier", TIER_FIELD);
            this.put("userCount", USER_COUNT_FIELD);
            this.put("userKMSKey", USER_KMS_KEY_FIELD);
            this.put("vanityDomain", VANITY_DOMAIN_FIELD);
            this.put("vanityDomainStatus", VANITY_DOMAIN_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String configurationStatus;
    private final Long contentSize;
    private final Instant createDateTime;
    private final Instant deleteDateTime;
    private final String description;
    private final String name;
    private final String randomDomain;
    private final String spaceId;
    private final String status;
    private final Long storageLimit;
    private final String tier;
    private final Integer userCount;
    private final String userKMSKey;
    private final String vanityDomain;
    private final String vanityDomainStatus;

    private SpaceData(BuilderImpl builder) {
        this.arn = builder.arn;
        this.configurationStatus = builder.configurationStatus;
        this.contentSize = builder.contentSize;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.description = builder.description;
        this.name = builder.name;
        this.randomDomain = builder.randomDomain;
        this.spaceId = builder.spaceId;
        this.status = builder.status;
        this.storageLimit = builder.storageLimit;
        this.tier = builder.tier;
        this.userCount = builder.userCount;
        this.userKMSKey = builder.userKMSKey;
        this.vanityDomain = builder.vanityDomain;
        this.vanityDomainStatus = builder.vanityDomainStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public final ConfigurationStatus configurationStatus() {
        return ConfigurationStatus.fromValue(this.configurationStatus);
    }

    public final String configurationStatusAsString() {
        return this.configurationStatus;
    }

    public final Long contentSize() {
        return this.contentSize;
    }

    public final Instant createDateTime() {
        return this.createDateTime;
    }

    public final Instant deleteDateTime() {
        return this.deleteDateTime;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String randomDomain() {
        return this.randomDomain;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String status() {
        return this.status;
    }

    public final Long storageLimit() {
        return this.storageLimit;
    }

    public final TierLevel tier() {
        return TierLevel.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final String userKMSKey() {
        return this.userKMSKey;
    }

    public final String vanityDomain() {
        return this.vanityDomain;
    }

    public final VanityDomainStatus vanityDomainStatus() {
        return VanityDomainStatus.fromValue(this.vanityDomainStatus);
    }

    public final String vanityDomainStatusAsString() {
        return this.vanityDomainStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.vanityDomainStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceData)) {
            return false;
        }
        SpaceData other = (SpaceData)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.configurationStatusAsString(), other.configurationStatusAsString()) && Objects.equals(this.contentSize(), other.contentSize()) && Objects.equals(this.createDateTime(), other.createDateTime()) && Objects.equals(this.deleteDateTime(), other.deleteDateTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.randomDomain(), other.randomDomain()) && Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.storageLimit(), other.storageLimit()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.userKMSKey(), other.userKMSKey()) && Objects.equals(this.vanityDomain(), other.vanityDomain()) && Objects.equals(this.vanityDomainStatusAsString(), other.vanityDomainStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceData").add("Arn", (Object)this.arn()).add("ConfigurationStatus", (Object)this.configurationStatusAsString()).add("ContentSize", (Object)this.contentSize()).add("CreateDateTime", (Object)this.createDateTime()).add("DeleteDateTime", (Object)this.deleteDateTime()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("RandomDomain", (Object)this.randomDomain()).add("SpaceId", (Object)this.spaceId()).add("Status", (Object)this.status()).add("StorageLimit", (Object)this.storageLimit()).add("Tier", (Object)this.tierAsString()).add("UserCount", (Object)this.userCount()).add("UserKMSKey", (Object)this.userKMSKey()).add("VanityDomain", (Object)this.vanityDomain()).add("VanityDomainStatus", (Object)this.vanityDomainStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatusAsString()));
            }
            case "contentSize": {
                return Optional.ofNullable(clazz.cast(this.contentSize()));
            }
            case "createDateTime": {
                return Optional.ofNullable(clazz.cast(this.createDateTime()));
            }
            case "deleteDateTime": {
                return Optional.ofNullable(clazz.cast(this.deleteDateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "randomDomain": {
                return Optional.ofNullable(clazz.cast(this.randomDomain()));
            }
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "storageLimit": {
                return Optional.ofNullable(clazz.cast(this.storageLimit()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "userCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "userKMSKey": {
                return Optional.ofNullable(clazz.cast(this.userKMSKey()));
            }
            case "vanityDomain": {
                return Optional.ofNullable(clazz.cast(this.vanityDomain()));
            }
            case "vanityDomainStatus": {
                return Optional.ofNullable(clazz.cast(this.vanityDomainStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SpaceData, T> g) {
        return obj -> g.apply((SpaceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String configurationStatus;
        private Long contentSize;
        private Instant createDateTime;
        private Instant deleteDateTime;
        private String description;
        private String name;
        private String randomDomain;
        private String spaceId;
        private String status;
        private Long storageLimit;
        private String tier;
        private Integer userCount;
        private String userKMSKey;
        private String vanityDomain;
        private String vanityDomainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceData model) {
            this.arn(model.arn);
            this.configurationStatus(model.configurationStatus);
            this.contentSize(model.contentSize);
            this.createDateTime(model.createDateTime);
            this.deleteDateTime(model.deleteDateTime);
            this.description(model.description);
            this.name(model.name);
            this.randomDomain(model.randomDomain);
            this.spaceId(model.spaceId);
            this.status(model.status);
            this.storageLimit(model.storageLimit);
            this.tier(model.tier);
            this.userCount(model.userCount);
            this.userKMSKey(model.userKMSKey);
            this.vanityDomain(model.vanityDomain);
            this.vanityDomainStatus(model.vanityDomainStatus);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConfigurationStatus() {
            return this.configurationStatus;
        }

        public final void setConfigurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
        }

        @Override
        public final Builder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus(configurationStatus == null ? null : configurationStatus.toString());
            return this;
        }

        public final Long getContentSize() {
            return this.contentSize;
        }

        public final void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }

        @Override
        public final Builder contentSize(Long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public final Instant getCreateDateTime() {
            return this.createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return this.deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRandomDomain() {
            return this.randomDomain;
        }

        public final void setRandomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
        }

        @Override
        public final Builder randomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
            return this;
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Long getStorageLimit() {
            return this.storageLimit;
        }

        public final void setStorageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final String getUserKMSKey() {
            return this.userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final String getVanityDomain() {
            return this.vanityDomain;
        }

        public final void setVanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
        }

        @Override
        public final Builder vanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
            return this;
        }

        public final String getVanityDomainStatus() {
            return this.vanityDomainStatus;
        }

        public final void setVanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
        }

        @Override
        public final Builder vanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
            return this;
        }

        @Override
        public final Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus) {
            this.vanityDomainStatus(vanityDomainStatus == null ? null : vanityDomainStatus.toString());
            return this;
        }

        public SpaceData build() {
            return new SpaceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceData> {
        public Builder arn(String var1);

        public Builder configurationStatus(String var1);

        public Builder configurationStatus(ConfigurationStatus var1);

        public Builder contentSize(Long var1);

        public Builder createDateTime(Instant var1);

        public Builder deleteDateTime(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder randomDomain(String var1);

        public Builder spaceId(String var1);

        public Builder status(String var1);

        public Builder storageLimit(Long var1);

        public Builder tier(String var1);

        public Builder tier(TierLevel var1);

        public Builder userCount(Integer var1);

        public Builder userKMSKey(String var1);

        public Builder vanityDomain(String var1);

        public Builder vanityDomainStatus(String var1);

        public Builder vanityDomainStatus(VanityDomainStatus var1);
    }
}

