/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request was denied due to request throttling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottlingException extends RepostspaceException implements
        ToCopyableBuilder<ThrottlingException.Builder, ThrottlingException> {
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quotaCode").getter(getter(ThrottlingException::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quotaCode").build()).build();

    private static final SdkField<Integer> RETRY_AFTER_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retryAfterSeconds").getter(getter(ThrottlingException::retryAfterSeconds))
            .setter(setter(Builder::retryAfterSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Retry-After").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(ThrottlingException::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_CODE_FIELD,
            RETRY_AFTER_SECONDS_FIELD, SERVICE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String quotaCode;

    private final Integer retryAfterSeconds;

    private final String serviceCode;

    private ThrottlingException(BuilderImpl builder) {
        super(builder);
        this.quotaCode = builder.quotaCode;
        this.retryAfterSeconds = builder.retryAfterSeconds;
        this.serviceCode = builder.serviceCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The code to identify the quota.
     * </p>
     * 
     * @return The code to identify the quota.
     */
    public String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * Advice to clients on when the call can be safely retried.
     * </p>
     * 
     * @return Advice to clients on when the call can be safely retried.
     */
    public Integer retryAfterSeconds() {
        return retryAfterSeconds;
    }

    /**
     * <p>
     * The code to identify the service.
     * </p>
     * 
     * @return The code to identify the service.
     */
    public String serviceCode() {
        return serviceCode;
    }

    @Override
    public boolean isRetryableException() {
        return true;
    }

    @Override
    public boolean isThrottlingException() {
        return true;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("quotaCode", QUOTA_CODE_FIELD);
        map.put("Retry-After", RETRY_AFTER_SECONDS_FIELD);
        map.put("serviceCode", SERVICE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThrottlingException, T> g) {
        return obj -> g.apply((ThrottlingException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThrottlingException>, RepostspaceException.Builder {
        /**
         * <p>
         * The code to identify the quota.
         * </p>
         * 
         * @param quotaCode
         *        The code to identify the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * Advice to clients on when the call can be safely retried.
         * </p>
         * 
         * @param retryAfterSeconds
         *        Advice to clients on when the call can be safely retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(Integer retryAfterSeconds);

        /**
         * <p>
         * The code to identify the service.
         * </p>
         * 
         * @param serviceCode
         *        The code to identify the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends RepostspaceException.BuilderImpl implements Builder {
        private String quotaCode;

        private Integer retryAfterSeconds;

        private String serviceCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottlingException model) {
            super(model);
            quotaCode(model.quotaCode);
            retryAfterSeconds(model.retryAfterSeconds);
            serviceCode(model.serviceCode);
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final Integer getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        public final void setRetryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ThrottlingException build() {
            return new ThrottlingException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
