/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendInvitesRequest extends RepostspaceRequest implements
        ToCopyableBuilder<SendInvitesRequest.Builder, SendInvitesRequest> {
    private static final SdkField<List<String>> ACCESSOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessorIds")
            .getter(getter(SendInvitesRequest::accessorIds))
            .setter(setter(Builder::accessorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(SendInvitesRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(SendInvitesRequest::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(SendInvitesRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_IDS_FIELD,
            BODY_FIELD, SPACE_ID_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> accessorIds;

    private final String body;

    private final String spaceId;

    private final String title;

    private SendInvitesRequest(BuilderImpl builder) {
        super(builder);
        this.accessorIds = builder.accessorIds;
        this.body = builder.body;
        this.spaceId = builder.spaceId;
        this.title = builder.title;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessorIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessorIds() {
        return accessorIds != null && !(accessorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of identifiers for the users and groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessorIds} method.
     * </p>
     * 
     * @return The array of identifiers for the users and groups.
     */
    public final List<String> accessorIds() {
        return accessorIds;
    }

    /**
     * <p>
     * The body of the invite.
     * </p>
     * 
     * @return The body of the invite.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The ID of the private re:Post.
     * </p>
     * 
     * @return The ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The title of the invite.
     * </p>
     * 
     * @return The title of the invite.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessorIds() ? accessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendInvitesRequest)) {
            return false;
        }
        SendInvitesRequest other = (SendInvitesRequest) obj;
        return hasAccessorIds() == other.hasAccessorIds() && Objects.equals(accessorIds(), other.accessorIds())
                && Objects.equals(body(), other.body()) && Objects.equals(spaceId(), other.spaceId())
                && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendInvitesRequest").add("AccessorIds", hasAccessorIds() ? accessorIds() : null)
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("SpaceId", spaceId())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessorIds":
            return Optional.ofNullable(clazz.cast(accessorIds()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessorIds", ACCESSOR_IDS_FIELD);
        map.put("body", BODY_FIELD);
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendInvitesRequest, T> g) {
        return obj -> g.apply((SendInvitesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendInvitesRequest> {
        /**
         * <p>
         * The array of identifiers for the users and groups.
         * </p>
         * 
         * @param accessorIds
         *        The array of identifiers for the users and groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(Collection<String> accessorIds);

        /**
         * <p>
         * The array of identifiers for the users and groups.
         * </p>
         * 
         * @param accessorIds
         *        The array of identifiers for the users and groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(String... accessorIds);

        /**
         * <p>
         * The body of the invite.
         * </p>
         * 
         * @param body
         *        The body of the invite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The title of the invite.
         * </p>
         * 
         * @param title
         *        The title of the invite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RepostspaceRequest.BuilderImpl implements Builder {
        private List<String> accessorIds = DefaultSdkAutoConstructList.getInstance();

        private String body;

        private String spaceId;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(SendInvitesRequest model) {
            super(model);
            accessorIds(model.accessorIds);
            body(model.body);
            spaceId(model.spaceId);
            title(model.title);
        }

        public final Collection<String> getAccessorIds() {
            if (accessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accessorIds;
        }

        public final void setAccessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
        }

        @Override
        public final Builder accessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessorIds(String... accessorIds) {
            accessorIds(Arrays.asList(accessorIds));
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendInvitesRequest build() {
            return new SendInvitesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
