/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSpaceRequest extends RepostspaceRequest implements
        ToCopyableBuilder<CreateSpaceRequest.Builder, CreateSpaceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSpaceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSpaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateSpaceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subdomain").getter(getter(CreateSpaceRequest::subdomain)).setter(setter(Builder::subdomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdomain").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSpaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(CreateSpaceRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userKMSKey").getter(getter(CreateSpaceRequest::userKMSKey)).setter(setter(Builder::userKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            ROLE_ARN_FIELD, SUBDOMAIN_FIELD, TAGS_FIELD, TIER_FIELD, USER_KMS_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String name;

    private final String roleArn;

    private final String subdomain;

    private final Map<String, String> tags;

    private final String tier;

    private final String userKMSKey;

    private CreateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.subdomain = builder.subdomain;
        this.tags = builder.tags;
        this.tier = builder.tier;
        this.userKMSKey = builder.userKMSKey;
    }

    /**
     * <p>
     * A description for the private re:Post. This is used only to help you identify this private re:Post.
     * </p>
     * 
     * @return A description for the private re:Post. This is used only to help you identify this private re:Post.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name for the private re:Post. This must be unique in your account.
     * </p>
     * 
     * @return The name for the private re:Post. This must be unique in your account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS support
     * tickets.
     * </p>
     * 
     * @return The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS
     *         support tickets.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The subdomain that you use to access your AWS re:Post Private private re:Post. All custom subdomains must be
     * approved by AWS before use. In addition to your custom subdomain, all private re:Posts are issued an AWS
     * generated subdomain for immediate use.
     * </p>
     * 
     * @return The subdomain that you use to access your AWS re:Post Private private re:Post. All custom subdomains must
     *         be approved by AWS before use. In addition to your custom subdomain, all private re:Posts are issued an
     *         AWS generated subdomain for immediate use.
     */
    public final String subdomain() {
        return subdomain;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tags associated with the private re:Post.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags associated with the private re:Post.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The pricing tier for the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier for the private re:Post.
     * @see TierLevel
     */
    public final TierLevel tier() {
        return TierLevel.fromValue(tier);
    }

    /**
     * <p>
     * The pricing tier for the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier for the private re:Post.
     * @see TierLevel
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The AWS KMS key ARN that’s used for the AWS KMS encryption. If you don't provide a key, your data is encrypted by
     * default with a key that AWS owns and manages for you.
     * </p>
     * 
     * @return The AWS KMS key ARN that’s used for the AWS KMS encryption. If you don't provide a key, your data is
     *         encrypted by default with a key that AWS owns and manages for you.
     */
    public final String userKMSKey() {
        return userKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userKMSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpaceRequest)) {
            return false;
        }
        CreateSpaceRequest other = (CreateSpaceRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(subdomain(), other.subdomain())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(tierAsString(), other.tierAsString()) && Objects.equals(userKMSKey(), other.userKMSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSpaceRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("Subdomain", subdomain()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tier", tierAsString()).add("UserKMSKey", userKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "subdomain":
            return Optional.ofNullable(clazz.cast(subdomain()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "userKMSKey":
            return Optional.ofNullable(clazz.cast(userKMSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("subdomain", SUBDOMAIN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("userKMSKey", USER_KMS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSpaceRequest, T> g) {
        return obj -> g.apply((CreateSpaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSpaceRequest> {
        /**
         * <p>
         * A description for the private re:Post. This is used only to help you identify this private re:Post.
         * </p>
         * 
         * @param description
         *        A description for the private re:Post. This is used only to help you identify this private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the private re:Post. This must be unique in your account.
         * </p>
         * 
         * @param name
         *        The name for the private re:Post. This must be unique in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS support
         * tickets.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS
         *        support tickets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The subdomain that you use to access your AWS re:Post Private private re:Post. All custom subdomains must be
         * approved by AWS before use. In addition to your custom subdomain, all private re:Posts are issued an AWS
         * generated subdomain for immediate use.
         * </p>
         * 
         * @param subdomain
         *        The subdomain that you use to access your AWS re:Post Private private re:Post. All custom subdomains
         *        must be approved by AWS before use. In addition to your custom subdomain, all private re:Posts are
         *        issued an AWS generated subdomain for immediate use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdomain(String subdomain);

        /**
         * <p>
         * The list of tags associated with the private re:Post.
         * </p>
         * 
         * @param tags
         *        The list of tags associated with the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The pricing tier for the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier for the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(String tier);

        /**
         * <p>
         * The pricing tier for the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier for the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(TierLevel tier);

        /**
         * <p>
         * The AWS KMS key ARN that’s used for the AWS KMS encryption. If you don't provide a key, your data is
         * encrypted by default with a key that AWS owns and manages for you.
         * </p>
         * 
         * @param userKMSKey
         *        The AWS KMS key ARN that’s used for the AWS KMS encryption. If you don't provide a key, your data is
         *        encrypted by default with a key that AWS owns and manages for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userKMSKey(String userKMSKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RepostspaceRequest.BuilderImpl implements Builder {
        private String description;

        private String name;

        private String roleArn;

        private String subdomain;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String tier;

        private String userKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpaceRequest model) {
            super(model);
            description(model.description);
            name(model.name);
            roleArn(model.roleArn);
            subdomain(model.subdomain);
            tags(model.tags);
            tier(model.tier);
            userKMSKey(model.userKMSKey);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSubdomain() {
            return subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getUserKMSKey() {
            return userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSpaceRequest build() {
            return new CreateSpaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
