/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSpaceRequest extends RepostspaceRequest implements
        ToCopyableBuilder<UpdateSpaceRequest.Builder, UpdateSpaceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSpaceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateSpaceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(UpdateSpaceRequest::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(UpdateSpaceRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ROLE_ARN_FIELD, SPACE_ID_FIELD, TIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String roleArn;

    private final String spaceId;

    private final String tier;

    private UpdateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.spaceId = builder.spaceId;
        this.tier = builder.tier;
    }

    /**
     * <p>
     * A description for the private re:Post. This is used only to help you identify this private re:Post.
     * </p>
     * 
     * @return A description for the private re:Post. This is used only to help you identify this private re:Post.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS support
     * tickets.
     * </p>
     * 
     * @return The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS
     *         support tickets.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The unique ID of this private re:Post.
     * </p>
     * 
     * @return The unique ID of this private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The pricing tier of this private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of this private re:Post.
     * @see TierLevel
     */
    public final TierLevel tier() {
        return TierLevel.fromValue(tier);
    }

    /**
     * <p>
     * The pricing tier of this private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of this private re:Post.
     * @see TierLevel
     */
    public final String tierAsString() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpaceRequest)) {
            return false;
        }
        UpdateSpaceRequest other = (UpdateSpaceRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(spaceId(), other.spaceId()) && Objects.equals(tierAsString(), other.tierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSpaceRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("SpaceId", spaceId()).add("Tier", tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("tier", TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpaceRequest, T> g) {
        return obj -> g.apply((UpdateSpaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RepostspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSpaceRequest> {
        /**
         * <p>
         * A description for the private re:Post. This is used only to help you identify this private re:Post.
         * </p>
         * 
         * @param description
         *        A description for the private re:Post. This is used only to help you identify this private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS support
         * tickets.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants permissions to the private re:Post to convert unanswered questions into AWS
         *        support tickets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The unique ID of this private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of this private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The pricing tier of this private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of this private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(String tier);

        /**
         * <p>
         * The pricing tier of this private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of this private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(TierLevel tier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RepostspaceRequest.BuilderImpl implements Builder {
        private String description;

        private String roleArn;

        private String spaceId;

        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpaceRequest model) {
            super(model);
            description(model.description);
            roleArn(model.roleArn);
            spaceId(model.spaceId);
            tier(model.tier);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpaceRequest build() {
            return new UpdateSpaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
