/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.repostspace.model.ChannelRole;
import software.amazon.awssdk.services.repostspace.model.ChannelRolesCopier;
import software.amazon.awssdk.services.repostspace.model.ChannelStatus;
import software.amazon.awssdk.services.repostspace.model.RepostspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChannelResponse
extends RepostspaceResponse
implements ToCopyableBuilder<Builder, GetChannelResponse> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(GetChannelResponse.getter(GetChannelResponse::spaceId)).setter(GetChannelResponse.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelId").getter(GetChannelResponse.getter(GetChannelResponse::channelId)).setter(GetChannelResponse.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(GetChannelResponse.getter(GetChannelResponse::channelName)).setter(GetChannelResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<String> CHANNEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelDescription").getter(GetChannelResponse.getter(GetChannelResponse::channelDescription)).setter(GetChannelResponse.setter(Builder::channelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelDescription").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createDateTime").getter(GetChannelResponse.getter(GetChannelResponse::createDateTime)).setter(GetChannelResponse.setter(Builder::createDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deleteDateTime").getter(GetChannelResponse.getter(GetChannelResponse::deleteDateTime)).setter(GetChannelResponse.setter(Builder::deleteDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, List<String>>> CHANNEL_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("channelRoles").getter(GetChannelResponse.getter(GetChannelResponse::channelRolesAsStrings)).setter(GetChannelResponse.setter(Builder::channelRolesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelRoles").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelStatus").getter(GetChannelResponse.getter(GetChannelResponse::channelStatusAsString)).setter(GetChannelResponse.setter(Builder::channelStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD, CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, CHANNEL_DESCRIPTION_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD, CHANNEL_ROLES_FIELD, CHANNEL_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetChannelResponse.memberNameToFieldInitializer();
    private final String spaceId;
    private final String channelId;
    private final String channelName;
    private final String channelDescription;
    private final Instant createDateTime;
    private final Instant deleteDateTime;
    private final Map<String, List<String>> channelRoles;
    private final String channelStatus;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.channelDescription = builder.channelDescription;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.channelRoles = builder.channelRoles;
        this.channelStatus = builder.channelStatus;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelDescription() {
        return this.channelDescription;
    }

    public final Instant createDateTime() {
        return this.createDateTime;
    }

    public final Instant deleteDateTime() {
        return this.deleteDateTime;
    }

    public final Map<String, List<ChannelRole>> channelRoles() {
        return ChannelRolesCopier.copyStringToEnum(this.channelRoles);
    }

    public final boolean hasChannelRoles() {
        return this.channelRoles != null && !(this.channelRoles instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> channelRolesAsStrings() {
        return this.channelRoles;
    }

    public final ChannelStatus channelStatus() {
        return ChannelStatus.fromValue(this.channelStatus);
    }

    public final String channelStatusAsString() {
        return this.channelStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelRoles() ? this.channelRolesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse)((Object)obj);
        return Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelDescription(), other.channelDescription()) && Objects.equals(this.createDateTime(), other.createDateTime()) && Objects.equals(this.deleteDateTime(), other.deleteDateTime()) && this.hasChannelRoles() == other.hasChannelRoles() && Objects.equals(this.channelRolesAsStrings(), other.channelRolesAsStrings()) && Objects.equals(this.channelStatusAsString(), other.channelStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetChannelResponse").add("SpaceId", (Object)this.spaceId()).add("ChannelId", (Object)this.channelId()).add("ChannelName", (Object)(this.channelName() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelDescription", (Object)(this.channelDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("CreateDateTime", (Object)this.createDateTime()).add("DeleteDateTime", (Object)this.deleteDateTime()).add("ChannelRoles", this.hasChannelRoles() ? this.channelRolesAsStrings() : null).add("ChannelStatus", (Object)this.channelStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "channelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "channelDescription": {
                return Optional.ofNullable(clazz.cast(this.channelDescription()));
            }
            case "createDateTime": {
                return Optional.ofNullable(clazz.cast(this.createDateTime()));
            }
            case "deleteDateTime": {
                return Optional.ofNullable(clazz.cast(this.deleteDateTime()));
            }
            case "channelRoles": {
                return Optional.ofNullable(clazz.cast(this.channelRolesAsStrings()));
            }
            case "channelStatus": {
                return Optional.ofNullable(clazz.cast(this.channelStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("channelDescription", CHANNEL_DESCRIPTION_FIELD);
        map.put("createDateTime", CREATE_DATE_TIME_FIELD);
        map.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
        map.put("channelRoles", CHANNEL_ROLES_FIELD);
        map.put("channelStatus", CHANNEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceResponse.BuilderImpl
    implements Builder {
        private String spaceId;
        private String channelId;
        private String channelName;
        private String channelDescription;
        private Instant createDateTime;
        private Instant deleteDateTime;
        private Map<String, List<String>> channelRoles = DefaultSdkAutoConstructMap.getInstance();
        private String channelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            this.spaceId(model.spaceId);
            this.channelId(model.channelId);
            this.channelName(model.channelName);
            this.channelDescription(model.channelDescription);
            this.createDateTime(model.createDateTime);
            this.deleteDateTime(model.deleteDateTime);
            this.channelRolesWithStrings(model.channelRoles);
            this.channelStatus(model.channelStatus);
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelDescription() {
            return this.channelDescription;
        }

        public final void setChannelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
        }

        @Override
        public final Builder channelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
            return this;
        }

        public final Instant getCreateDateTime() {
            return this.createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return this.deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChannelRoles() {
            if (this.channelRoles instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.channelRoles;
        }

        public final void setChannelRoles(Map<String, ? extends Collection<String>> channelRoles) {
            this.channelRoles = ChannelRolesCopier.copy(channelRoles);
        }

        @Override
        public final Builder channelRolesWithStrings(Map<String, ? extends Collection<String>> channelRoles) {
            this.channelRoles = ChannelRolesCopier.copy(channelRoles);
            return this;
        }

        public final String getChannelStatus() {
            return this.channelStatus;
        }

        public final void setChannelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
        }

        @Override
        public final Builder channelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
            return this;
        }

        @Override
        public final Builder channelStatus(ChannelStatus channelStatus) {
            this.channelStatus(channelStatus == null ? null : channelStatus.toString());
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChannelResponse> {
        public Builder spaceId(String var1);

        public Builder channelId(String var1);

        public Builder channelName(String var1);

        public Builder channelDescription(String var1);

        public Builder createDateTime(Instant var1);

        public Builder deleteDateTime(Instant var1);

        public Builder channelRolesWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder channelStatus(String var1);

        public Builder channelStatus(ChannelStatus var1);
    }
}

