/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRemoveChannelRoleFromAccessorsRequest extends RepostspaceRequest implements
        ToCopyableBuilder<BatchRemoveChannelRoleFromAccessorsRequest.Builder, BatchRemoveChannelRoleFromAccessorsRequest> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(BatchRemoveChannelRoleFromAccessorsRequest::spaceId))
            .setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelId").getter(getter(BatchRemoveChannelRoleFromAccessorsRequest::channelId))
            .setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()).build();

    private static final SdkField<List<String>> ACCESSOR_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessorIds")
            .getter(getter(BatchRemoveChannelRoleFromAccessorsRequest::accessorIds))
            .setter(setter(Builder::accessorIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessorIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelRole").getter(getter(BatchRemoveChannelRoleFromAccessorsRequest::channelRoleAsString))
            .setter(setter(Builder::channelRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD,
            CHANNEL_ID_FIELD, ACCESSOR_IDS_FIELD, CHANNEL_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String spaceId;

    private final String channelId;

    private final List<String> accessorIds;

    private final String channelRole;

    private BatchRemoveChannelRoleFromAccessorsRequest(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.channelId = builder.channelId;
        this.accessorIds = builder.accessorIds;
        this.channelRole = builder.channelRole;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The unique ID of the private re:Post channel.
     * </p>
     * 
     * @return The unique ID of the private re:Post channel.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessorIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessorIds() {
        return accessorIds != null && !(accessorIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users or groups identifiers to remove the role from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessorIds} method.
     * </p>
     * 
     * @return The users or groups identifiers to remove the role from.
     */
    public final List<String> accessorIds() {
        return accessorIds;
    }

    /**
     * <p>
     * The channel role to remove from the users or groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelRole} will
     * return {@link ChannelRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelRoleAsString}.
     * </p>
     * 
     * @return The channel role to remove from the users or groups.
     * @see ChannelRole
     */
    public final ChannelRole channelRole() {
        return ChannelRole.fromValue(channelRole);
    }

    /**
     * <p>
     * The channel role to remove from the users or groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelRole} will
     * return {@link ChannelRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelRoleAsString}.
     * </p>
     * 
     * @return The channel role to remove from the users or groups.
     * @see ChannelRole
     */
    public final String channelRoleAsString() {
        return channelRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessorIds() ? accessorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelRoleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRemoveChannelRoleFromAccessorsRequest)) {
            return false;
        }
        BatchRemoveChannelRoleFromAccessorsRequest other = (BatchRemoveChannelRoleFromAccessorsRequest) obj;
        return Objects.equals(spaceId(), other.spaceId()) && Objects.equals(channelId(), other.channelId())
                && hasAccessorIds() == other.hasAccessorIds() && Objects.equals(accessorIds(), other.accessorIds())
                && Objects.equals(channelRoleAsString(), other.channelRoleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRemoveChannelRoleFromAccessorsRequest").add("SpaceId", spaceId())
                .add("ChannelId", channelId()).add("AccessorIds", hasAccessorIds() ? accessorIds() : null)
                .add("ChannelRole", channelRoleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "channelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "accessorIds":
            return Optional.ofNullable(clazz.cast(accessorIds()));
        case "channelRole":
            return Optional.ofNullable(clazz.cast(channelRoleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("accessorIds", ACCESSOR_IDS_FIELD);
        map.put("channelRole", CHANNEL_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchRemoveChannelRoleFromAccessorsRequest, T> g) {
        return obj -> g.apply((BatchRemoveChannelRoleFromAccessorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RepostspaceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchRemoveChannelRoleFromAccessorsRequest> {
        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The unique ID of the private re:Post channel.
         * </p>
         * 
         * @param channelId
         *        The unique ID of the private re:Post channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * <p>
         * The users or groups identifiers to remove the role from.
         * </p>
         * 
         * @param accessorIds
         *        The users or groups identifiers to remove the role from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(Collection<String> accessorIds);

        /**
         * <p>
         * The users or groups identifiers to remove the role from.
         * </p>
         * 
         * @param accessorIds
         *        The users or groups identifiers to remove the role from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorIds(String... accessorIds);

        /**
         * <p>
         * The channel role to remove from the users or groups.
         * </p>
         * 
         * @param channelRole
         *        The channel role to remove from the users or groups.
         * @see ChannelRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelRole
         */
        Builder channelRole(String channelRole);

        /**
         * <p>
         * The channel role to remove from the users or groups.
         * </p>
         * 
         * @param channelRole
         *        The channel role to remove from the users or groups.
         * @see ChannelRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelRole
         */
        Builder channelRole(ChannelRole channelRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RepostspaceRequest.BuilderImpl implements Builder {
        private String spaceId;

        private String channelId;

        private List<String> accessorIds = DefaultSdkAutoConstructList.getInstance();

        private String channelRole;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRemoveChannelRoleFromAccessorsRequest model) {
            super(model);
            spaceId(model.spaceId);
            channelId(model.channelId);
            accessorIds(model.accessorIds);
            channelRole(model.channelRole);
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Collection<String> getAccessorIds() {
            if (accessorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accessorIds;
        }

        public final void setAccessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
        }

        @Override
        public final Builder accessorIds(Collection<String> accessorIds) {
            this.accessorIds = AccessorIdListCopier.copy(accessorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessorIds(String... accessorIds) {
            accessorIds(Arrays.asList(accessorIds));
            return this;
        }

        public final String getChannelRole() {
            return channelRole;
        }

        public final void setChannelRole(String channelRole) {
            this.channelRole = channelRole;
        }

        @Override
        public final Builder channelRole(String channelRole) {
            this.channelRole = channelRole;
            return this;
        }

        @Override
        public final Builder channelRole(ChannelRole channelRole) {
            this.channelRole(channelRole == null ? null : channelRole.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchRemoveChannelRoleFromAccessorsRequest build() {
            return new BatchRemoveChannelRoleFromAccessorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
