/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ChannelsListCopier {
    static List<ChannelData> copy(Collection<? extends ChannelData> channelsListParam) {
        List<ChannelData> list;
        if (channelsListParam == null || channelsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ChannelData> modifiableList = new ArrayList<>(channelsListParam.size());
            channelsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ChannelData> copyFromBuilder(Collection<? extends ChannelData.Builder> channelsListParam) {
        List<ChannelData> list;
        if (channelsListParam == null || channelsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ChannelData> modifiableList = new ArrayList<>(channelsListParam.size());
            channelsListParam.forEach(entry -> {
                ChannelData member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ChannelData.Builder> copyToBuilder(Collection<? extends ChannelData> channelsListParam) {
        List<ChannelData.Builder> list;
        if (channelsListParam == null || channelsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ChannelData.Builder> modifiableList = new ArrayList<>(channelsListParam.size());
            channelsListParam.forEach(entry -> {
                ChannelData.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
