/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelResponse extends RepostspaceResponse implements
        ToCopyableBuilder<GetChannelResponse.Builder, GetChannelResponse> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(GetChannelResponse::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelId").getter(getter(GetChannelResponse::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(GetChannelResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CHANNEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelDescription").getter(getter(GetChannelResponse::channelDescription))
            .setter(setter(Builder::channelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelDescription").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createDateTime")
            .getter(getter(GetChannelResponse::createDateTime))
            .setter(setter(Builder::createDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("deleteDateTime")
            .getter(getter(GetChannelResponse::deleteDateTime))
            .setter(setter(Builder::deleteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, List<String>>> CHANNEL_ROLES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("channelRoles")
            .getter(getter(GetChannelResponse::channelRolesAsStrings))
            .setter(setter(Builder::channelRolesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelRoles").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelStatus").getter(getter(GetChannelResponse::channelStatusAsString))
            .setter(setter(Builder::channelStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD,
            CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, CHANNEL_DESCRIPTION_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD,
            CHANNEL_ROLES_FIELD, CHANNEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String spaceId;

    private final String channelId;

    private final String channelName;

    private final String channelDescription;

    private final Instant createDateTime;

    private final Instant deleteDateTime;

    private final Map<String, List<String>> channelRoles;

    private final String channelStatus;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.channelDescription = builder.channelDescription;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.channelRoles = builder.channelRoles;
        this.channelStatus = builder.channelStatus;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The unique ID of the private re:Post channel.
     * </p>
     * 
     * @return The unique ID of the private re:Post channel.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * <p>
     * The name for the channel. This must be unique per private re:Post.
     * </p>
     * 
     * @return The name for the channel. This must be unique per private re:Post.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * A description for the channel. This is used only to help you identify this channel.
     * </p>
     * 
     * @return A description for the channel. This is used only to help you identify this channel.
     */
    public final String channelDescription() {
        return channelDescription;
    }

    /**
     * <p>
     * The date when the channel was created.
     * </p>
     * 
     * @return The date when the channel was created.
     */
    public final Instant createDateTime() {
        return createDateTime;
    }

    /**
     * <p>
     * The date when the channel was deleted.
     * </p>
     * 
     * @return The date when the channel was deleted.
     */
    public final Instant deleteDateTime() {
        return deleteDateTime;
    }

    /**
     * <p>
     * The channel roles associated to the users and groups of the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelRoles} method.
     * </p>
     * 
     * @return The channel roles associated to the users and groups of the channel.
     */
    public final Map<String, List<ChannelRole>> channelRoles() {
        return ChannelRolesCopier.copyStringToEnum(channelRoles);
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelRoles() {
        return channelRoles != null && !(channelRoles instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The channel roles associated to the users and groups of the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelRoles} method.
     * </p>
     * 
     * @return The channel roles associated to the users and groups of the channel.
     */
    public final Map<String, List<String>> channelRolesAsStrings() {
        return channelRoles;
    }

    /**
     * <p>
     * The status pf the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return The status pf the channel.
     * @see ChannelStatus
     */
    public final ChannelStatus channelStatus() {
        return ChannelStatus.fromValue(channelStatus);
    }

    /**
     * <p>
     * The status pf the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return The status pf the channel.
     * @see ChannelStatus
     */
    public final String channelStatusAsString() {
        return channelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelRoles() ? channelRolesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse) obj;
        return Objects.equals(spaceId(), other.spaceId()) && Objects.equals(channelId(), other.channelId())
                && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelDescription(), other.channelDescription())
                && Objects.equals(createDateTime(), other.createDateTime())
                && Objects.equals(deleteDateTime(), other.deleteDateTime()) && hasChannelRoles() == other.hasChannelRoles()
                && Objects.equals(channelRolesAsStrings(), other.channelRolesAsStrings())
                && Objects.equals(channelStatusAsString(), other.channelStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelResponse").add("SpaceId", spaceId()).add("ChannelId", channelId())
                .add("ChannelName", channelName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelDescription", channelDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreateDateTime", createDateTime()).add("DeleteDateTime", deleteDateTime())
                .add("ChannelRoles", hasChannelRoles() ? channelRolesAsStrings() : null)
                .add("ChannelStatus", channelStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "channelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelDescription":
            return Optional.ofNullable(clazz.cast(channelDescription()));
        case "createDateTime":
            return Optional.ofNullable(clazz.cast(createDateTime()));
        case "deleteDateTime":
            return Optional.ofNullable(clazz.cast(deleteDateTime()));
        case "channelRoles":
            return Optional.ofNullable(clazz.cast(channelRolesAsStrings()));
        case "channelStatus":
            return Optional.ofNullable(clazz.cast(channelStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("channelDescription", CHANNEL_DESCRIPTION_FIELD);
        map.put("createDateTime", CREATE_DATE_TIME_FIELD);
        map.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
        map.put("channelRoles", CHANNEL_ROLES_FIELD);
        map.put("channelStatus", CHANNEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RepostspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelResponse> {
        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The unique ID of the private re:Post channel.
         * </p>
         * 
         * @param channelId
         *        The unique ID of the private re:Post channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * <p>
         * The name for the channel. This must be unique per private re:Post.
         * </p>
         * 
         * @param channelName
         *        The name for the channel. This must be unique per private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * A description for the channel. This is used only to help you identify this channel.
         * </p>
         * 
         * @param channelDescription
         *        A description for the channel. This is used only to help you identify this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDescription(String channelDescription);

        /**
         * <p>
         * The date when the channel was created.
         * </p>
         * 
         * @param createDateTime
         *        The date when the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDateTime(Instant createDateTime);

        /**
         * <p>
         * The date when the channel was deleted.
         * </p>
         * 
         * @param deleteDateTime
         *        The date when the channel was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDateTime(Instant deleteDateTime);

        /**
         * <p>
         * The channel roles associated to the users and groups of the channel.
         * </p>
         * 
         * @param channelRoles
         *        The channel roles associated to the users and groups of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelRolesWithStrings(Map<String, ? extends Collection<String>> channelRoles);

        /**
         * <p>
         * The status pf the channel.
         * </p>
         * 
         * @param channelStatus
         *        The status pf the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder channelStatus(String channelStatus);

        /**
         * <p>
         * The status pf the channel.
         * </p>
         * 
         * @param channelStatus
         *        The status pf the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder channelStatus(ChannelStatus channelStatus);
    }

    static final class BuilderImpl extends RepostspaceResponse.BuilderImpl implements Builder {
        private String spaceId;

        private String channelId;

        private String channelName;

        private String channelDescription;

        private Instant createDateTime;

        private Instant deleteDateTime;

        private Map<String, List<String>> channelRoles = DefaultSdkAutoConstructMap.getInstance();

        private String channelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            spaceId(model.spaceId);
            channelId(model.channelId);
            channelName(model.channelName);
            channelDescription(model.channelDescription);
            createDateTime(model.createDateTime);
            deleteDateTime(model.deleteDateTime);
            channelRolesWithStrings(model.channelRoles);
            channelStatus(model.channelStatus);
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelDescription() {
            return channelDescription;
        }

        public final void setChannelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
        }

        @Override
        public final Builder channelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
            return this;
        }

        public final Instant getCreateDateTime() {
            return createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChannelRoles() {
            if (channelRoles instanceof SdkAutoConstructMap) {
                return null;
            }
            return channelRoles;
        }

        public final void setChannelRoles(Map<String, ? extends Collection<String>> channelRoles) {
            this.channelRoles = ChannelRolesCopier.copy(channelRoles);
        }

        @Override
        public final Builder channelRolesWithStrings(Map<String, ? extends Collection<String>> channelRoles) {
            this.channelRoles = ChannelRolesCopier.copy(channelRoles);
            return this;
        }

        public final String getChannelStatus() {
            return channelStatus;
        }

        public final void setChannelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
        }

        @Override
        public final Builder channelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
            return this;
        }

        @Override
        public final Builder channelStatus(ChannelStatus channelStatus) {
            this.channelStatus(channelStatus == null ? null : channelStatus.toString());
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
