/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains some information about a private re:Post in the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceData implements SdkPojo, Serializable, ToCopyableBuilder<SpaceData.Builder, SpaceData> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(SpaceData::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SpaceData::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SpaceData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SpaceData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SpaceData::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationStatus").getter(getter(SpaceData::configurationStatusAsString))
            .setter(setter(Builder::configurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build())
            .build();

    private static final SdkField<String> VANITY_DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vanityDomainStatus").getter(getter(SpaceData::vanityDomainStatusAsString))
            .setter(setter(Builder::vanityDomainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomainStatus").build())
            .build();

    private static final SdkField<String> VANITY_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vanityDomain").getter(getter(SpaceData::vanityDomain)).setter(setter(Builder::vanityDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomain").build()).build();

    private static final SdkField<String> RANDOM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("randomDomain").getter(getter(SpaceData::randomDomain)).setter(setter(Builder::randomDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomDomain").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(SpaceData::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<Long> STORAGE_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storageLimit").getter(getter(SpaceData::storageLimit)).setter(setter(Builder::storageLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLimit").build()).build();

    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createDateTime")
            .getter(getter(SpaceData::createDateTime))
            .setter(setter(Builder::createDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("deleteDateTime")
            .getter(getter(SpaceData::deleteDateTime))
            .setter(setter(Builder::deleteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userKMSKey").getter(getter(SpaceData::userKMSKey)).setter(setter(Builder::userKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("userCount").getter(getter(SpaceData::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()).build();

    private static final SdkField<Long> CONTENT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("contentSize").getter(getter(SpaceData::contentSize)).setter(setter(Builder::contentSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSize").build()).build();

    private static final SdkField<SupportedEmailDomainsStatus> SUPPORTED_EMAIL_DOMAINS_FIELD = SdkField
            .<SupportedEmailDomainsStatus> builder(MarshallingType.SDK_POJO).memberName("supportedEmailDomains")
            .getter(getter(SpaceData::supportedEmailDomains)).setter(setter(Builder::supportedEmailDomains))
            .constructor(SupportedEmailDomainsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEmailDomains").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CONFIGURATION_STATUS_FIELD, VANITY_DOMAIN_STATUS_FIELD,
            VANITY_DOMAIN_FIELD, RANDOM_DOMAIN_FIELD, TIER_FIELD, STORAGE_LIMIT_FIELD, CREATE_DATE_TIME_FIELD,
            DELETE_DATE_TIME_FIELD, USER_KMS_KEY_FIELD, USER_COUNT_FIELD, CONTENT_SIZE_FIELD, SUPPORTED_EMAIL_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String spaceId;

    private final String arn;

    private final String name;

    private final String description;

    private final String status;

    private final String configurationStatus;

    private final String vanityDomainStatus;

    private final String vanityDomain;

    private final String randomDomain;

    private final String tier;

    private final Long storageLimit;

    private final Instant createDateTime;

    private final Instant deleteDateTime;

    private final String userKMSKey;

    private final Integer userCount;

    private final Long contentSize;

    private final SupportedEmailDomainsStatus supportedEmailDomains;

    private SpaceData(BuilderImpl builder) {
        this.spaceId = builder.spaceId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.configurationStatus = builder.configurationStatus;
        this.vanityDomainStatus = builder.vanityDomainStatus;
        this.vanityDomain = builder.vanityDomain;
        this.randomDomain = builder.randomDomain;
        this.tier = builder.tier;
        this.storageLimit = builder.storageLimit;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.userKMSKey = builder.userKMSKey;
        this.userCount = builder.userCount;
        this.contentSize = builder.contentSize;
        this.supportedEmailDomains = builder.supportedEmailDomains;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The ARN of the private re:Post.
     * </p>
     * 
     * @return The ARN of the private re:Post.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name for the private re:Post.
     * </p>
     * 
     * @return The name for the private re:Post.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the private re:Post. This is used only to help you identify this private re:Post.
     * </p>
     * 
     * @return The description for the private re:Post. This is used only to help you identify this private re:Post.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The creation/deletion status of the private re:Post.
     * </p>
     * 
     * @return The creation/deletion status of the private re:Post.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The configuration status of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationStatus} will return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStatusAsString}.
     * </p>
     * 
     * @return The configuration status of the private re:Post.
     * @see ConfigurationStatus
     */
    public final ConfigurationStatus configurationStatus() {
        return ConfigurationStatus.fromValue(configurationStatus);
    }

    /**
     * <p>
     * The configuration status of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationStatus} will return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStatusAsString}.
     * </p>
     * 
     * @return The configuration status of the private re:Post.
     * @see ConfigurationStatus
     */
    public final String configurationStatusAsString() {
        return configurationStatus;
    }

    /**
     * <p>
     * This approval status of the custom subdomain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vanityDomainStatus} will return {@link VanityDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #vanityDomainStatusAsString}.
     * </p>
     * 
     * @return This approval status of the custom subdomain.
     * @see VanityDomainStatus
     */
    public final VanityDomainStatus vanityDomainStatus() {
        return VanityDomainStatus.fromValue(vanityDomainStatus);
    }

    /**
     * <p>
     * This approval status of the custom subdomain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vanityDomainStatus} will return {@link VanityDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #vanityDomainStatusAsString}.
     * </p>
     * 
     * @return This approval status of the custom subdomain.
     * @see VanityDomainStatus
     */
    public final String vanityDomainStatusAsString() {
        return vanityDomainStatus;
    }

    /**
     * <p>
     * This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved by AWS
     * before use.
     * </p>
     * 
     * @return This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved
     *         by AWS before use.
     */
    public final String vanityDomain() {
        return vanityDomain;
    }

    /**
     * <p>
     * The AWS generated subdomain of the private re:Post.
     * </p>
     * 
     * @return The AWS generated subdomain of the private re:Post.
     */
    public final String randomDomain() {
        return randomDomain;
    }

    /**
     * <p>
     * The pricing tier of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of the private re:Post.
     * @see TierLevel
     */
    public final TierLevel tier() {
        return TierLevel.fromValue(tier);
    }

    /**
     * <p>
     * The pricing tier of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of the private re:Post.
     * @see TierLevel
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The storage limit of the private re:Post.
     * </p>
     * 
     * @return The storage limit of the private re:Post.
     */
    public final Long storageLimit() {
        return storageLimit;
    }

    /**
     * <p>
     * The date when the private re:Post was created.
     * </p>
     * 
     * @return The date when the private re:Post was created.
     */
    public final Instant createDateTime() {
        return createDateTime;
    }

    /**
     * <p>
     * The date when the private re:Post was deleted.
     * </p>
     * 
     * @return The date when the private re:Post was deleted.
     */
    public final Instant deleteDateTime() {
        return deleteDateTime;
    }

    /**
     * <p>
     * The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
     * </p>
     * 
     * @return The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
     */
    public final String userKMSKey() {
        return userKMSKey;
    }

    /**
     * <p>
     * The number of onboarded users to the private re:Post.
     * </p>
     * 
     * @return The number of onboarded users to the private re:Post.
     */
    public final Integer userCount() {
        return userCount;
    }

    /**
     * <p>
     * The content size of the private re:Post.
     * </p>
     * 
     * @return The content size of the private re:Post.
     */
    public final Long contentSize() {
        return contentSize;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final SupportedEmailDomainsStatus supportedEmailDomains() {
        return supportedEmailDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(configurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vanityDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vanityDomain());
        hashCode = 31 * hashCode + Objects.hashCode(randomDomain());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        hashCode = 31 * hashCode + Objects.hashCode(contentSize());
        hashCode = 31 * hashCode + Objects.hashCode(supportedEmailDomains());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceData)) {
            return false;
        }
        SpaceData other = (SpaceData) obj;
        return Objects.equals(spaceId(), other.spaceId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(status(), other.status())
                && Objects.equals(configurationStatusAsString(), other.configurationStatusAsString())
                && Objects.equals(vanityDomainStatusAsString(), other.vanityDomainStatusAsString())
                && Objects.equals(vanityDomain(), other.vanityDomain()) && Objects.equals(randomDomain(), other.randomDomain())
                && Objects.equals(tierAsString(), other.tierAsString()) && Objects.equals(storageLimit(), other.storageLimit())
                && Objects.equals(createDateTime(), other.createDateTime())
                && Objects.equals(deleteDateTime(), other.deleteDateTime()) && Objects.equals(userKMSKey(), other.userKMSKey())
                && Objects.equals(userCount(), other.userCount()) && Objects.equals(contentSize(), other.contentSize())
                && Objects.equals(supportedEmailDomains(), other.supportedEmailDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceData").add("SpaceId", spaceId()).add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Status", status())
                .add("ConfigurationStatus", configurationStatusAsString())
                .add("VanityDomainStatus", vanityDomainStatusAsString()).add("VanityDomain", vanityDomain())
                .add("RandomDomain", randomDomain()).add("Tier", tierAsString()).add("StorageLimit", storageLimit())
                .add("CreateDateTime", createDateTime()).add("DeleteDateTime", deleteDateTime()).add("UserKMSKey", userKMSKey())
                .add("UserCount", userCount()).add("ContentSize", contentSize())
                .add("SupportedEmailDomains", supportedEmailDomains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "configurationStatus":
            return Optional.ofNullable(clazz.cast(configurationStatusAsString()));
        case "vanityDomainStatus":
            return Optional.ofNullable(clazz.cast(vanityDomainStatusAsString()));
        case "vanityDomain":
            return Optional.ofNullable(clazz.cast(vanityDomain()));
        case "randomDomain":
            return Optional.ofNullable(clazz.cast(randomDomain()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "storageLimit":
            return Optional.ofNullable(clazz.cast(storageLimit()));
        case "createDateTime":
            return Optional.ofNullable(clazz.cast(createDateTime()));
        case "deleteDateTime":
            return Optional.ofNullable(clazz.cast(deleteDateTime()));
        case "userKMSKey":
            return Optional.ofNullable(clazz.cast(userKMSKey()));
        case "userCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        case "contentSize":
            return Optional.ofNullable(clazz.cast(contentSize()));
        case "supportedEmailDomains":
            return Optional.ofNullable(clazz.cast(supportedEmailDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
        map.put("vanityDomainStatus", VANITY_DOMAIN_STATUS_FIELD);
        map.put("vanityDomain", VANITY_DOMAIN_FIELD);
        map.put("randomDomain", RANDOM_DOMAIN_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("storageLimit", STORAGE_LIMIT_FIELD);
        map.put("createDateTime", CREATE_DATE_TIME_FIELD);
        map.put("deleteDateTime", DELETE_DATE_TIME_FIELD);
        map.put("userKMSKey", USER_KMS_KEY_FIELD);
        map.put("userCount", USER_COUNT_FIELD);
        map.put("contentSize", CONTENT_SIZE_FIELD);
        map.put("supportedEmailDomains", SUPPORTED_EMAIL_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceData, T> g) {
        return obj -> g.apply((SpaceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceData> {
        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The ARN of the private re:Post.
         * </p>
         * 
         * @param arn
         *        The ARN of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name for the private re:Post.
         * </p>
         * 
         * @param name
         *        The name for the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the private re:Post. This is used only to help you identify this private re:Post.
         * </p>
         * 
         * @param description
         *        The description for the private re:Post. This is used only to help you identify this private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The creation/deletion status of the private re:Post.
         * </p>
         * 
         * @param status
         *        The creation/deletion status of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The configuration status of the private re:Post.
         * </p>
         * 
         * @param configurationStatus
         *        The configuration status of the private re:Post.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder configurationStatus(String configurationStatus);

        /**
         * <p>
         * The configuration status of the private re:Post.
         * </p>
         * 
         * @param configurationStatus
         *        The configuration status of the private re:Post.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder configurationStatus(ConfigurationStatus configurationStatus);

        /**
         * <p>
         * This approval status of the custom subdomain.
         * </p>
         * 
         * @param vanityDomainStatus
         *        This approval status of the custom subdomain.
         * @see VanityDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VanityDomainStatus
         */
        Builder vanityDomainStatus(String vanityDomainStatus);

        /**
         * <p>
         * This approval status of the custom subdomain.
         * </p>
         * 
         * @param vanityDomainStatus
         *        This approval status of the custom subdomain.
         * @see VanityDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VanityDomainStatus
         */
        Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus);

        /**
         * <p>
         * This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved by
         * AWS before use.
         * </p>
         * 
         * @param vanityDomain
         *        This custom subdomain that you use to access your private re:Post. All custom subdomains must be
         *        approved by AWS before use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vanityDomain(String vanityDomain);

        /**
         * <p>
         * The AWS generated subdomain of the private re:Post.
         * </p>
         * 
         * @param randomDomain
         *        The AWS generated subdomain of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomDomain(String randomDomain);

        /**
         * <p>
         * The pricing tier of the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(String tier);

        /**
         * <p>
         * The pricing tier of the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(TierLevel tier);

        /**
         * <p>
         * The storage limit of the private re:Post.
         * </p>
         * 
         * @param storageLimit
         *        The storage limit of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLimit(Long storageLimit);

        /**
         * <p>
         * The date when the private re:Post was created.
         * </p>
         * 
         * @param createDateTime
         *        The date when the private re:Post was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDateTime(Instant createDateTime);

        /**
         * <p>
         * The date when the private re:Post was deleted.
         * </p>
         * 
         * @param deleteDateTime
         *        The date when the private re:Post was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDateTime(Instant deleteDateTime);

        /**
         * <p>
         * The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
         * </p>
         * 
         * @param userKMSKey
         *        The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userKMSKey(String userKMSKey);

        /**
         * <p>
         * The number of onboarded users to the private re:Post.
         * </p>
         * 
         * @param userCount
         *        The number of onboarded users to the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);

        /**
         * <p>
         * The content size of the private re:Post.
         * </p>
         * 
         * @param contentSize
         *        The content size of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSize(Long contentSize);

        /**
         * <p/>
         * 
         * @param supportedEmailDomains
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEmailDomains(SupportedEmailDomainsStatus supportedEmailDomains);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link SupportedEmailDomainsStatus.Builder}
         * avoiding the need to create one manually via {@link SupportedEmailDomainsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportedEmailDomainsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #supportedEmailDomains(SupportedEmailDomainsStatus)}.
         * 
         * @param supportedEmailDomains
         *        a consumer that will call methods on {@link SupportedEmailDomainsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedEmailDomains(SupportedEmailDomainsStatus)
         */
        default Builder supportedEmailDomains(Consumer<SupportedEmailDomainsStatus.Builder> supportedEmailDomains) {
            return supportedEmailDomains(SupportedEmailDomainsStatus.builder().applyMutation(supportedEmailDomains).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String spaceId;

        private String arn;

        private String name;

        private String description;

        private String status;

        private String configurationStatus;

        private String vanityDomainStatus;

        private String vanityDomain;

        private String randomDomain;

        private String tier;

        private Long storageLimit;

        private Instant createDateTime;

        private Instant deleteDateTime;

        private String userKMSKey;

        private Integer userCount;

        private Long contentSize;

        private SupportedEmailDomainsStatus supportedEmailDomains;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceData model) {
            spaceId(model.spaceId);
            arn(model.arn);
            name(model.name);
            description(model.description);
            status(model.status);
            configurationStatus(model.configurationStatus);
            vanityDomainStatus(model.vanityDomainStatus);
            vanityDomain(model.vanityDomain);
            randomDomain(model.randomDomain);
            tier(model.tier);
            storageLimit(model.storageLimit);
            createDateTime(model.createDateTime);
            deleteDateTime(model.deleteDateTime);
            userKMSKey(model.userKMSKey);
            userCount(model.userCount);
            contentSize(model.contentSize);
            supportedEmailDomains(model.supportedEmailDomains);
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getConfigurationStatus() {
            return configurationStatus;
        }

        public final void setConfigurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
        }

        @Override
        public final Builder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus(configurationStatus == null ? null : configurationStatus.toString());
            return this;
        }

        public final String getVanityDomainStatus() {
            return vanityDomainStatus;
        }

        public final void setVanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
        }

        @Override
        public final Builder vanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
            return this;
        }

        @Override
        public final Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus) {
            this.vanityDomainStatus(vanityDomainStatus == null ? null : vanityDomainStatus.toString());
            return this;
        }

        public final String getVanityDomain() {
            return vanityDomain;
        }

        public final void setVanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
        }

        @Override
        public final Builder vanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
            return this;
        }

        public final String getRandomDomain() {
            return randomDomain;
        }

        public final void setRandomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
        }

        @Override
        public final Builder randomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Long getStorageLimit() {
            return storageLimit;
        }

        public final void setStorageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final Instant getCreateDateTime() {
            return createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getUserKMSKey() {
            return userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Long getContentSize() {
            return contentSize;
        }

        public final void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }

        @Override
        public final Builder contentSize(Long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public final SupportedEmailDomainsStatus.Builder getSupportedEmailDomains() {
            return supportedEmailDomains != null ? supportedEmailDomains.toBuilder() : null;
        }

        public final void setSupportedEmailDomains(SupportedEmailDomainsStatus.BuilderImpl supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains != null ? supportedEmailDomains.build() : null;
        }

        @Override
        public final Builder supportedEmailDomains(SupportedEmailDomainsStatus supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains;
            return this;
        }

        @Override
        public SpaceData build() {
            return new SpaceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
