/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<String> SPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceId").getter(CreateChannelRequest.getter(CreateChannelRequest::spaceId)).setter(CreateChannelRequest.setter(Builder::spaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spaceId").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(CreateChannelRequest.getter(CreateChannelRequest::channelName)).setter(CreateChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<String> CHANNEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelDescription").getter(CreateChannelRequest.getter(CreateChannelRequest::channelDescription)).setter(CreateChannelRequest.setter(Builder::channelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_ID_FIELD, CHANNEL_NAME_FIELD, CHANNEL_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChannelRequest.memberNameToFieldInitializer();
    private final String spaceId;
    private final String channelName;
    private final String channelDescription;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.spaceId = builder.spaceId;
        this.channelName = builder.channelName;
        this.channelDescription = builder.channelDescription;
    }

    public final String spaceId() {
        return this.spaceId;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String channelDescription() {
        return this.channelDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.spaceId(), other.spaceId()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelDescription(), other.channelDescription());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("SpaceId", (Object)this.spaceId()).add("ChannelName", (Object)(this.channelName() == null ? null : "*** Sensitive Data Redacted ***")).add("ChannelDescription", (Object)(this.channelDescription() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceId": {
                return Optional.ofNullable(clazz.cast(this.spaceId()));
            }
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "channelDescription": {
                return Optional.ofNullable(clazz.cast(this.channelDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("spaceId", SPACE_ID_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("channelDescription", CHANNEL_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private String spaceId;
        private String channelName;
        private String channelDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.spaceId(model.spaceId);
            this.channelName(model.channelName);
            this.channelDescription(model.channelDescription);
        }

        public final String getSpaceId() {
            return this.spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelDescription() {
            return this.channelDescription;
        }

        public final void setChannelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
        }

        @Override
        public final Builder channelDescription(String channelDescription) {
            this.channelDescription = channelDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder spaceId(String var1);

        public Builder channelName(String var1);

        public Builder channelDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

