/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.repostspace.model.RepostspaceRequest;
import software.amazon.awssdk.services.repostspace.model.SupportedEmailDomainsParameters;
import software.amazon.awssdk.services.repostspace.model.TagsCopier;
import software.amazon.awssdk.services.repostspace.model.TierLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSpaceRequest
extends RepostspaceRequest
implements ToCopyableBuilder<Builder, CreateSpaceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSpaceRequest.getter(CreateSpaceRequest::name)).setter(CreateSpaceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subdomain").getter(CreateSpaceRequest.getter(CreateSpaceRequest::subdomain)).setter(CreateSpaceRequest.setter(Builder::subdomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdomain").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(CreateSpaceRequest.getter(CreateSpaceRequest::tierAsString)).setter(CreateSpaceRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSpaceRequest.getter(CreateSpaceRequest::description)).setter(CreateSpaceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userKMSKey").getter(CreateSpaceRequest.getter(CreateSpaceRequest::userKMSKey)).setter(CreateSpaceRequest.setter(Builder::userKMSKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSpaceRequest.getter(CreateSpaceRequest::tags)).setter(CreateSpaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateSpaceRequest.getter(CreateSpaceRequest::roleArn)).setter(CreateSpaceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<SupportedEmailDomainsParameters> SUPPORTED_EMAIL_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supportedEmailDomains").getter(CreateSpaceRequest.getter(CreateSpaceRequest::supportedEmailDomains)).setter(CreateSpaceRequest.setter(Builder::supportedEmailDomains)).constructor(SupportedEmailDomainsParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEmailDomains").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SUBDOMAIN_FIELD, TIER_FIELD, DESCRIPTION_FIELD, USER_KMS_KEY_FIELD, TAGS_FIELD, ROLE_ARN_FIELD, SUPPORTED_EMAIL_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSpaceRequest.memberNameToFieldInitializer();
    private final String name;
    private final String subdomain;
    private final String tier;
    private final String description;
    private final String userKMSKey;
    private final Map<String, String> tags;
    private final String roleArn;
    private final SupportedEmailDomainsParameters supportedEmailDomains;

    private CreateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.subdomain = builder.subdomain;
        this.tier = builder.tier;
        this.description = builder.description;
        this.userKMSKey = builder.userKMSKey;
        this.tags = builder.tags;
        this.roleArn = builder.roleArn;
        this.supportedEmailDomains = builder.supportedEmailDomains;
    }

    public final String name() {
        return this.name;
    }

    public final String subdomain() {
        return this.subdomain;
    }

    public final TierLevel tier() {
        return TierLevel.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String description() {
        return this.description;
    }

    public final String userKMSKey() {
        return this.userKMSKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final SupportedEmailDomainsParameters supportedEmailDomains() {
        return this.supportedEmailDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEmailDomains());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpaceRequest)) {
            return false;
        }
        CreateSpaceRequest other = (CreateSpaceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.subdomain(), other.subdomain()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.userKMSKey(), other.userKMSKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.supportedEmailDomains(), other.supportedEmailDomains());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSpaceRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Subdomain", (Object)this.subdomain()).add("Tier", (Object)this.tierAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("UserKMSKey", (Object)this.userKMSKey()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("SupportedEmailDomains", (Object)this.supportedEmailDomains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "subdomain": {
                return Optional.ofNullable(clazz.cast(this.subdomain()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "userKMSKey": {
                return Optional.ofNullable(clazz.cast(this.userKMSKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "supportedEmailDomains": {
                return Optional.ofNullable(clazz.cast(this.supportedEmailDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("subdomain", SUBDOMAIN_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("userKMSKey", USER_KMS_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("supportedEmailDomains", SUPPORTED_EMAIL_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSpaceRequest, T> g) {
        return obj -> g.apply((CreateSpaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RepostspaceRequest.BuilderImpl
    implements Builder {
        private String name;
        private String subdomain;
        private String tier;
        private String description;
        private String userKMSKey;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private SupportedEmailDomainsParameters supportedEmailDomains;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpaceRequest model) {
            super(model);
            this.name(model.name);
            this.subdomain(model.subdomain);
            this.tier(model.tier);
            this.description(model.description);
            this.userKMSKey(model.userKMSKey);
            this.tags(model.tags);
            this.roleArn(model.roleArn);
            this.supportedEmailDomains(model.supportedEmailDomains);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSubdomain() {
            return this.subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserKMSKey() {
            return this.userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final SupportedEmailDomainsParameters.Builder getSupportedEmailDomains() {
            return this.supportedEmailDomains != null ? this.supportedEmailDomains.toBuilder() : null;
        }

        public final void setSupportedEmailDomains(SupportedEmailDomainsParameters.BuilderImpl supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains != null ? supportedEmailDomains.build() : null;
        }

        @Override
        public final Builder supportedEmailDomains(SupportedEmailDomainsParameters supportedEmailDomains) {
            this.supportedEmailDomains = supportedEmailDomains;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSpaceRequest build() {
            return new CreateSpaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RepostspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSpaceRequest> {
        public Builder name(String var1);

        public Builder subdomain(String var1);

        public Builder tier(String var1);

        public Builder tier(TierLevel var1);

        public Builder description(String var1);

        public Builder userKMSKey(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder roleArn(String var1);

        public Builder supportedEmailDomains(SupportedEmailDomainsParameters var1);

        default public Builder supportedEmailDomains(Consumer<SupportedEmailDomainsParameters.Builder> supportedEmailDomains) {
            return this.supportedEmailDomains((SupportedEmailDomainsParameters)((SupportedEmailDomainsParameters.Builder)SupportedEmailDomainsParameters.builder().applyMutation(supportedEmailDomains)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

