/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedEmailDomainsParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedEmailDomainsParameters.Builder, SupportedEmailDomainsParameters> {
    private static final SdkField<String> ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("enabled")
            .getter(getter(SupportedEmailDomainsParameters::enabledAsString)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedDomains")
            .getter(getter(SupportedEmailDomainsParameters::allowedDomains))
            .setter(setter(Builder::allowedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            ALLOWED_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String enabled;

    private final List<String> allowedDomains;

    private SupportedEmailDomainsParameters(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.allowedDomains = builder.allowedDomains;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enabled} will
     * return {@link FeatureEnableParameter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enabledAsString}.
     * </p>
     * 
     * @return
     * @see FeatureEnableParameter
     */
    public final FeatureEnableParameter enabled() {
        return FeatureEnableParameter.fromValue(enabled);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enabled} will
     * return {@link FeatureEnableParameter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enabledAsString}.
     * </p>
     * 
     * @return
     * @see FeatureEnableParameter
     */
    public final String enabledAsString() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedDomains() {
        return allowedDomains != null && !(allowedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedDomains} method.
     * </p>
     * 
     * @return
     */
    public final List<String> allowedDomains() {
        return allowedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedDomains() ? allowedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEmailDomainsParameters)) {
            return false;
        }
        SupportedEmailDomainsParameters other = (SupportedEmailDomainsParameters) obj;
        return Objects.equals(enabledAsString(), other.enabledAsString()) && hasAllowedDomains() == other.hasAllowedDomains()
                && Objects.equals(allowedDomains(), other.allowedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedEmailDomainsParameters").add("Enabled", enabledAsString())
                .add("AllowedDomains", allowedDomains() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabledAsString()));
        case "allowedDomains":
            return Optional.ofNullable(clazz.cast(allowedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("allowedDomains", ALLOWED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedEmailDomainsParameters, T> g) {
        return obj -> g.apply((SupportedEmailDomainsParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedEmailDomainsParameters> {
        /**
         * <p/>
         * 
         * @param enabled
         * @see FeatureEnableParameter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEnableParameter
         */
        Builder enabled(String enabled);

        /**
         * <p/>
         * 
         * @param enabled
         * @see FeatureEnableParameter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureEnableParameter
         */
        Builder enabled(FeatureEnableParameter enabled);

        /**
         * <p/>
         * 
         * @param allowedDomains
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(Collection<String> allowedDomains);

        /**
         * <p/>
         * 
         * @param allowedDomains
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(String... allowedDomains);
    }

    static final class BuilderImpl implements Builder {
        private String enabled;

        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEmailDomainsParameters model) {
            enabled(model.enabled);
            allowedDomains(model.allowedDomains);
        }

        public final String getEnabled() {
            return enabled;
        }

        public final void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public final Builder enabled(FeatureEnableParameter enabled) {
            this.enabled(enabled == null ? null : enabled.toString());
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = AllowedDomainsListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = AllowedDomainsListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String... allowedDomains) {
            allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        @Override
        public SupportedEmailDomainsParameters build() {
            return new SupportedEmailDomainsParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
