/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationTemplatesRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<ListRecommendationTemplatesRequest.Builder, ListRecommendationTemplatesRequest> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(ListRecommendationTemplatesRequest::assessmentArn))
            .setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecommendationTemplatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListRecommendationTemplatesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationTemplatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("recommendationTemplateArn")
            .getter(getter(ListRecommendationTemplatesRequest::recommendationTemplateArn))
            .setter(setter(Builder::recommendationTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recommendationTemplateArn")
                    .build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(ListRecommendationTemplatesRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reverseOrder").build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("status")
            .getter(getter(ListRecommendationTemplatesRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ASSESSMENT_ARN_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, RECOMMENDATION_TEMPLATE_ARN_FIELD,
                    REVERSE_ORDER_FIELD, STATUS_FIELD));

    private final String assessmentArn;

    private final Integer maxResults;

    private final String name;

    private final String nextToken;

    private final String recommendationTemplateArn;

    private final Boolean reverseOrder;

    private final List<String> status;

    private ListRecommendationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
        this.reverseOrder = builder.reverseOrder;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     *         about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     *         Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name for one of the listed recommendation templates.
     * </p>
     * 
     * @return The name for one of the listed recommendation templates.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Null, or the token from a previous call to get the next set of results.
     * </p>
     * 
     * @return Null, or the token from a previous call to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a recommendation template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a recommendation template.
     */
    public final String recommendationTemplateArn() {
        return recommendationTemplateArn;
    }

    /**
     * <p>
     * The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to
     * <code>true</code>.
     * </p>
     * 
     * @return The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
     *         reverseOrder to <code>true</code>.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the action.
     */
    public final List<RecommendationTemplateStatus> status() {
        return RecommendationTemplateStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the action.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationTemplatesRequest)) {
            return false;
        }
        ListRecommendationTemplatesRequest other = (ListRecommendationTemplatesRequest) obj;
        return Objects.equals(assessmentArn(), other.assessmentArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(name(), other.name()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(recommendationTemplateArn(), other.recommendationTemplateArn())
                && Objects.equals(reverseOrder(), other.reverseOrder()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationTemplatesRequest").add("AssessmentArn", assessmentArn())
                .add("MaxResults", maxResults()).add("Name", name()).add("NextToken", nextToken())
                .add("RecommendationTemplateArn", recommendationTemplateArn()).add("ReverseOrder", reverseOrder())
                .add("Status", hasStatus() ? statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "recommendationTemplateArn":
            return Optional.ofNullable(clazz.cast(recommendationTemplateArn()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationTemplatesRequest, T> g) {
        return obj -> g.apply((ListRecommendationTemplatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationTemplatesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about
         * ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param assessmentArn
         *        The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
         *        <code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/
         *        <code>app-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name for one of the listed recommendation templates.
         * </p>
         * 
         * @param name
         *        The name for one of the listed recommendation templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Null, or the token from a previous call to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Null, or the token from a previous call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a recommendation template.
         * </p>
         * 
         * @param recommendationTemplateArn
         *        The Amazon Resource Name (ARN) for a recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplateArn(String recommendationTemplateArn);

        /**
         * <p>
         * The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
         * reverseOrder to <code>true</code>.
         * </p>
         * 
         * @param reverseOrder
         *        The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
         *        reverseOrder to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<RecommendationTemplateStatus> status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(RecommendationTemplateStatus... status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String assessmentArn;

        private Integer maxResults;

        private String name;

        private String nextToken;

        private String recommendationTemplateArn;

        private Boolean reverseOrder;

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationTemplatesRequest model) {
            super(model);
            assessmentArn(model.assessmentArn);
            maxResults(model.maxResults);
            name(model.name);
            nextToken(model.nextToken);
            recommendationTemplateArn(model.recommendationTemplateArn);
            reverseOrder(model.reverseOrder);
            statusWithStrings(model.status);
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        @Transient
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRecommendationTemplateArn() {
            return recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        @Transient
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        @Transient
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = RecommendationTemplateStatusListCopier.copy(status);
        }

        @Override
        @Transient
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = RecommendationTemplateStatusListCopier.copy(status);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        @Transient
        public final Builder status(Collection<RecommendationTemplateStatus> status) {
            this.status = RecommendationTemplateStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder status(RecommendationTemplateStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationTemplatesRequest build() {
            return new ListRecommendationTemplatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
