/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the compliance of an application component against the resiliency policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppComponentCompliance implements SdkPojo, Serializable,
        ToCopyableBuilder<AppComponentCompliance.Builder, AppComponentCompliance> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(AppComponentCompliance::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField
            .<Map<String, DisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("compliance")
            .getter(getter(AppComponentCompliance::complianceAsStrings))
            .setter(setter(Builder::complianceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Cost> COST_FIELD = SdkField.<Cost> builder(MarshallingType.SDK_POJO).memberName("cost")
            .getter(getter(AppComponentCompliance::cost)).setter(setter(Builder::cost)).constructor(Cost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AppComponentCompliance::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<ResiliencyScore> RESILIENCY_SCORE_FIELD = SdkField
            .<ResiliencyScore> builder(MarshallingType.SDK_POJO).memberName("resiliencyScore")
            .getter(getter(AppComponentCompliance::resiliencyScore)).setter(setter(Builder::resiliencyScore))
            .constructor(ResiliencyScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AppComponentCompliance::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD,
            COMPLIANCE_FIELD, COST_FIELD, MESSAGE_FIELD, RESILIENCY_SCORE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentName;

    private final Map<String, DisruptionCompliance> compliance;

    private final Cost cost;

    private final String message;

    private final ResiliencyScore resiliencyScore;

    private final String status;

    private AppComponentCompliance(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.compliance = builder.compliance;
        this.cost = builder.cost;
        this.message = builder.message;
        this.resiliencyScore = builder.resiliencyScore;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the application component.
     * </p>
     * 
     * @return The name of the application component.
     */
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * <p>
     * The compliance of the application component against the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return The compliance of the application component against the resiliency policy.
     */
    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(compliance);
    }

    /**
     * For responses, this returns true if the service returned a value for the Compliance property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCompliance() {
        return compliance != null && !(compliance instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The compliance of the application component against the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return The compliance of the application component against the resiliency policy.
     */
    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return compliance;
    }

    /**
     * <p>
     * The cost for the application.
     * </p>
     * 
     * @return The cost for the application.
     */
    public final Cost cost() {
        return cost;
    }

    /**
     * <p>
     * The compliance message.
     * </p>
     * 
     * @return The compliance message.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The current resiliency score for the application.
     * </p>
     * 
     * @return The current resiliency score for the application.
     */
    public final ResiliencyScore resiliencyScore() {
        return resiliencyScore;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ComplianceStatus
     */
    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ComplianceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompliance() ? complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppComponentCompliance)) {
            return false;
        }
        AppComponentCompliance other = (AppComponentCompliance) obj;
        return Objects.equals(appComponentName(), other.appComponentName()) && hasCompliance() == other.hasCompliance()
                && Objects.equals(complianceAsStrings(), other.complianceAsStrings()) && Objects.equals(cost(), other.cost())
                && Objects.equals(message(), other.message()) && Objects.equals(resiliencyScore(), other.resiliencyScore())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppComponentCompliance").add("AppComponentName", appComponentName())
                .add("Compliance", hasCompliance() ? complianceAsStrings() : null).add("Cost", cost()).add("Message", message())
                .add("ResiliencyScore", resiliencyScore()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "compliance":
            return Optional.ofNullable(clazz.cast(complianceAsStrings()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "resiliencyScore":
            return Optional.ofNullable(clazz.cast(resiliencyScore()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppComponentCompliance, T> g) {
        return obj -> g.apply((AppComponentCompliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppComponentCompliance> {
        /**
         * <p>
         * The name of the application component.
         * </p>
         * 
         * @param appComponentName
         *        The name of the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * The compliance of the application component against the resiliency policy.
         * </p>
         * 
         * @param compliance
         *        The compliance of the application component against the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance);

        /**
         * <p>
         * The compliance of the application component against the resiliency policy.
         * </p>
         * 
         * @param compliance
         *        The compliance of the application component against the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * 
         * @param cost
         *        The cost for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Cost cost);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cost.Builder} avoiding the need to create
         * one manually via {@link Cost#builder()}.
         *
         * When the {@link Consumer} completes, {@link Cost.Builder#build()} is called immediately and its result is
         * passed to {@link #cost(Cost)}.
         * 
         * @param cost
         *        a consumer that will call methods on {@link Cost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cost(Cost)
         */
        default Builder cost(Consumer<Cost.Builder> cost) {
            return cost(Cost.builder().applyMutation(cost).build());
        }

        /**
         * <p>
         * The compliance message.
         * </p>
         * 
         * @param message
         *        The compliance message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The current resiliency score for the application.
         * </p>
         * 
         * @param resiliencyScore
         *        The current resiliency score for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyScore(ResiliencyScore resiliencyScore);

        /**
         * <p>
         * The current resiliency score for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResiliencyScore.Builder} avoiding the
         * need to create one manually via {@link ResiliencyScore#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResiliencyScore.Builder#build()} is called immediately and its
         * result is passed to {@link #resiliencyScore(ResiliencyScore)}.
         * 
         * @param resiliencyScore
         *        a consumer that will call methods on {@link ResiliencyScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resiliencyScore(ResiliencyScore)
         */
        default Builder resiliencyScore(Consumer<ResiliencyScore.Builder> resiliencyScore) {
            return resiliencyScore(ResiliencyScore.builder().applyMutation(resiliencyScore).build());
        }

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(ComplianceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentName;

        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();

        private Cost cost;

        private String message;

        private ResiliencyScore resiliencyScore;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AppComponentCompliance model) {
            appComponentName(model.appComponentName);
            complianceWithStrings(model.compliance);
            cost(model.cost);
            message(model.message);
            resiliencyScore(model.resiliencyScore);
            status(model.status);
        }

        public final String getAppComponentName() {
            return appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final Cost.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final ResiliencyScore.Builder getResiliencyScore() {
            return resiliencyScore != null ? resiliencyScore.toBuilder() : null;
        }

        public final void setResiliencyScore(ResiliencyScore.BuilderImpl resiliencyScore) {
            this.resiliencyScore = resiliencyScore != null ? resiliencyScore.build() : null;
        }

        @Override
        public final Builder resiliencyScore(ResiliencyScore resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AppComponentCompliance build() {
            return new AppComponentCompliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
