/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppVersionResourcesResolutionStatusResponse extends ResiliencehubResponse
        implements
        ToCopyableBuilder<DescribeAppVersionResourcesResolutionStatusResponse.Builder, DescribeAppVersionResourcesResolutionStatusResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(DescribeAppVersionResourcesResolutionStatusResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(DescribeAppVersionResourcesResolutionStatusResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(DescribeAppVersionResourcesResolutionStatusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionId").getter(getter(DescribeAppVersionResourcesResolutionStatusResponse::resolutionId))
            .setter(setter(Builder::resolutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeAppVersionResourcesResolutionStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, ERROR_MESSAGE_FIELD, RESOLUTION_ID_FIELD, STATUS_FIELD));

    private final String appArn;

    private final String appVersion;

    private final String errorMessage;

    private final String resolutionId;

    private final String status;

    private DescribeAppVersionResourcesResolutionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.errorMessage = builder.errorMessage;
        this.resolutionId = builder.resolutionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:
     * <code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
     *         Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The returned error message for the request.
     * </p>
     * 
     * @return The returned error message for the request.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The identifier for a specific resolution.
     * </p>
     * 
     * @return The identifier for a specific resolution.
     */
    public final String resolutionId() {
        return resolutionId;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceResolutionStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ResourceResolutionStatusType
     */
    public final ResourceResolutionStatusType status() {
        return ResourceResolutionStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceResolutionStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ResourceResolutionStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppVersionResourcesResolutionStatusResponse)) {
            return false;
        }
        DescribeAppVersionResourcesResolutionStatusResponse other = (DescribeAppVersionResourcesResolutionStatusResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(resolutionId(), other.resolutionId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppVersionResourcesResolutionStatusResponse").add("AppArn", appArn())
                .add("AppVersion", appVersion()).add("ErrorMessage", errorMessage()).add("ResolutionId", resolutionId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "resolutionId":
            return Optional.ofNullable(clazz.cast(resolutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppVersionResourcesResolutionStatusResponse, T> g) {
        return obj -> g.apply((DescribeAppVersionResourcesResolutionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppVersionResourcesResolutionStatusResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
         * :dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:
         *        <code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
         *        information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * The returned error message for the request.
         * </p>
         * 
         * @param errorMessage
         *        The returned error message for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The identifier for a specific resolution.
         * </p>
         * 
         * @param resolutionId
         *        The identifier for a specific resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionId(String resolutionId);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ResourceResolutionStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceResolutionStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ResourceResolutionStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceResolutionStatusType
         */
        Builder status(ResourceResolutionStatusType status);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private String errorMessage;

        private String resolutionId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppVersionResourcesResolutionStatusResponse model) {
            super(model);
            appArn(model.appArn);
            appVersion(model.appVersion);
            errorMessage(model.errorMessage);
            resolutionId(model.resolutionId);
            status(model.status);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getResolutionId() {
            return resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceResolutionStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeAppVersionResourcesResolutionStatusResponse build() {
            return new DescribeAppVersionResourcesResolutionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
