/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResourceId;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMappingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceMapping> {
    private static final SdkField<String> APP_REGISTRY_APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appRegistryAppName").getter(ResourceMapping.getter(ResourceMapping::appRegistryAppName)).setter(ResourceMapping.setter(Builder::appRegistryAppName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appRegistryAppName").build()}).build();
    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logicalStackName").getter(ResourceMapping.getter(ResourceMapping::logicalStackName)).setter(ResourceMapping.setter(Builder::logicalStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()}).build();
    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingType").getter(ResourceMapping.getter(ResourceMapping::mappingTypeAsString)).setter(ResourceMapping.setter(Builder::mappingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()}).build();
    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalResourceId").getter(ResourceMapping.getter(ResourceMapping::physicalResourceId)).setter(ResourceMapping.setter(Builder::physicalResourceId)).constructor(PhysicalResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGroupName").getter(ResourceMapping.getter(ResourceMapping::resourceGroupName)).setter(ResourceMapping.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(ResourceMapping.getter(ResourceMapping::resourceName)).setter(ResourceMapping.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_REGISTRY_APP_NAME_FIELD, LOGICAL_STACK_NAME_FIELD, MAPPING_TYPE_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_GROUP_NAME_FIELD, RESOURCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appRegistryAppName;
    private final String logicalStackName;
    private final String mappingType;
    private final PhysicalResourceId physicalResourceId;
    private final String resourceGroupName;
    private final String resourceName;

    private ResourceMapping(BuilderImpl builder) {
        this.appRegistryAppName = builder.appRegistryAppName;
        this.logicalStackName = builder.logicalStackName;
        this.mappingType = builder.mappingType;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceGroupName = builder.resourceGroupName;
        this.resourceName = builder.resourceName;
    }

    public final String appRegistryAppName() {
        return this.appRegistryAppName;
    }

    public final String logicalStackName() {
        return this.logicalStackName;
    }

    public final ResourceMappingType mappingType() {
        return ResourceMappingType.fromValue(this.mappingType);
    }

    public final String mappingTypeAsString() {
        return this.mappingType;
    }

    public final PhysicalResourceId physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appRegistryAppName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMapping)) {
            return false;
        }
        ResourceMapping other = (ResourceMapping)obj;
        return Objects.equals(this.appRegistryAppName(), other.appRegistryAppName()) && Objects.equals(this.logicalStackName(), other.logicalStackName()) && Objects.equals(this.mappingTypeAsString(), other.mappingTypeAsString()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.resourceName(), other.resourceName());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceMapping").add("AppRegistryAppName", (Object)this.appRegistryAppName()).add("LogicalStackName", (Object)this.logicalStackName()).add("MappingType", (Object)this.mappingTypeAsString()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("ResourceName", (Object)this.resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appRegistryAppName": {
                return Optional.ofNullable(clazz.cast(this.appRegistryAppName()));
            }
            case "logicalStackName": {
                return Optional.ofNullable(clazz.cast(this.logicalStackName()));
            }
            case "mappingType": {
                return Optional.ofNullable(clazz.cast(this.mappingTypeAsString()));
            }
            case "physicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "resourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceMapping, T> g) {
        return obj -> g.apply((ResourceMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appRegistryAppName;
        private String logicalStackName;
        private String mappingType;
        private PhysicalResourceId physicalResourceId;
        private String resourceGroupName;
        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMapping model) {
            this.appRegistryAppName(model.appRegistryAppName);
            this.logicalStackName(model.logicalStackName);
            this.mappingType(model.mappingType);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceGroupName(model.resourceGroupName);
            this.resourceName(model.resourceName);
        }

        public final String getAppRegistryAppName() {
            return this.appRegistryAppName;
        }

        public final void setAppRegistryAppName(String appRegistryAppName) {
            this.appRegistryAppName = appRegistryAppName;
        }

        @Override
        public final Builder appRegistryAppName(String appRegistryAppName) {
            this.appRegistryAppName = appRegistryAppName;
            return this;
        }

        public final String getLogicalStackName() {
            return this.logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getMappingType() {
            return this.mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(ResourceMappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return this.physicalResourceId != null ? this.physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public ResourceMapping build() {
            return new ResourceMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceMapping> {
        public Builder appRegistryAppName(String var1);

        public Builder logicalStackName(String var1);

        public Builder mappingType(String var1);

        public Builder mappingType(ResourceMappingType var1);

        public Builder physicalResourceId(PhysicalResourceId var1);

        default public Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return this.physicalResourceId((PhysicalResourceId)((PhysicalResourceId.Builder)PhysicalResourceId.builder().applyMutation(physicalResourceId)).build());
        }

        public Builder resourceGroupName(String var1);

        public Builder resourceName(String var1);
    }
}

