/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.resiliencehub.model.AccessDeniedException;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ConflictException;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.InternalServerException;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubException;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resiliencehub.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ThrottlingException;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ValidationException;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable;
import software.amazon.awssdk.services.resiliencehub.transform.AddDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.CreateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteRecommendationTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DeleteResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionResourcesResolutionStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeDraftAppVersionResourcesImportStatusRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.DescribeResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ImportResourcesToDraftAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAlarmRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentCompliancesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppComponentRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppVersionsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListRecommendationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSopRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListSuggestedResiliencyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListTestRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ListUnsupportedAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PublishAppVersionRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.PutDraftAppVersionTemplateRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.RemoveDraftAppVersionResourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.ResolveAppVersionResourcesRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.StartAppAssessmentRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.resiliencehub.transform.UpdateResiliencyPolicyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ResiliencehubClient}.
 *
 * @see ResiliencehubClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultResiliencehubClient implements ResiliencehubClient {
    private static final Logger log = Logger.loggerFor(DefaultResiliencehubClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResiliencehubClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds the resource mapping for the draft application version.
     * </p>
     *
     * @param addDraftAppVersionResourceMappingsRequest
     * @return Result of the AddDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.AddDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddDraftAppVersionResourceMappingsResponse addDraftAppVersionResourceMappings(
            AddDraftAppVersionResourceMappingsRequest addDraftAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddDraftAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddDraftAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<AddDraftAppVersionResourceMappingsRequest, AddDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("AddDraftAppVersionResourceMappings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addDraftAppVersionResourceMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services
     * resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience
     * Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks,
     * and an appropriate resiliency policy.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).&lt;/p&gt; </code>
     * </pre>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");

            return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                    .withOperationName("CreateApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new recommendation template.
     * </p>
     *
     * @param createRecommendationTemplateRequest
     * @return Result of the CreateRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRecommendationTemplateResponse createRecommendationTemplate(
            CreateRecommendationTemplateRequest createRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRecommendationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommendationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRecommendationTemplateRequest, CreateRecommendationTemplateResponse>()
                            .withOperationName("CreateRecommendationTemplate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createRecommendationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRecommendationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a resiliency policy for an application.
     * </p>
     *
     * @param createResiliencyPolicyRequest
     * @return Result of the CreateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResiliencyPolicyResponse createResiliencyPolicy(CreateResiliencyPolicyRequest createResiliencyPolicyRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResiliencyPolicyRequest, CreateResiliencyPolicyResponse>()
                            .withOperationName("CreateResiliencyPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                    .withOperationName("DeleteApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppAssessmentRequest
     * @return Result of the DeleteAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAppAssessmentResponse deleteAppAssessment(DeleteAppAssessmentRequest deleteAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<DeleteAppAssessmentRequest, DeleteAppAssessmentResponse>()
                    .withOperationName("DeleteAppAssessment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteRecommendationTemplateRequest
     * @return Result of the DeleteRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRecommendationTemplateResponse deleteRecommendationTemplate(
            DeleteRecommendationTemplateRequest deleteRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRecommendationTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRecommendationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecommendationTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommendationTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommendationTemplateRequest, DeleteRecommendationTemplateResponse>()
                            .withOperationName("DeleteRecommendationTemplate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRecommendationTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRecommendationTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteResiliencyPolicyRequest
     * @return Result of the DeleteResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResiliencyPolicyResponse deleteResiliencyPolicy(DeleteResiliencyPolicyRequest deleteResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResiliencyPolicyRequest, DeleteResiliencyPolicyResponse>()
                            .withOperationName("DeleteResiliencyPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an AWS Resilience Hub application.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApp");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppRequest, DescribeAppResponse>()
                    .withOperationName("DescribeApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAppRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an assessment for an AWS Resilience Hub application.
     * </p>
     *
     * @param describeAppAssessmentRequest
     * @return Result of the DescribeAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppAssessmentResponse describeAppAssessment(DescribeAppAssessmentRequest describeAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<DescribeAppAssessmentRequest, DescribeAppAssessmentResponse>()
                    .withOperationName("DescribeAppAssessment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the resolution status for the specified resolution identifier for an application version. If
     * <code>resolutionId</code> is not specified, the current resolution status is returned.
     * </p>
     *
     * @param describeAppVersionResourcesResolutionStatusRequest
     * @return Result of the DescribeAppVersionResourcesResolutionStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionResourcesResolutionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionResourcesResolutionStatusResponse describeAppVersionResourcesResolutionStatus(
            DescribeAppVersionResourcesResolutionStatusRequest describeAppVersionResourcesResolutionStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionResourcesResolutionStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeAppVersionResourcesResolutionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAppVersionResourcesResolutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionResourcesResolutionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionResourcesResolutionStatusRequest, DescribeAppVersionResourcesResolutionStatusResponse>()
                            .withOperationName("DescribeAppVersionResourcesResolutionStatus")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAppVersionResourcesResolutionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionResourcesResolutionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes details about an AWS Resilience Hub
     * </p>
     *
     * @param describeAppVersionTemplateRequest
     * @return Result of the DescribeAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAppVersionTemplateResponse describeAppVersionTemplate(
            DescribeAppVersionTemplateRequest describeAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAppVersionTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAppVersionTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAppVersionTemplateRequest, DescribeAppVersionTemplateResponse>()
                            .withOperationName("DescribeAppVersionTemplate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAppVersionTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAppVersionTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of importing resources to an application version.
     * </p>
     *
     * @param describeDraftAppVersionResourcesImportStatusRequest
     * @return Result of the DescribeDraftAppVersionResourcesImportStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeDraftAppVersionResourcesImportStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDraftAppVersionResourcesImportStatusResponse describeDraftAppVersionResourcesImportStatus(
            DescribeDraftAppVersionResourcesImportStatusRequest describeDraftAppVersionResourcesImportStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDraftAppVersionResourcesImportStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDraftAppVersionResourcesImportStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDraftAppVersionResourcesImportStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDraftAppVersionResourcesImportStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDraftAppVersionResourcesImportStatusRequest, DescribeDraftAppVersionResourcesImportStatusResponse>()
                            .withOperationName("DescribeDraftAppVersionResourcesImportStatus")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDraftAppVersionResourcesImportStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDraftAppVersionResourcesImportStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object
     * includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and
     * more.
     * </p>
     *
     * @param describeResiliencyPolicyRequest
     * @return Result of the DescribeResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResiliencyPolicyResponse describeResiliencyPolicy(
            DescribeResiliencyPolicyRequest describeResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResiliencyPolicyRequest, DescribeResiliencyPolicyResponse>()
                            .withOperationName("DescribeResiliencyPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a
     * draft application version.
     * </p>
     *
     * @param importResourcesToDraftAppVersionRequest
     * @return Result of the ImportResourcesToDraftAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ImportResourcesToDraftAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportResourcesToDraftAppVersionResponse importResourcesToDraftAppVersion(
            ImportResourcesToDraftAppVersionRequest importResourcesToDraftAppVersionRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportResourcesToDraftAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportResourcesToDraftAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                importResourcesToDraftAppVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportResourcesToDraftAppVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportResourcesToDraftAppVersionRequest, ImportResourcesToDraftAppVersionResponse>()
                            .withOperationName("ImportResourcesToDraftAppVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(importResourcesToDraftAppVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportResourcesToDraftAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return Result of the ListAlarmRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAlarmRecommendationsResponse listAlarmRecommendations(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAlarmRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAlarmRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAlarmRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAlarmRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAlarmRecommendationsRequest, ListAlarmRecommendationsResponse>()
                            .withOperationName("ListAlarmRecommendations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAlarmRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAlarmRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client
     *             .listAlarmRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAlarmRecommendationsIterable listAlarmRecommendationsPaginator(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListAlarmRecommendationsIterable(this, applyPaginatorUserAgent(listAlarmRecommendationsRequest));
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return Result of the ListAppAssessments operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppAssessmentsResponse listAppAssessments(ListAppAssessmentsRequest listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppAssessmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppAssessments");

            return clientHandler.execute(new ClientExecutionParams<ListAppAssessmentsRequest, ListAppAssessmentsResponse>()
                    .withOperationName("ListAppAssessments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAppAssessmentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppAssessmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client
     *             .listAppAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppAssessmentsIterable listAppAssessmentsPaginator(ListAppAssessmentsRequest listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListAppAssessmentsIterable(this, applyPaginatorUserAgent(listAppAssessmentsRequest));
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return Result of the ListAppComponentCompliances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentCompliancesResponse listAppComponentCompliances(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppComponentCompliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppComponentCompliancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppComponentCompliancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentCompliances");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentCompliancesRequest, ListAppComponentCompliancesResponse>()
                            .withOperationName("ListAppComponentCompliances").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAppComponentCompliancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppComponentCompliancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client
     *             .listAppComponentCompliancesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentCompliancesIterable listAppComponentCompliancesPaginator(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListAppComponentCompliancesIterable(this, applyPaginatorUserAgent(listAppComponentCompliancesRequest));
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return Result of the ListAppComponentRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentRecommendationsResponse listAppComponentRecommendations(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppComponentRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppComponentRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppComponentRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppComponentRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppComponentRecommendationsRequest, ListAppComponentRecommendationsResponse>()
                            .withOperationName("ListAppComponentRecommendations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAppComponentRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppComponentRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client
     *             .listAppComponentRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppComponentRecommendationsIterable listAppComponentRecommendationsPaginator(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListAppComponentRecommendationsIterable(this, applyPaginatorUserAgent(listAppComponentRecommendationsRequest));
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return Result of the ListAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourceMappingsResponse listAppVersionResourceMappings(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionResourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourceMappingsRequest, ListAppVersionResourceMappingsResponse>()
                            .withOperationName("ListAppVersionResourceMappings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAppVersionResourceMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client
     *             .listAppVersionResourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourceMappingsIterable listAppVersionResourceMappingsPaginator(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListAppVersionResourceMappingsIterable(this, applyPaginatorUserAgent(listAppVersionResourceMappingsRequest));
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return Result of the ListAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourcesResponse listAppVersionResources(ListAppVersionResourcesRequest listAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAppVersionResourcesRequest, ListAppVersionResourcesResponse>()
                            .withOperationName("ListAppVersionResources").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client
     *             .listAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAppVersionResourcesIterable listAppVersionResourcesPaginator(
            ListAppVersionResourcesRequest listAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListAppVersionResourcesIterable(this, applyPaginatorUserAgent(listAppVersionResourcesRequest));
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     *
     * @param listAppVersionsRequest
     * @return Result of the ListAppVersions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAppVersionsResponse listAppVersions(ListAppVersionsRequest listAppVersionsRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAppVersions");

            return clientHandler.execute(new ClientExecutionParams<ListAppVersionsRequest, ListAppVersionsResponse>()
                    .withOperationName("ListAppVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAppVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAppVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client
     *             .listAppVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAppVersionsIterable listAppVersionsPaginator(ListAppVersionsRequest listAppVersionsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListAppVersionsIterable(this, applyPaginatorUserAgent(listAppVersionsRequest));
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApps");

            return clientHandler.execute(new ClientExecutionParams<ListAppsRequest, ListAppsResponse>()
                    .withOperationName("ListApps").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAppsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAppsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAppsIterable listAppsPaginator(ListAppsRequest listAppsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        return new ListAppsIterable(this, applyPaginatorUserAgent(listAppsRequest));
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return Result of the ListRecommendationTemplates operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecommendationTemplatesResponse listRecommendationTemplates(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecommendationTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecommendationTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendationTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendationTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecommendationTemplatesRequest, ListRecommendationTemplatesResponse>()
                            .withOperationName("ListRecommendationTemplates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listRecommendationTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecommendationTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client
     *             .listRecommendationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecommendationTemplatesIterable listRecommendationTemplatesPaginator(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        return new ListRecommendationTemplatesIterable(this, applyPaginatorUserAgent(listRecommendationTemplatesRequest));
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return Result of the ListResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResiliencyPoliciesResponse listResiliencyPolicies(ListResiliencyPoliciesRequest listResiliencyPoliciesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResiliencyPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResiliencyPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResiliencyPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResiliencyPoliciesRequest, ListResiliencyPoliciesResponse>()
                            .withOperationName("ListResiliencyPolicies").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listResiliencyPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResiliencyPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client
     *             .listResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResiliencyPoliciesIterable listResiliencyPoliciesPaginator(
            ListResiliencyPoliciesRequest listResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListResiliencyPoliciesIterable(this, applyPaginatorUserAgent(listResiliencyPoliciesRequest));
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return Result of the ListSopRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSopRecommendationsResponse listSopRecommendations(ListSopRecommendationsRequest listSopRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSopRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSopRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSopRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSopRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSopRecommendationsRequest, ListSopRecommendationsResponse>()
                            .withOperationName("ListSopRecommendations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listSopRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSopRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client
     *             .listSopRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSopRecommendationsIterable listSopRecommendationsPaginator(
            ListSopRecommendationsRequest listSopRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListSopRecommendationsIterable(this, applyPaginatorUserAgent(listSopRecommendationsRequest));
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return Result of the ListSuggestedResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSuggestedResiliencyPoliciesResponse listSuggestedResiliencyPolicies(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSuggestedResiliencyPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSuggestedResiliencyPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSuggestedResiliencyPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSuggestedResiliencyPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSuggestedResiliencyPoliciesRequest, ListSuggestedResiliencyPoliciesResponse>()
                            .withOperationName("ListSuggestedResiliencyPolicies").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listSuggestedResiliencyPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSuggestedResiliencyPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client
     *             .listSuggestedResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSuggestedResiliencyPoliciesIterable listSuggestedResiliencyPoliciesPaginator(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return new ListSuggestedResiliencyPoliciesIterable(this, applyPaginatorUserAgent(listSuggestedResiliencyPoliciesRequest));
    }

    /**
     * <p>
     * Lists the tags for your resources in your Resilience Hub applications.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return Result of the ListTestRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestRecommendationsResponse listTestRecommendations(ListTestRecommendationsRequest listTestRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestRecommendationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTestRecommendationsRequest, ListTestRecommendationsResponse>()
                            .withOperationName("ListTestRecommendations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTestRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTestRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client
     *             .listTestRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestRecommendationsIterable listTestRecommendationsPaginator(
            ListTestRecommendationsRequest listTestRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListTestRecommendationsIterable(this, applyPaginatorUserAgent(listTestRecommendationsRequest));
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return Result of the ListUnsupportedAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUnsupportedAppVersionResourcesResponse listUnsupportedAppVersionResources(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUnsupportedAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUnsupportedAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listUnsupportedAppVersionResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUnsupportedAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListUnsupportedAppVersionResourcesRequest, ListUnsupportedAppVersionResourcesResponse>()
                            .withOperationName("ListUnsupportedAppVersionResources").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listUnsupportedAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListUnsupportedAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client
     *             .listUnsupportedAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUnsupportedAppVersionResourcesIterable listUnsupportedAppVersionResourcesPaginator(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return new ListUnsupportedAppVersionResourcesIterable(this,
                applyPaginatorUserAgent(listUnsupportedAppVersionResourcesRequest));
    }

    /**
     * <p>
     * Publishes a new version of a specific Resilience Hub application.
     * </p>
     *
     * @param publishAppVersionRequest
     * @return Result of the PublishAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PublishAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PublishAppVersionResponse publishAppVersion(PublishAppVersionRequest publishAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishAppVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PublishAppVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishAppVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishAppVersion");

            return clientHandler.execute(new ClientExecutionParams<PublishAppVersionRequest, PublishAppVersionResponse>()
                    .withOperationName("PublishAppVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(publishAppVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PublishAppVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates the app template for a draft version of a Resilience Hub app.
     * </p>
     *
     * @param putDraftAppVersionTemplateRequest
     * @return Result of the PutDraftAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PutDraftAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDraftAppVersionTemplateResponse putDraftAppVersionTemplate(
            PutDraftAppVersionTemplateRequest putDraftAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDraftAppVersionTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDraftAppVersionTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDraftAppVersionTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDraftAppVersionTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDraftAppVersionTemplateRequest, PutDraftAppVersionTemplateResponse>()
                            .withOperationName("PutDraftAppVersionTemplate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putDraftAppVersionTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDraftAppVersionTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes resource mappings from a draft application version.
     * </p>
     *
     * @param removeDraftAppVersionResourceMappingsRequest
     * @return Result of the RemoveDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.RemoveDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveDraftAppVersionResourceMappingsResponse removeDraftAppVersionResourceMappings(
            RemoveDraftAppVersionResourceMappingsRequest removeDraftAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveDraftAppVersionResourceMappingsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, RemoveDraftAppVersionResourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeDraftAppVersionResourceMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveDraftAppVersionResourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveDraftAppVersionResourceMappingsRequest, RemoveDraftAppVersionResourceMappingsResponse>()
                            .withOperationName("RemoveDraftAppVersionResourceMappings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeDraftAppVersionResourceMappingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveDraftAppVersionResourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resolves the resources for an application version.
     * </p>
     *
     * @param resolveAppVersionResourcesRequest
     * @return Result of the ResolveAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ResolveAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResolveAppVersionResourcesResponse resolveAppVersionResources(
            ResolveAppVersionResourcesRequest resolveAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResolveAppVersionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResolveAppVersionResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resolveAppVersionResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResolveAppVersionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ResolveAppVersionResourcesRequest, ResolveAppVersionResourcesResponse>()
                            .withOperationName("ResolveAppVersionResources").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(resolveAppVersionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResolveAppVersionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new application assessment for an application.
     * </p>
     *
     * @param startAppAssessmentRequest
     * @return Result of the StartAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.StartAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAppAssessmentResponse startAppAssessment(StartAppAssessmentRequest startAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAppAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAppAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAppAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAppAssessment");

            return clientHandler.execute(new ClientExecutionParams<StartAppAssessmentRequest, StartAppAssessmentResponse>()
                    .withOperationName("StartAppAssessment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startAppAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartAppAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateAppRequest
     * @return Result of the UpdateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApp");

            return clientHandler.execute(new ClientExecutionParams<UpdateAppRequest, UpdateAppResponse>()
                    .withOperationName("UpdateApp").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAppRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateAppRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a resiliency policy.
     * </p>
     *
     * @param updateResiliencyPolicyRequest
     * @return Result of the UpdateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResiliencyPolicyResponse updateResiliencyPolicy(UpdateResiliencyPolicyRequest updateResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResiliencyPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResiliencyPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResiliencyPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "resiliencehub");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResiliencyPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateResiliencyPolicyRequest, UpdateResiliencyPolicyResponse>()
                            .withOperationName("UpdateResiliencyPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateResiliencyPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateResiliencyPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ResiliencehubException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends ResiliencehubRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
