/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.resiliencehub.model.AccessDeniedException;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ConflictException;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.CreateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteRecommendationTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DeleteResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.DescribeResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.InternalServerException;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionRequest;
import software.amazon.awssdk.services.resiliencehub.model.PublishAppVersionResponse;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateRequest;
import software.amazon.awssdk.services.resiliencehub.model.PutDraftAppVersionTemplateResponse;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest;
import software.amazon.awssdk.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubException;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResolveAppVersionResourcesResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resiliencehub.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentRequest;
import software.amazon.awssdk.services.resiliencehub.model.StartAppAssessmentResponse;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.TagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.ThrottlingException;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceRequest;
import software.amazon.awssdk.services.resiliencehub.model.UntagResourceResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateAppResponse;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyRequest;
import software.amazon.awssdk.services.resiliencehub.model.UpdateResiliencyPolicyResponse;
import software.amazon.awssdk.services.resiliencehub.model.ValidationException;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable;
import software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable;

/**
 * Service client for accessing AWS Resilience Hub. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Resilience Hub helps you proactively prepare and protect your Amazon Web Services applications from disruptions.
 * Resilience Hub offers continuous resiliency assessment and validation that integrates into your software development
 * lifecycle. This enables you to uncover resiliency weaknesses, ensure recovery time objective (RTO) and recovery point
 * objective (RPO) targets for your applications are met, and resolve issues before they are released into production.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ResiliencehubClient extends SdkClient {
    String SERVICE_NAME = "resiliencehub";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "resiliencehub";

    /**
     * Create a {@link ResiliencehubClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ResiliencehubClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ResiliencehubClient}.
     */
    static ResiliencehubClientBuilder builder() {
        return new DefaultResiliencehubClientBuilder();
    }

    /**
     * <p>
     * Adds the resource mapping for the draft application version.
     * </p>
     *
     * @param addDraftAppVersionResourceMappingsRequest
     * @return Result of the AddDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.AddDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default AddDraftAppVersionResourceMappingsResponse addDraftAppVersionResourceMappings(
            AddDraftAppVersionResourceMappingsRequest addDraftAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the resource mapping for the draft application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddDraftAppVersionResourceMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link AddDraftAppVersionResourceMappingsRequest#builder()}
     * </p>
     *
     * @param addDraftAppVersionResourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link AddDraftAppVersionResourceMappingsRequest.Builder} to
     *        create a request.
     * @return Result of the AddDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.AddDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AddDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default AddDraftAppVersionResourceMappingsResponse addDraftAppVersionResourceMappings(
            Consumer<AddDraftAppVersionResourceMappingsRequest.Builder> addDraftAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return addDraftAppVersionResourceMappings(AddDraftAppVersionResourceMappingsRequest.builder()
                .applyMutation(addDraftAppVersionResourceMappingsRequest).build());
    }

    /**
     * <p>
     * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services
     * resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience
     * Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks,
     * and an appropriate resiliency policy.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).&lt;/p&gt; </code>
     * </pre>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(CreateAppRequest createAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services
     * resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience
     * Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks,
     * and an appropriate resiliency policy.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt;After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).&lt;/p&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppRequest.Builder} to create a request.
     * @return Result of the CreateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppResponse createApp(Consumer<CreateAppRequest.Builder> createAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a new recommendation template.
     * </p>
     *
     * @param createRecommendationTemplateRequest
     * @return Result of the CreateRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRecommendationTemplateResponse createRecommendationTemplate(
            CreateRecommendationTemplateRequest createRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new recommendation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecommendationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRecommendationTemplateRequest#builder()}
     * </p>
     *
     * @param createRecommendationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecommendationTemplateRequest.Builder} to create
     *        a request.
     * @return Result of the CreateRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRecommendationTemplateResponse createRecommendationTemplate(
            Consumer<CreateRecommendationTemplateRequest.Builder> createRecommendationTemplateRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return createRecommendationTemplate(CreateRecommendationTemplateRequest.builder()
                .applyMutation(createRecommendationTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a resiliency policy for an application.
     * </p>
     *
     * @param createResiliencyPolicyRequest
     * @return Result of the CreateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResiliencyPolicyResponse createResiliencyPolicy(CreateResiliencyPolicyRequest createResiliencyPolicyRequest)
            throws InternalServerException, ConflictException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resiliency policy for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResiliencyPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResiliencyPolicyRequest#builder()}
     * </p>
     *
     * @param createResiliencyPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateResiliencyPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.CreateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/CreateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResiliencyPolicyResponse createResiliencyPolicy(
            Consumer<CreateResiliencyPolicyRequest.Builder> createResiliencyPolicyRequest) throws InternalServerException,
            ConflictException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return createResiliencyPolicy(CreateResiliencyPolicyRequest.builder().applyMutation(createResiliencyPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppRequest.Builder} to create a request.
     * @return Result of the DeleteApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppResponse deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteAppAssessmentRequest
     * @return Result of the DeleteAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppAssessmentResponse deleteAppAssessment(DeleteAppAssessmentRequest deleteAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppAssessmentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppAssessmentRequest#builder()}
     * </p>
     *
     * @param deleteAppAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppAssessmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppAssessmentResponse deleteAppAssessment(
            Consumer<DeleteAppAssessmentRequest.Builder> deleteAppAssessmentRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return deleteAppAssessment(DeleteAppAssessmentRequest.builder().applyMutation(deleteAppAssessmentRequest).build());
    }

    /**
     * <p>
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteRecommendationTemplateRequest
     * @return Result of the DeleteRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRecommendationTemplateResponse deleteRecommendationTemplate(
            DeleteRecommendationTemplateRequest deleteRecommendationTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecommendationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRecommendationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteRecommendationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecommendationTemplateRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteRecommendationTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteRecommendationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteRecommendationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRecommendationTemplateResponse deleteRecommendationTemplate(
            Consumer<DeleteRecommendationTemplateRequest.Builder> deleteRecommendationTemplateRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return deleteRecommendationTemplate(DeleteRecommendationTemplateRequest.builder()
                .applyMutation(deleteRecommendationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     * </p>
     *
     * @param deleteResiliencyPolicyRequest
     * @return Result of the DeleteResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResiliencyPolicyResponse deleteResiliencyPolicy(DeleteResiliencyPolicyRequest deleteResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResiliencyPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResiliencyPolicyRequest#builder()}
     * </p>
     *
     * @param deleteResiliencyPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResiliencyPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DeleteResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DeleteResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResiliencyPolicyResponse deleteResiliencyPolicy(
            Consumer<DeleteResiliencyPolicyRequest.Builder> deleteResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return deleteResiliencyPolicy(DeleteResiliencyPolicyRequest.builder().applyMutation(deleteResiliencyPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Describes an AWS Resilience Hub application.
     * </p>
     *
     * @param describeAppRequest
     * @return Result of the DescribeApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAppResponse describeApp(DescribeAppRequest describeAppRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAppRequest#builder()}
     * </p>
     *
     * @param describeAppRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppRequest.Builder} to create a request.
     * @return Result of the DescribeApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAppResponse describeApp(Consumer<DescribeAppRequest.Builder> describeAppRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return describeApp(DescribeAppRequest.builder().applyMutation(describeAppRequest).build());
    }

    /**
     * <p>
     * Describes an assessment for an AWS Resilience Hub application.
     * </p>
     *
     * @param describeAppAssessmentRequest
     * @return Result of the DescribeAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppAssessmentResponse describeAppAssessment(DescribeAppAssessmentRequest describeAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an assessment for an AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppAssessmentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAppAssessmentRequest#builder()}
     * </p>
     *
     * @param describeAppAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppAssessmentRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppAssessmentResponse describeAppAssessment(
            Consumer<DescribeAppAssessmentRequest.Builder> describeAppAssessmentRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return describeAppAssessment(DescribeAppAssessmentRequest.builder().applyMutation(describeAppAssessmentRequest).build());
    }

    /**
     * <p>
     * Returns the resolution status for the specified resolution identifier for an application version. If
     * <code>resolutionId</code> is not specified, the current resolution status is returned.
     * </p>
     *
     * @param describeAppVersionResourcesResolutionStatusRequest
     * @return Result of the DescribeAppVersionResourcesResolutionStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionResourcesResolutionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppVersionResourcesResolutionStatusResponse describeAppVersionResourcesResolutionStatus(
            DescribeAppVersionResourcesResolutionStatusRequest describeAppVersionResourcesResolutionStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resolution status for the specified resolution identifier for an application version. If
     * <code>resolutionId</code> is not specified, the current resolution status is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAppVersionResourcesResolutionStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAppVersionResourcesResolutionStatusRequest#builder()}
     * </p>
     *
     * @param describeAppVersionResourcesResolutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeAppVersionResourcesResolutionStatusRequest.Builder} to create a request.
     * @return Result of the DescribeAppVersionResourcesResolutionStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionResourcesResolutionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionResourcesResolutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppVersionResourcesResolutionStatusResponse describeAppVersionResourcesResolutionStatus(
            Consumer<DescribeAppVersionResourcesResolutionStatusRequest.Builder> describeAppVersionResourcesResolutionStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return describeAppVersionResourcesResolutionStatus(DescribeAppVersionResourcesResolutionStatusRequest.builder()
                .applyMutation(describeAppVersionResourcesResolutionStatusRequest).build());
    }

    /**
     * <p>
     * Describes details about an AWS Resilience Hub
     * </p>
     *
     * @param describeAppVersionTemplateRequest
     * @return Result of the DescribeAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppVersionTemplateResponse describeAppVersionTemplate(
            DescribeAppVersionTemplateRequest describeAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details about an AWS Resilience Hub
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppVersionTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAppVersionTemplateRequest#builder()}
     * </p>
     *
     * @param describeAppVersionTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppVersionTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAppVersionTemplateResponse describeAppVersionTemplate(
            Consumer<DescribeAppVersionTemplateRequest.Builder> describeAppVersionTemplateRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return describeAppVersionTemplate(DescribeAppVersionTemplateRequest.builder()
                .applyMutation(describeAppVersionTemplateRequest).build());
    }

    /**
     * <p>
     * Describes the status of importing resources to an application version.
     * </p>
     *
     * @param describeDraftAppVersionResourcesImportStatusRequest
     * @return Result of the DescribeDraftAppVersionResourcesImportStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeDraftAppVersionResourcesImportStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDraftAppVersionResourcesImportStatusResponse describeDraftAppVersionResourcesImportStatus(
            DescribeDraftAppVersionResourcesImportStatusRequest describeDraftAppVersionResourcesImportStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of importing resources to an application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDraftAppVersionResourcesImportStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDraftAppVersionResourcesImportStatusRequest#builder()}
     * </p>
     *
     * @param describeDraftAppVersionResourcesImportStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeDraftAppVersionResourcesImportStatusRequest.Builder} to create a request.
     * @return Result of the DescribeDraftAppVersionResourcesImportStatus operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeDraftAppVersionResourcesImportStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeDraftAppVersionResourcesImportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDraftAppVersionResourcesImportStatusResponse describeDraftAppVersionResourcesImportStatus(
            Consumer<DescribeDraftAppVersionResourcesImportStatusRequest.Builder> describeDraftAppVersionResourcesImportStatusRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return describeDraftAppVersionResourcesImportStatus(DescribeDraftAppVersionResourcesImportStatusRequest.builder()
                .applyMutation(describeDraftAppVersionResourcesImportStatusRequest).build());
    }

    /**
     * <p>
     * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object
     * includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and
     * more.
     * </p>
     *
     * @param describeResiliencyPolicyRequest
     * @return Result of the DescribeResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResiliencyPolicyResponse describeResiliencyPolicy(
            DescribeResiliencyPolicyRequest describeResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object
     * includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and
     * more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResiliencyPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeResiliencyPolicyRequest#builder()}
     * </p>
     *
     * @param describeResiliencyPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResiliencyPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.DescribeResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/DescribeResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResiliencyPolicyResponse describeResiliencyPolicy(
            Consumer<DescribeResiliencyPolicyRequest.Builder> describeResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return describeResiliencyPolicy(DescribeResiliencyPolicyRequest.builder().applyMutation(describeResiliencyPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a
     * draft application version.
     * </p>
     *
     * @param importResourcesToDraftAppVersionRequest
     * @return Result of the ImportResourcesToDraftAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ImportResourcesToDraftAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportResourcesToDraftAppVersionResponse importResourcesToDraftAppVersion(
            ImportResourcesToDraftAppVersionRequest importResourcesToDraftAppVersionRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a
     * draft application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportResourcesToDraftAppVersionRequest.Builder}
     * avoiding the need to create one manually via {@link ImportResourcesToDraftAppVersionRequest#builder()}
     * </p>
     *
     * @param importResourcesToDraftAppVersionRequest
     *        A {@link Consumer} that will call methods on {@link ImportResourcesToDraftAppVersionRequest.Builder} to
     *        create a request.
     * @return Result of the ImportResourcesToDraftAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ImportResourcesToDraftAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ImportResourcesToDraftAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportResourcesToDraftAppVersionResponse importResourcesToDraftAppVersion(
            Consumer<ImportResourcesToDraftAppVersionRequest.Builder> importResourcesToDraftAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return importResourcesToDraftAppVersion(ImportResourcesToDraftAppVersionRequest.builder()
                .applyMutation(importResourcesToDraftAppVersionRequest).build());
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return Result of the ListAlarmRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAlarmRecommendationsResponse listAlarmRecommendations(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAlarmRecommendationsRequest#builder()}
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlarmRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAlarmRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAlarmRecommendationsResponse listAlarmRecommendations(
            Consumer<ListAlarmRecommendationsRequest.Builder> listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listAlarmRecommendations(ListAlarmRecommendationsRequest.builder().applyMutation(listAlarmRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client
     *             .listAlarmRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAlarmRecommendationsIterable listAlarmRecommendationsPaginator(
            ListAlarmRecommendationsRequest listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client
     *             .listAlarmRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAlarmRecommendationsIterable responses = client.listAlarmRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAlarmRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAlarmRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlarmRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAlarmRecommendationsRequest#builder()}
     * </p>
     *
     * @param listAlarmRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlarmRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAlarmRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAlarmRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAlarmRecommendationsIterable listAlarmRecommendationsPaginator(
            Consumer<ListAlarmRecommendationsRequest.Builder> listAlarmRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listAlarmRecommendationsPaginator(ListAlarmRecommendationsRequest.builder()
                .applyMutation(listAlarmRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return Result of the ListAppAssessments operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAssessmentsResponse listAppAssessments(ListAppAssessmentsRequest listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAssessmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAppAssessmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppAssessmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppAssessments operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAssessmentsResponse listAppAssessments(Consumer<ListAppAssessmentsRequest.Builder> listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppAssessments(ListAppAssessmentsRequest.builder().applyMutation(listAppAssessmentsRequest).build());
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client
     *             .listAppAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAssessmentsIterable listAppAssessmentsPaginator(ListAppAssessmentsRequest listAppAssessmentsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results
     * for the response object.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client
     *             .listAppAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppAssessmentsIterable responses = client.listAppAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAssessments(software.amazon.awssdk.services.resiliencehub.model.ListAppAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAssessmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAssessmentsRequest#builder()}
     * </p>
     *
     * @param listAppAssessmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppAssessmentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAssessmentsIterable listAppAssessmentsPaginator(
            Consumer<ListAppAssessmentsRequest.Builder> listAppAssessmentsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listAppAssessmentsPaginator(ListAppAssessmentsRequest.builder().applyMutation(listAppAssessmentsRequest).build());
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return Result of the ListAppComponentCompliances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentCompliancesResponse listAppComponentCompliances(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppComponentCompliancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppComponentCompliancesRequest#builder()}
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppComponentCompliancesRequest.Builder} to create
     *        a request.
     * @return Result of the ListAppComponentCompliances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentCompliancesResponse listAppComponentCompliances(
            Consumer<ListAppComponentCompliancesRequest.Builder> listAppComponentCompliancesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppComponentCompliances(ListAppComponentCompliancesRequest.builder()
                .applyMutation(listAppComponentCompliancesRequest).build());
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client
     *             .listAppComponentCompliancesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentCompliancesIterable listAppComponentCompliancesPaginator(
            ListAppComponentCompliancesRequest listAppComponentCompliancesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the compliances for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client
     *             .listAppComponentCompliancesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentCompliancesIterable responses = client.listAppComponentCompliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentCompliances(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppComponentCompliancesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppComponentCompliancesRequest#builder()}
     * </p>
     *
     * @param listAppComponentCompliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppComponentCompliancesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentCompliances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentCompliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentCompliancesIterable listAppComponentCompliancesPaginator(
            Consumer<ListAppComponentCompliancesRequest.Builder> listAppComponentCompliancesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppComponentCompliancesPaginator(ListAppComponentCompliancesRequest.builder()
                .applyMutation(listAppComponentCompliancesRequest).build());
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return Result of the ListAppComponentRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentRecommendationsResponse listAppComponentRecommendations(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppComponentRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppComponentRecommendationsRequest#builder()}
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppComponentRecommendationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAppComponentRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentRecommendationsResponse listAppComponentRecommendations(
            Consumer<ListAppComponentRecommendationsRequest.Builder> listAppComponentRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppComponentRecommendations(ListAppComponentRecommendationsRequest.builder()
                .applyMutation(listAppComponentRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client
     *             .listAppComponentRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentRecommendationsIterable listAppComponentRecommendationsPaginator(
            ListAppComponentRecommendationsRequest listAppComponentRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendations for an AWS Resilience Hub component.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client
     *             .listAppComponentRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppComponentRecommendationsIterable responses = client.listAppComponentRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppComponentRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListAppComponentRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppComponentRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppComponentRecommendationsRequest#builder()}
     * </p>
     *
     * @param listAppComponentRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppComponentRecommendationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppComponentRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppComponentRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppComponentRecommendationsIterable listAppComponentRecommendationsPaginator(
            Consumer<ListAppComponentRecommendationsRequest.Builder> listAppComponentRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppComponentRecommendationsPaginator(ListAppComponentRecommendationsRequest.builder()
                .applyMutation(listAppComponentRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return Result of the ListAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourceMappingsResponse listAppVersionResourceMappings(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionResourceMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppVersionResourceMappingsRequest#builder()}
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionResourceMappingsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourceMappingsResponse listAppVersionResourceMappings(
            Consumer<ListAppVersionResourceMappingsRequest.Builder> listAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersionResourceMappings(ListAppVersionResourceMappingsRequest.builder()
                .applyMutation(listAppVersionResourceMappingsRequest).build());
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client
     *             .listAppVersionResourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourceMappingsIterable listAppVersionResourceMappingsPaginator(
            ListAppVersionResourceMappingsRequest listAppVersionResourceMappingsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource
     * identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client
     *             .listAppVersionResourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourceMappingsIterable responses = client.listAppVersionResourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResourceMappings(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourceMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionResourceMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAppVersionResourceMappingsRequest#builder()}
     * </p>
     *
     * @param listAppVersionResourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionResourceMappingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourceMappingsIterable listAppVersionResourceMappingsPaginator(
            Consumer<ListAppVersionResourceMappingsRequest.Builder> listAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersionResourceMappingsPaginator(ListAppVersionResourceMappingsRequest.builder()
                .applyMutation(listAppVersionResourceMappingsRequest).build());
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return Result of the ListAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourcesResponse listAppVersionResources(ListAppVersionResourcesRequest listAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAppVersionResourcesRequest#builder()}
     * </p>
     *
     * @param listAppVersionResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourcesResponse listAppVersionResources(
            Consumer<ListAppVersionResourcesRequest.Builder> listAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersionResources(ListAppVersionResourcesRequest.builder().applyMutation(listAppVersionResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client
     *             .listAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourcesIterable listAppVersionResourcesPaginator(
            ListAppVersionResourcesRequest listAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the resources in an application version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client
     *             .listAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionResourcesIterable responses = client.listAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAppVersionResourcesRequest#builder()}
     * </p>
     *
     * @param listAppVersionResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppVersionResourcesIterable listAppVersionResourcesPaginator(
            Consumer<ListAppVersionResourcesRequest.Builder> listAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersionResourcesPaginator(ListAppVersionResourcesRequest.builder()
                .applyMutation(listAppVersionResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     *
     * @param listAppVersionsRequest
     * @return Result of the ListAppVersions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppVersionsResponse listAppVersions(ListAppVersionsRequest listAppVersionsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAppVersionsRequest#builder()}
     * </p>
     *
     * @param listAppVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionsRequest.Builder} to create a request.
     * @return Result of the ListAppVersions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppVersionsResponse listAppVersions(Consumer<ListAppVersionsRequest.Builder> listAppVersionsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersions(ListAppVersionsRequest.builder().applyMutation(listAppVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client
     *             .listAppVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppVersionsIterable listAppVersionsPaginator(ListAppVersionsRequest listAppVersionsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the different versions for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client
     *             .listAppVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppVersionsIterable responses = client.listAppVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppVersions(software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAppVersionsRequest#builder()}
     * </p>
     *
     * @param listAppVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListAppVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListAppVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAppVersionsIterable listAppVersionsPaginator(Consumer<ListAppVersionsRequest.Builder> listAppVersionsRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listAppVersionsPaginator(ListAppVersionsRequest.builder().applyMutation(listAppVersionsRequest).build());
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     *
     * @param listAppsRequest
     * @return Result of the ListApps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsRequest.Builder} to create a request.
     * @return Result of the ListApps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsResponse listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)} operation.</b>
     * </p>
     *
     * @param listAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(ListAppsRequest listAppsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListAppsIterable responses = client.listAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApps(software.amazon.awssdk.services.resiliencehub.model.ListAppsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppsIterable listAppsPaginator(Consumer<ListAppsRequest.Builder> listAppsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        return listAppsPaginator(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return Result of the ListRecommendationTemplates operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationTemplatesResponse listRecommendationTemplates(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationTemplatesRequest#builder()}
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendationTemplatesRequest.Builder} to create
     *        a request.
     * @return Result of the ListRecommendationTemplates operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationTemplatesResponse listRecommendationTemplates(
            Consumer<ListRecommendationTemplatesRequest.Builder> listRecommendationTemplatesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listRecommendationTemplates(ListRecommendationTemplatesRequest.builder()
                .applyMutation(listRecommendationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client
     *             .listRecommendationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationTemplatesIterable listRecommendationTemplatesPaginator(
            ListRecommendationTemplatesRequest listRecommendationTemplatesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recommendation templates for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client
     *             .listRecommendationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListRecommendationTemplatesIterable responses = client.listRecommendationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationTemplates(software.amazon.awssdk.services.resiliencehub.model.ListRecommendationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationTemplatesRequest#builder()}
     * </p>
     *
     * @param listRecommendationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendationTemplatesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListRecommendationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListRecommendationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationTemplatesIterable listRecommendationTemplatesPaginator(
            Consumer<ListRecommendationTemplatesRequest.Builder> listRecommendationTemplatesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listRecommendationTemplatesPaginator(ListRecommendationTemplatesRequest.builder()
                .applyMutation(listRecommendationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return Result of the ListResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResiliencyPoliciesResponse listResiliencyPolicies(ListResiliencyPoliciesRequest listResiliencyPoliciesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResiliencyPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResiliencyPoliciesRequest#builder()}
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListResiliencyPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResiliencyPoliciesResponse listResiliencyPolicies(
            Consumer<ListResiliencyPoliciesRequest.Builder> listResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listResiliencyPolicies(ListResiliencyPoliciesRequest.builder().applyMutation(listResiliencyPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client
     *             .listResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResiliencyPoliciesIterable listResiliencyPoliciesPaginator(
            ListResiliencyPoliciesRequest listResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client
     *             .listResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListResiliencyPoliciesIterable responses = client.listResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResiliencyPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResiliencyPoliciesRequest#builder()}
     * </p>
     *
     * @param listResiliencyPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListResiliencyPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResiliencyPoliciesIterable listResiliencyPoliciesPaginator(
            Consumer<ListResiliencyPoliciesRequest.Builder> listResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listResiliencyPoliciesPaginator(ListResiliencyPoliciesRequest.builder()
                .applyMutation(listResiliencyPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return Result of the ListSopRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSopRecommendationsResponse listSopRecommendations(ListSopRecommendationsRequest listSopRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSopRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSopRecommendationsRequest#builder()}
     * </p>
     *
     * @param listSopRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSopRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSopRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSopRecommendationsResponse listSopRecommendations(
            Consumer<ListSopRecommendationsRequest.Builder> listSopRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listSopRecommendations(ListSopRecommendationsRequest.builder().applyMutation(listSopRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client
     *             .listSopRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSopRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSopRecommendationsIterable listSopRecommendationsPaginator(
            ListSopRecommendationsRequest listSopRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client
     *             .listSopRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSopRecommendationsIterable responses = client.listSopRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSopRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListSopRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSopRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSopRecommendationsRequest#builder()}
     * </p>
     *
     * @param listSopRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSopRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSopRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSopRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSopRecommendationsIterable listSopRecommendationsPaginator(
            Consumer<ListSopRecommendationsRequest.Builder> listSopRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listSopRecommendationsPaginator(ListSopRecommendationsRequest.builder()
                .applyMutation(listSopRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return Result of the ListSuggestedResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuggestedResiliencyPoliciesResponse listSuggestedResiliencyPolicies(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuggestedResiliencyPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListSuggestedResiliencyPoliciesRequest#builder()}
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListSuggestedResiliencyPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListSuggestedResiliencyPolicies operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuggestedResiliencyPoliciesResponse listSuggestedResiliencyPolicies(
            Consumer<ListSuggestedResiliencyPoliciesRequest.Builder> listSuggestedResiliencyPoliciesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listSuggestedResiliencyPolicies(ListSuggestedResiliencyPoliciesRequest.builder()
                .applyMutation(listSuggestedResiliencyPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client
     *             .listSuggestedResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuggestedResiliencyPoliciesIterable listSuggestedResiliencyPoliciesPaginator(
            ListSuggestedResiliencyPoliciesRequest listSuggestedResiliencyPoliciesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client
     *             .listSuggestedResiliencyPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListSuggestedResiliencyPoliciesIterable responses = client.listSuggestedResiliencyPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuggestedResiliencyPolicies(software.amazon.awssdk.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuggestedResiliencyPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListSuggestedResiliencyPoliciesRequest#builder()}
     * </p>
     *
     * @param listSuggestedResiliencyPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListSuggestedResiliencyPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListSuggestedResiliencyPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListSuggestedResiliencyPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSuggestedResiliencyPoliciesIterable listSuggestedResiliencyPoliciesPaginator(
            Consumer<ListSuggestedResiliencyPoliciesRequest.Builder> listSuggestedResiliencyPoliciesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listSuggestedResiliencyPoliciesPaginator(ListSuggestedResiliencyPoliciesRequest.builder()
                .applyMutation(listSuggestedResiliencyPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for your resources in your Resilience Hub applications.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for your resources in your Resilience Hub applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return Result of the ListTestRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestRecommendationsResponse listTestRecommendations(ListTestRecommendationsRequest listTestRecommendationsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTestRecommendationsRequest#builder()}
     * </p>
     *
     * @param listTestRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTestRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTestRecommendations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestRecommendationsResponse listTestRecommendations(
            Consumer<ListTestRecommendationsRequest.Builder> listTestRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listTestRecommendations(ListTestRecommendationsRequest.builder().applyMutation(listTestRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client
     *             .listTestRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestRecommendationsIterable listTestRecommendationsPaginator(
            ListTestRecommendationsRequest listTestRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the test recommendations for the Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client
     *             .listTestRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListTestRecommendationsIterable responses = client.listTestRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRecommendations(software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTestRecommendationsRequest#builder()}
     * </p>
     *
     * @param listTestRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTestRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListTestRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListTestRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestRecommendationsIterable listTestRecommendationsPaginator(
            Consumer<ListTestRecommendationsRequest.Builder> listTestRecommendationsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return listTestRecommendationsPaginator(ListTestRecommendationsRequest.builder()
                .applyMutation(listTestRecommendationsRequest).build());
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return Result of the ListUnsupportedAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUnsupportedAppVersionResourcesResponse listUnsupportedAppVersionResources(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUnsupportedAppVersionResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListUnsupportedAppVersionResourcesRequest#builder()}
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListUnsupportedAppVersionResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListUnsupportedAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUnsupportedAppVersionResourcesResponse listUnsupportedAppVersionResources(
            Consumer<ListUnsupportedAppVersionResourcesRequest.Builder> listUnsupportedAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesRequest.builder()
                .applyMutation(listUnsupportedAppVersionResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client
     *             .listUnsupportedAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUnsupportedAppVersionResourcesIterable listUnsupportedAppVersionResourcesPaginator(
            ListUnsupportedAppVersionResourcesRequest listUnsupportedAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource
     * that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client
     *             .listUnsupportedAppVersionResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resiliencehub.paginators.ListUnsupportedAppVersionResourcesIterable responses = client.listUnsupportedAppVersionResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUnsupportedAppVersionResources(software.amazon.awssdk.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUnsupportedAppVersionResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListUnsupportedAppVersionResourcesRequest#builder()}
     * </p>
     *
     * @param listUnsupportedAppVersionResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListUnsupportedAppVersionResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ListUnsupportedAppVersionResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ListUnsupportedAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUnsupportedAppVersionResourcesIterable listUnsupportedAppVersionResourcesPaginator(
            Consumer<ListUnsupportedAppVersionResourcesRequest.Builder> listUnsupportedAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return listUnsupportedAppVersionResourcesPaginator(ListUnsupportedAppVersionResourcesRequest.builder()
                .applyMutation(listUnsupportedAppVersionResourcesRequest).build());
    }

    /**
     * <p>
     * Publishes a new version of a specific Resilience Hub application.
     * </p>
     *
     * @param publishAppVersionRequest
     * @return Result of the PublishAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PublishAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default PublishAppVersionResponse publishAppVersion(PublishAppVersionRequest publishAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a new version of a specific Resilience Hub application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishAppVersionRequest.Builder} avoiding the need
     * to create one manually via {@link PublishAppVersionRequest#builder()}
     * </p>
     *
     * @param publishAppVersionRequest
     *        A {@link Consumer} that will call methods on {@link PublishAppVersionRequest.Builder} to create a request.
     * @return Result of the PublishAppVersion operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PublishAppVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PublishAppVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default PublishAppVersionResponse publishAppVersion(Consumer<PublishAppVersionRequest.Builder> publishAppVersionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return publishAppVersion(PublishAppVersionRequest.builder().applyMutation(publishAppVersionRequest).build());
    }

    /**
     * <p>
     * Adds or updates the app template for a draft version of a Resilience Hub app.
     * </p>
     *
     * @param putDraftAppVersionTemplateRequest
     * @return Result of the PutDraftAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PutDraftAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDraftAppVersionTemplateResponse putDraftAppVersionTemplate(
            PutDraftAppVersionTemplateRequest putDraftAppVersionTemplateRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the app template for a draft version of a Resilience Hub app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDraftAppVersionTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link PutDraftAppVersionTemplateRequest#builder()}
     * </p>
     *
     * @param putDraftAppVersionTemplateRequest
     *        A {@link Consumer} that will call methods on {@link PutDraftAppVersionTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the PutDraftAppVersionTemplate operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.PutDraftAppVersionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/PutDraftAppVersionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDraftAppVersionTemplateResponse putDraftAppVersionTemplate(
            Consumer<PutDraftAppVersionTemplateRequest.Builder> putDraftAppVersionTemplateRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return putDraftAppVersionTemplate(PutDraftAppVersionTemplateRequest.builder()
                .applyMutation(putDraftAppVersionTemplateRequest).build());
    }

    /**
     * <p>
     * Removes resource mappings from a draft application version.
     * </p>
     *
     * @param removeDraftAppVersionResourceMappingsRequest
     * @return Result of the RemoveDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.RemoveDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveDraftAppVersionResourceMappingsResponse removeDraftAppVersionResourceMappings(
            RemoveDraftAppVersionResourceMappingsRequest removeDraftAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes resource mappings from a draft application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RemoveDraftAppVersionResourceMappingsRequest.Builder} avoiding the need to create one manually via
     * {@link RemoveDraftAppVersionResourceMappingsRequest#builder()}
     * </p>
     *
     * @param removeDraftAppVersionResourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveDraftAppVersionResourceMappingsRequest.Builder}
     *        to create a request.
     * @return Result of the RemoveDraftAppVersionResourceMappings operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.RemoveDraftAppVersionResourceMappings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/RemoveDraftAppVersionResourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveDraftAppVersionResourceMappingsResponse removeDraftAppVersionResourceMappings(
            Consumer<RemoveDraftAppVersionResourceMappingsRequest.Builder> removeDraftAppVersionResourceMappingsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return removeDraftAppVersionResourceMappings(RemoveDraftAppVersionResourceMappingsRequest.builder()
                .applyMutation(removeDraftAppVersionResourceMappingsRequest).build());
    }

    /**
     * <p>
     * Resolves the resources for an application version.
     * </p>
     *
     * @param resolveAppVersionResourcesRequest
     * @return Result of the ResolveAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ResolveAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ResolveAppVersionResourcesResponse resolveAppVersionResources(
            ResolveAppVersionResourcesRequest resolveAppVersionResourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resolves the resources for an application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveAppVersionResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ResolveAppVersionResourcesRequest#builder()}
     * </p>
     *
     * @param resolveAppVersionResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ResolveAppVersionResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ResolveAppVersionResources operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.ResolveAppVersionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/ResolveAppVersionResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ResolveAppVersionResourcesResponse resolveAppVersionResources(
            Consumer<ResolveAppVersionResourcesRequest.Builder> resolveAppVersionResourcesRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return resolveAppVersionResources(ResolveAppVersionResourcesRequest.builder()
                .applyMutation(resolveAppVersionResourcesRequest).build());
    }

    /**
     * <p>
     * Creates a new application assessment for an application.
     * </p>
     *
     * @param startAppAssessmentRequest
     * @return Result of the StartAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.StartAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAppAssessmentResponse startAppAssessment(StartAppAssessmentRequest startAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new application assessment for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAppAssessmentRequest.Builder} avoiding the
     * need to create one manually via {@link StartAppAssessmentRequest#builder()}
     * </p>
     *
     * @param startAppAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link StartAppAssessmentRequest.Builder} to create a
     *        request.
     * @return Result of the StartAppAssessment operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.StartAppAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/StartAppAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAppAssessmentResponse startAppAssessment(Consumer<StartAppAssessmentRequest.Builder> startAppAssessmentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResiliencehubException {
        return startAppAssessment(StartAppAssessmentRequest.builder().applyMutation(startAppAssessmentRequest).build());
    }

    /**
     * <p>
     * Applies one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateAppRequest
     * @return Result of the UpdateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAppRequest#builder()}
     * </p>
     *
     * @param updateAppRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAppRequest.Builder} to create a request.
     * @return Result of the UpdateApp operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAppResponse updateApp(Consumer<UpdateAppRequest.Builder> updateAppRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return updateApp(UpdateAppRequest.builder().applyMutation(updateAppRequest).build());
    }

    /**
     * <p>
     * Updates a resiliency policy.
     * </p>
     *
     * @param updateResiliencyPolicyRequest
     * @return Result of the UpdateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResiliencyPolicyResponse updateResiliencyPolicy(UpdateResiliencyPolicyRequest updateResiliencyPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ResiliencehubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a resiliency policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResiliencyPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResiliencyPolicyRequest#builder()}
     * </p>
     *
     * @param updateResiliencyPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResiliencyPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResiliencyPolicy operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the AWS Resilience Hub service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Occurs when a conflict with a previous successful write is detected. This generally occurs when the
     *         previous write did not have time to propagate to the host serving the current request. A retry (with
     *         appropriate backoff logic) is the recommended response to this exception.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         Indicates that a request was not valid.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResiliencehubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResiliencehubClient.UpdateResiliencyPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/UpdateResiliencyPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResiliencyPolicyResponse updateResiliencyPolicy(
            Consumer<UpdateResiliencyPolicyRequest.Builder> updateResiliencyPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResiliencehubException {
        return updateResiliencyPolicy(UpdateResiliencyPolicyRequest.builder().applyMutation(updateResiliencyPolicyRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
