/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecommendationTemplateResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<CreateRecommendationTemplateResponse.Builder, CreateRecommendationTemplateResponse> {
    private static final SdkField<RecommendationTemplate> RECOMMENDATION_TEMPLATE_FIELD = SdkField
            .<RecommendationTemplate> builder(MarshallingType.SDK_POJO).memberName("recommendationTemplate")
            .getter(getter(CreateRecommendationTemplateResponse::recommendationTemplate))
            .setter(setter(Builder::recommendationTemplate)).constructor(RecommendationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RECOMMENDATION_TEMPLATE_FIELD));

    private final RecommendationTemplate recommendationTemplate;

    private CreateRecommendationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationTemplate = builder.recommendationTemplate;
    }

    /**
     * <p>
     * The newly created recommendation template, returned as an object. This object includes the template's name,
     * format, status, tags, Amazon S3 bucket location, and more.
     * </p>
     * 
     * @return The newly created recommendation template, returned as an object. This object includes the template's
     *         name, format, status, tags, Amazon S3 bucket location, and more.
     */
    public final RecommendationTemplate recommendationTemplate() {
        return recommendationTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommendationTemplateResponse)) {
            return false;
        }
        CreateRecommendationTemplateResponse other = (CreateRecommendationTemplateResponse) obj;
        return Objects.equals(recommendationTemplate(), other.recommendationTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecommendationTemplateResponse").add("RecommendationTemplate", recommendationTemplate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationTemplate":
            return Optional.ofNullable(clazz.cast(recommendationTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommendationTemplateResponse, T> g) {
        return obj -> g.apply((CreateRecommendationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRecommendationTemplateResponse> {
        /**
         * <p>
         * The newly created recommendation template, returned as an object. This object includes the template's name,
         * format, status, tags, Amazon S3 bucket location, and more.
         * </p>
         * 
         * @param recommendationTemplate
         *        The newly created recommendation template, returned as an object. This object includes the template's
         *        name, format, status, tags, Amazon S3 bucket location, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplate(RecommendationTemplate recommendationTemplate);

        /**
         * <p>
         * The newly created recommendation template, returned as an object. This object includes the template's name,
         * format, status, tags, Amazon S3 bucket location, and more.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationTemplate.Builder} avoiding
         * the need to create one manually via {@link RecommendationTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #recommendationTemplate(RecommendationTemplate)}.
         * 
         * @param recommendationTemplate
         *        a consumer that will call methods on {@link RecommendationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationTemplate(RecommendationTemplate)
         */
        default Builder recommendationTemplate(Consumer<RecommendationTemplate.Builder> recommendationTemplate) {
            return recommendationTemplate(RecommendationTemplate.builder().applyMutation(recommendationTemplate).build());
        }
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private RecommendationTemplate recommendationTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommendationTemplateResponse model) {
            super(model);
            recommendationTemplate(model.recommendationTemplate);
        }

        public final RecommendationTemplate.Builder getRecommendationTemplate() {
            return recommendationTemplate != null ? recommendationTemplate.toBuilder() : null;
        }

        public final void setRecommendationTemplate(RecommendationTemplate.BuilderImpl recommendationTemplate) {
            this.recommendationTemplate = recommendationTemplate != null ? recommendationTemplate.build() : null;
        }

        @Override
        public final Builder recommendationTemplate(RecommendationTemplate recommendationTemplate) {
            this.recommendationTemplate = recommendationTemplate;
            return this;
        }

        @Override
        public CreateRecommendationTemplateResponse build() {
            return new CreateRecommendationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
