/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUnsupportedAppVersionResourcesResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListUnsupportedAppVersionResourcesResponse.Builder, ListUnsupportedAppVersionResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUnsupportedAppVersionResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionId").getter(getter(ListUnsupportedAppVersionResourcesResponse::resolutionId))
            .setter(setter(Builder::resolutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()).build();

    private static final SdkField<List<UnsupportedResource>> UNSUPPORTED_RESOURCES_FIELD = SdkField
            .<List<UnsupportedResource>> builder(MarshallingType.LIST)
            .memberName("unsupportedResources")
            .getter(getter(ListUnsupportedAppVersionResourcesResponse::unsupportedResources))
            .setter(setter(Builder::unsupportedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsupportedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnsupportedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsupportedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOLUTION_ID_FIELD, UNSUPPORTED_RESOURCES_FIELD));

    private final String nextToken;

    private final String resolutionId;

    private final List<UnsupportedResource> unsupportedResources;

    private ListUnsupportedAppVersionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resolutionId = builder.resolutionId;
        this.unsupportedResources = builder.unsupportedResources;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The identifier for a specific resolution.
     * </p>
     * 
     * @return The identifier for a specific resolution.
     */
    public final String resolutionId() {
        return resolutionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsupportedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsupportedResources() {
        return unsupportedResources != null && !(unsupportedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unsupported resources for the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsupportedResources} method.
     * </p>
     * 
     * @return The unsupported resources for the application.
     */
    public final List<UnsupportedResource> unsupportedResources() {
        return unsupportedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsupportedResources() ? unsupportedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUnsupportedAppVersionResourcesResponse)) {
            return false;
        }
        ListUnsupportedAppVersionResourcesResponse other = (ListUnsupportedAppVersionResourcesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(resolutionId(), other.resolutionId())
                && hasUnsupportedResources() == other.hasUnsupportedResources()
                && Objects.equals(unsupportedResources(), other.unsupportedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUnsupportedAppVersionResourcesResponse").add("NextToken", nextToken())
                .add("ResolutionId", resolutionId())
                .add("UnsupportedResources", hasUnsupportedResources() ? unsupportedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resolutionId":
            return Optional.ofNullable(clazz.cast(resolutionId()));
        case "unsupportedResources":
            return Optional.ofNullable(clazz.cast(unsupportedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUnsupportedAppVersionResourcesResponse, T> g) {
        return obj -> g.apply((ListUnsupportedAppVersionResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUnsupportedAppVersionResourcesResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier for a specific resolution.
         * </p>
         * 
         * @param resolutionId
         *        The identifier for a specific resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionId(String resolutionId);

        /**
         * <p>
         * The unsupported resources for the application.
         * </p>
         * 
         * @param unsupportedResources
         *        The unsupported resources for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsupportedResources(Collection<UnsupportedResource> unsupportedResources);

        /**
         * <p>
         * The unsupported resources for the application.
         * </p>
         * 
         * @param unsupportedResources
         *        The unsupported resources for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsupportedResources(UnsupportedResource... unsupportedResources);

        /**
         * <p>
         * The unsupported resources for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UnsupportedResource>.Builder}
         * avoiding the need to create one manually via {@link List<UnsupportedResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnsupportedResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #unsupportedResources(List<UnsupportedResource>)}.
         * 
         * @param unsupportedResources
         *        a consumer that will call methods on {@link List<UnsupportedResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsupportedResources(List<UnsupportedResource>)
         */
        Builder unsupportedResources(Consumer<UnsupportedResource.Builder>... unsupportedResources);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String resolutionId;

        private List<UnsupportedResource> unsupportedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUnsupportedAppVersionResourcesResponse model) {
            super(model);
            nextToken(model.nextToken);
            resolutionId(model.resolutionId);
            unsupportedResources(model.unsupportedResources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResolutionId() {
            return resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        public final List<UnsupportedResource.Builder> getUnsupportedResources() {
            List<UnsupportedResource.Builder> result = UnsupportedResourceListCopier.copyToBuilder(this.unsupportedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsupportedResources(Collection<UnsupportedResource.BuilderImpl> unsupportedResources) {
            this.unsupportedResources = UnsupportedResourceListCopier.copyFromBuilder(unsupportedResources);
        }

        @Override
        public final Builder unsupportedResources(Collection<UnsupportedResource> unsupportedResources) {
            this.unsupportedResources = UnsupportedResourceListCopier.copy(unsupportedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsupportedResources(UnsupportedResource... unsupportedResources) {
            unsupportedResources(Arrays.asList(unsupportedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsupportedResources(Consumer<UnsupportedResource.Builder>... unsupportedResources) {
            unsupportedResources(Stream.of(unsupportedResources).map(c -> UnsupportedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUnsupportedAppVersionResourcesResponse build() {
            return new ListUnsupportedAppVersionResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
