/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a test recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<TestRecommendation.Builder, TestRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(TestRecommendation::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TestRecommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("intent")
            .getter(getter(TestRecommendation::intent)).setter(setter(Builder::intent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<List<RecommendationItem>> ITEMS_FIELD = SdkField
            .<List<RecommendationItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(TestRecommendation::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestRecommendation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PREREQUISITE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("prerequisite").getter(getter(TestRecommendation::prerequisite)).setter(setter(Builder::prerequisite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prerequisite").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(TestRecommendation::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceId").getter(getter(TestRecommendation::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("risk")
            .getter(getter(TestRecommendation::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("risk").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TestRecommendation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD,
            DESCRIPTION_FIELD, INTENT_FIELD, ITEMS_FIELD, NAME_FIELD, PREREQUISITE_FIELD, RECOMMENDATION_ID_FIELD,
            REFERENCE_ID_FIELD, RISK_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentName;

    private final String description;

    private final String intent;

    private final List<RecommendationItem> items;

    private final String name;

    private final String prerequisite;

    private final String recommendationId;

    private final String referenceId;

    private final String risk;

    private final String type;

    private TestRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.description = builder.description;
        this.intent = builder.intent;
        this.items = builder.items;
        this.name = builder.name;
        this.prerequisite = builder.prerequisite;
        this.recommendationId = builder.recommendationId;
        this.referenceId = builder.referenceId;
        this.risk = builder.risk;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the application component.
     * </p>
     * 
     * @return The name of the application component.
     */
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * <p>
     * The description for the test recommendation.
     * </p>
     * 
     * @return The description for the test recommendation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The intent of the test recommendation.
     * </p>
     * 
     * @return The intent of the test recommendation.
     */
    public final String intent() {
        return intent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The test recommendation items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The test recommendation items.
     */
    public final List<RecommendationItem> items() {
        return items;
    }

    /**
     * <p>
     * The name of the test recommendation.
     * </p>
     * 
     * @return The name of the test recommendation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The prerequisite of the test recommendation.
     * </p>
     * 
     * @return The prerequisite of the test recommendation.
     */
    public final String prerequisite() {
        return prerequisite;
    }

    /**
     * <p>
     * Identifier for the test recommendation.
     * </p>
     * 
     * @return Identifier for the test recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The reference identifier for the test recommendation.
     * </p>
     * 
     * @return The reference identifier for the test recommendation.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * The level of risk for this test recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link TestRisk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The level of risk for this test recommendation.
     * @see TestRisk
     */
    public final TestRisk risk() {
        return TestRisk.fromValue(risk);
    }

    /**
     * <p>
     * The level of risk for this test recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link TestRisk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The level of risk for this test recommendation.
     * @see TestRisk
     */
    public final String riskAsString() {
        return risk;
    }

    /**
     * <p>
     * The type of test recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of test recommendation.
     * @see TestType
     */
    public final TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The type of test recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of test recommendation.
     * @see TestType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(prerequisite());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRecommendation)) {
            return false;
        }
        TestRecommendation other = (TestRecommendation) obj;
        return Objects.equals(appComponentName(), other.appComponentName()) && Objects.equals(description(), other.description())
                && Objects.equals(intent(), other.intent()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(name(), other.name())
                && Objects.equals(prerequisite(), other.prerequisite())
                && Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(referenceId(), other.referenceId()) && Objects.equals(riskAsString(), other.riskAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestRecommendation").add("AppComponentName", appComponentName())
                .add("Description", description()).add("Intent", intent()).add("Items", hasItems() ? items() : null)
                .add("Name", name()).add("Prerequisite", prerequisite()).add("RecommendationId", recommendationId())
                .add("ReferenceId", referenceId()).add("Risk", riskAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "prerequisite":
            return Optional.ofNullable(clazz.cast(prerequisite()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "referenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRecommendation, T> g) {
        return obj -> g.apply((TestRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestRecommendation> {
        /**
         * <p>
         * The name of the application component.
         * </p>
         * 
         * @param appComponentName
         *        The name of the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * The description for the test recommendation.
         * </p>
         * 
         * @param description
         *        The description for the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The intent of the test recommendation.
         * </p>
         * 
         * @param intent
         *        The intent of the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(String intent);

        /**
         * <p>
         * The test recommendation items.
         * </p>
         * 
         * @param items
         *        The test recommendation items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RecommendationItem> items);

        /**
         * <p>
         * The test recommendation items.
         * </p>
         * 
         * @param items
         *        The test recommendation items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RecommendationItem... items);

        /**
         * <p>
         * The test recommendation items.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RecommendationItem>.Builder}
         * avoiding the need to create one manually via {@link List<RecommendationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<RecommendationItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<RecommendationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<RecommendationItem>)
         */
        Builder items(Consumer<RecommendationItem.Builder>... items);

        /**
         * <p>
         * The name of the test recommendation.
         * </p>
         * 
         * @param name
         *        The name of the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The prerequisite of the test recommendation.
         * </p>
         * 
         * @param prerequisite
         *        The prerequisite of the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prerequisite(String prerequisite);

        /**
         * <p>
         * Identifier for the test recommendation.
         * </p>
         * 
         * @param recommendationId
         *        Identifier for the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The reference identifier for the test recommendation.
         * </p>
         * 
         * @param referenceId
         *        The reference identifier for the test recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * The level of risk for this test recommendation.
         * </p>
         * 
         * @param risk
         *        The level of risk for this test recommendation.
         * @see TestRisk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRisk
         */
        Builder risk(String risk);

        /**
         * <p>
         * The level of risk for this test recommendation.
         * </p>
         * 
         * @param risk
         *        The level of risk for this test recommendation.
         * @see TestRisk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestRisk
         */
        Builder risk(TestRisk risk);

        /**
         * <p>
         * The type of test recommendation.
         * </p>
         * 
         * @param type
         *        The type of test recommendation.
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of test recommendation.
         * </p>
         * 
         * @param type
         *        The type of test recommendation.
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentName;

        private String description;

        private String intent;

        private List<RecommendationItem> items = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String prerequisite;

        private String recommendationId;

        private String referenceId;

        private String risk;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRecommendation model) {
            appComponentName(model.appComponentName);
            description(model.description);
            intent(model.intent);
            items(model.items);
            name(model.name);
            prerequisite(model.prerequisite);
            recommendationId(model.recommendationId);
            referenceId(model.referenceId);
            risk(model.risk);
            type(model.type);
        }

        public final String getAppComponentName() {
            return appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIntent() {
            return intent;
        }

        public final void setIntent(String intent) {
            this.intent = intent;
        }

        @Override
        public final Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public final List<RecommendationItem.Builder> getItems() {
            List<RecommendationItem.Builder> result = RecommendationItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationItem.BuilderImpl> items) {
            this.items = RecommendationItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationItem> items) {
            this.items = RecommendationItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationItem.Builder>... items) {
            items(Stream.of(items).map(c -> RecommendationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPrerequisite() {
            return prerequisite;
        }

        public final void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        @Override
        public final Builder prerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getRisk() {
            return risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(TestRisk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TestRecommendation build() {
            return new TestRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
