/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AppComplianceStatusType;
import software.amazon.awssdk.services.resiliencehub.model.AppStatusType;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class App
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, App> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(App.getter(App::appArn)).setter(App.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(App.getter(App::complianceStatusAsString)).setter(App.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(App.getter(App::creationTime)).setter(App.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(App.getter(App::description)).setter(App.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAppComplianceEvaluationTime").getter(App.getter(App::lastAppComplianceEvaluationTime)).setter(App.setter(Builder::lastAppComplianceEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAppComplianceEvaluationTime").build()}).build();
    private static final SdkField<Instant> LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastResiliencyScoreEvaluationTime").getter(App.getter(App::lastResiliencyScoreEvaluationTime)).setter(App.setter(Builder::lastResiliencyScoreEvaluationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResiliencyScoreEvaluationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(App.getter(App::name)).setter(App.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(App.getter(App::policyArn)).setter(App.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("resiliencyScore").getter(App.getter(App::resiliencyScore)).setter(App.setter(Builder::resiliencyScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(App.getter(App::statusAsString)).setter(App.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(App.getter(App::tags)).setter(App.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, COMPLIANCE_STATUS_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD, LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD, NAME_FIELD, POLICY_ARN_FIELD, RESILIENCY_SCORE_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String complianceStatus;
    private final Instant creationTime;
    private final String description;
    private final Instant lastAppComplianceEvaluationTime;
    private final Instant lastResiliencyScoreEvaluationTime;
    private final String name;
    private final String policyArn;
    private final Double resiliencyScore;
    private final String status;
    private final Map<String, String> tags;

    private App(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.complianceStatus = builder.complianceStatus;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.lastAppComplianceEvaluationTime = builder.lastAppComplianceEvaluationTime;
        this.lastResiliencyScoreEvaluationTime = builder.lastResiliencyScoreEvaluationTime;
        this.name = builder.name;
        this.policyArn = builder.policyArn;
        this.resiliencyScore = builder.resiliencyScore;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppComplianceStatusType complianceStatus() {
        return AppComplianceStatusType.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastAppComplianceEvaluationTime() {
        return this.lastAppComplianceEvaluationTime;
    }

    public final Instant lastResiliencyScoreEvaluationTime() {
        return this.lastResiliencyScoreEvaluationTime;
    }

    public final String name() {
        return this.name;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final Double resiliencyScore() {
        return this.resiliencyScore;
    }

    public final AppStatusType status() {
        return AppStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAppComplianceEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastResiliencyScoreEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastAppComplianceEvaluationTime(), other.lastAppComplianceEvaluationTime()) && Objects.equals(this.lastResiliencyScoreEvaluationTime(), other.lastResiliencyScoreEvaluationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"App").add("AppArn", (Object)this.appArn()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("LastAppComplianceEvaluationTime", (Object)this.lastAppComplianceEvaluationTime()).add("LastResiliencyScoreEvaluationTime", (Object)this.lastResiliencyScoreEvaluationTime()).add("Name", (Object)this.name()).add("PolicyArn", (Object)this.policyArn()).add("ResiliencyScore", (Object)this.resiliencyScore()).add("Status", (Object)this.statusAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastAppComplianceEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastAppComplianceEvaluationTime()));
            }
            case "lastResiliencyScoreEvaluationTime": {
                return Optional.ofNullable(clazz.cast(this.lastResiliencyScoreEvaluationTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String complianceStatus;
        private Instant creationTime;
        private String description;
        private Instant lastAppComplianceEvaluationTime;
        private Instant lastResiliencyScoreEvaluationTime;
        private String name;
        private String policyArn;
        private Double resiliencyScore;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            this.appArn(model.appArn);
            this.complianceStatus(model.complianceStatus);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.lastAppComplianceEvaluationTime(model.lastAppComplianceEvaluationTime);
            this.lastResiliencyScoreEvaluationTime(model.lastResiliencyScoreEvaluationTime);
            this.name(model.name);
            this.policyArn(model.policyArn);
            this.resiliencyScore(model.resiliencyScore);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(AppComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastAppComplianceEvaluationTime() {
            return this.lastAppComplianceEvaluationTime;
        }

        public final void setLastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
        }

        @Override
        public final Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
            return this;
        }

        public final Instant getLastResiliencyScoreEvaluationTime() {
            return this.lastResiliencyScoreEvaluationTime;
        }

        public final void setLastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
        }

        @Override
        public final Builder lastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Double getResiliencyScore() {
            return this.resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public App build() {
            return new App(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, App> {
        public Builder appArn(String var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(AppComplianceStatusType var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder lastAppComplianceEvaluationTime(Instant var1);

        public Builder lastResiliencyScoreEvaluationTime(Instant var1);

        public Builder name(String var1);

        public Builder policyArn(String var1);

        public Builder resiliencyScore(Double var1);

        public Builder status(String var1);

        public Builder status(AppStatusType var1);

        public Builder tags(Map<String, String> var1);
    }
}

