/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ArnListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceImportStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportResourcesToDraftAppVersionResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ImportResourcesToDraftAppVersionResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ImportResourcesToDraftAppVersionResponse.getter(ImportResourcesToDraftAppVersionResponse::appArn)).setter(ImportResourcesToDraftAppVersionResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(ImportResourcesToDraftAppVersionResponse.getter(ImportResourcesToDraftAppVersionResponse::appVersion)).setter(ImportResourcesToDraftAppVersionResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceArns").getter(ImportResourcesToDraftAppVersionResponse.getter(ImportResourcesToDraftAppVersionResponse::sourceArns)).setter(ImportResourcesToDraftAppVersionResponse.setter(Builder::sourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImportResourcesToDraftAppVersionResponse.getter(ImportResourcesToDraftAppVersionResponse::statusAsString)).setter(ImportResourcesToDraftAppVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, SOURCE_ARNS_FIELD, STATUS_FIELD));
    private final String appArn;
    private final String appVersion;
    private final List<String> sourceArns;
    private final String status;

    private ImportResourcesToDraftAppVersionResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.sourceArns = builder.sourceArns;
        this.status = builder.status;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final boolean hasSourceArns() {
        return this.sourceArns != null && !(this.sourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> sourceArns() {
        return this.sourceArns;
    }

    public final ResourceImportStatusType status() {
        return ResourceImportStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceArns() ? this.sourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionResponse)) {
            return false;
        }
        ImportResourcesToDraftAppVersionResponse other = (ImportResourcesToDraftAppVersionResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasSourceArns() == other.hasSourceArns() && Objects.equals(this.sourceArns(), other.sourceArns()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportResourcesToDraftAppVersionResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("SourceArns", this.hasSourceArns() ? this.sourceArns() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "sourceArns": {
                return Optional.ofNullable(clazz.cast(this.sourceArns()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionResponse, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.sourceArns(model.sourceArns);
            this.status(model.status);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (this.sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceArns(String ... sourceArns) {
            this.sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceImportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionResponse build() {
            return new ImportResourcesToDraftAppVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportResourcesToDraftAppVersionResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder sourceArns(Collection<String> var1);

        public Builder sourceArns(String ... var1);

        public Builder status(String var1);

        public Builder status(ResourceImportStatusType var1);
    }
}

