/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplateStatus;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplateStatusListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationTemplatesRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, ListRecommendationTemplatesRequest> {
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::assessmentArn)).setter(ListRecommendationTemplatesRequest.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::maxResults)).setter(ListRecommendationTemplatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::name)).setter(ListRecommendationTemplatesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::nextToken)).setter(ListRecommendationTemplatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationTemplateArn").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::recommendationTemplateArn)).setter(ListRecommendationTemplatesRequest.setter(Builder::recommendationTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recommendationTemplateArn").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::reverseOrder)).setter(ListRecommendationTemplatesRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reverseOrder").build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("status").getter(ListRecommendationTemplatesRequest.getter(ListRecommendationTemplatesRequest::statusAsStrings)).setter(ListRecommendationTemplatesRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ARN_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, RECOMMENDATION_TEMPLATE_ARN_FIELD, REVERSE_ORDER_FIELD, STATUS_FIELD));
    private final String assessmentArn;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final String recommendationTemplateArn;
    private final Boolean reverseOrder;
    private final List<String> status;

    private ListRecommendationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentArn = builder.assessmentArn;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
        this.reverseOrder = builder.reverseOrder;
        this.status = builder.status;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String recommendationTemplateArn() {
        return this.recommendationTemplateArn;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    public final List<RecommendationTemplateStatus> status() {
        return RecommendationTemplateStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationTemplatesRequest)) {
            return false;
        }
        ListRecommendationTemplatesRequest other = (ListRecommendationTemplatesRequest)((Object)obj);
        return Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.recommendationTemplateArn(), other.recommendationTemplateArn()) && Objects.equals(this.reverseOrder(), other.reverseOrder()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationTemplatesRequest").add("AssessmentArn", (Object)this.assessmentArn()).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)this.name()).add("NextToken", (Object)this.nextToken()).add("RecommendationTemplateArn", (Object)this.recommendationTemplateArn()).add("ReverseOrder", (Object)this.reverseOrder()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "recommendationTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationTemplateArn()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationTemplatesRequest, T> g) {
        return obj -> g.apply((ListRecommendationTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String assessmentArn;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private String recommendationTemplateArn;
        private Boolean reverseOrder;
        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationTemplatesRequest model) {
            super(model);
            this.assessmentArn(model.assessmentArn);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.recommendationTemplateArn(model.recommendationTemplateArn);
            this.reverseOrder(model.reverseOrder);
            this.statusWithStrings(model.status);
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRecommendationTemplateArn() {
            return this.recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = RecommendationTemplateStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = RecommendationTemplateStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<RecommendationTemplateStatus> status) {
            this.status = RecommendationTemplateStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(RecommendationTemplateStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationTemplatesRequest build() {
            return new ListRecommendationTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationTemplatesRequest> {
        public Builder assessmentArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder recommendationTemplateArn(String var1);

        public Builder reverseOrder(Boolean var1);

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<RecommendationTemplateStatus> var1);

        public Builder status(RecommendationTemplateStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

